/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryMonitor
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DirectoryMonitor.class.getName());
    private boolean stopped = false;
    protected final File dir;
    protected final Callback callback;
    private final Map<String, FileInfo> existFiles = new TreeMap<String, FileInfo>();
    protected static final long LOOKUP_PERIOD = 1000L;

    public DirectoryMonitor(File dir, Callback callback) {
        this.dir = dir;
        this.callback = callback;
    }

    public File getDir() {
        return this.dir;
    }

    public void fin() {
        this.stopped = true;
    }

    @Override
    public void run() {
        this.setName(this.getClass().getSimpleName());
        this.setPriority(1);
        while (!this.stopped) {
            this.checkChanges();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.stopped = true;
            }
        }
    }

    public void checkChanges() {
        for (String fn : new ArrayList<String>(this.existFiles.keySet())) {
            if (this.stopped) {
                return;
            }
            File f = new File(fn);
            if (!f.exists()) {
                LOGGER.finer("File '" + f + "' removed");
                this.existFiles.remove(fn);
                this.callback.fileChanged(f);
                continue;
            }
            FileInfo fi = new FileInfo(f);
            if (fi.equals(this.existFiles.get(fn))) continue;
            LOGGER.finer("File '" + f + "' changed");
            this.existFiles.put(fn, fi);
            this.callback.fileChanged(f);
        }
        ArrayList<File> foundFiles = new ArrayList<File>();
        this.readDir(this.dir, foundFiles);
        for (File f : foundFiles) {
            if (this.stopped) {
                return;
            }
            String fn = f.getPath();
            if (this.existFiles.keySet().contains(fn)) continue;
            LOGGER.finer("File '" + f + "' added");
            this.existFiles.put(fn, new FileInfo(f));
            this.callback.fileChanged(f);
        }
    }

    protected void readDir(File dir, List<File> found) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.readDir(f, found);
                    continue;
                }
                found.add(f);
            }
        }
    }

    public static interface Callback {
        public void fileChanged(File var1);
    }

    protected class FileInfo {
        public long lastModified;
        public long length;

        public FileInfo(File file) {
            this.lastModified = file.lastModified();
            this.length = file.length();
        }

        public boolean equals(Object obj) {
            FileInfo o = (FileInfo)obj;
            return this.lastModified == o.lastModified && this.length == o.length;
        }
    }
}

