/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.tagvalidation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.gui.HListener;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagValidationFrame
extends JFrame {
    private JEditorPane m_editorPane;
    private List<SourceTextEntry> stringList;

    public TagValidationFrame(MainWindow parent) {
        this.setTitle(OStrings.getString("TF_NOTICE_BAD_TAGS"));
        this.initWindowLayout();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TagValidationFrame.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        JButton closeButton = new JButton();
        Mnemonics.setLocalizedText(closeButton, OStrings.getString("BUTTON_CLOSE"));
        closeButton.addActionListener(escapeAction);
        this.m_editorPane = new JEditorPane();
        this.m_editorPane.setEditable(false);
        this.m_editorPane.addHyperlinkListener(new HListener(parent, true));
        JScrollPane scroller = new JScrollPane(this.m_editorPane);
        Box bbut = Box.createHorizontalBox();
        bbut.add(Box.createHorizontalGlue());
        bbut.add(closeButton);
        bbut.add(Box.createHorizontalGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scroller, "Center");
        this.getContentPane().add((Component)bbut, "South");
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font newFont) {
                TagValidationFrame.this.setFont(newFont);
            }
        });
        this.setFont(Core.getMainWindow().getApplicationFont());
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.isVisible()) {
            this.update();
        }
    }

    private void initWindowLayout() {
        try {
            String dx = Preferences.getPreference("tagv_window_x");
            String dy = Preferences.getPreference("tagv_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.setLocation(x, y);
            String dw = Preferences.getPreference("tagv_window_width");
            String dh = Preferences.getPreference("tagv_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            this.setSize(650, 700);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("tagv_window_width", this.getWidth());
        Preferences.setPreference("tagv_window_height", this.getHeight());
        Preferences.setPreference("tagv_window_x", this.getX());
        Preferences.setPreference("tagv_window_y", this.getY());
    }

    @Override
    public void processWindowEvent(WindowEvent w) {
        int evt = w.getID();
        if (evt == 201 || evt == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(w);
    }

    private void doCancel() {
        this.dispose();
    }

    private String htmlize(String str) {
        String htmld = str;
        htmld = htmld.replaceAll("\\<", "&lt;");
        htmld = htmld.replaceAll("\\>", "&gt;");
        htmld = htmld.replaceAll("\n", "<br>");
        return htmld;
    }

    private String colorTags(String str, String color, Pattern placeholderPattern, Pattern removePattern) {
        String htmlResult = this.formatRemoveTagsAndPlaceholders(str, color, placeholderPattern, removePattern);
        Matcher lfMatch = PatternConsts.HTML_BR.matcher(htmlResult);
        htmlResult = lfMatch.replaceAll("<font color=\"" + color + "\"><sup>L</sup>F<br></font>");
        return htmlResult;
    }

    private String formatPlaceholders(String str, String color, Pattern placeholderPattern) {
        Matcher placeholderMatcher = placeholderPattern.matcher(str);
        String htmlResult = "";
        int pos = 0;
        while (placeholderMatcher.find()) {
            htmlResult = htmlResult + this.htmlize(str.substring(pos, placeholderMatcher.start()));
            htmlResult = htmlResult + "<font color=\"" + color + "\"><b>" + this.htmlize(placeholderMatcher.group(0)) + "</b></font>";
            pos = placeholderMatcher.end();
        }
        htmlResult = htmlResult + this.htmlize(str.substring(pos));
        return htmlResult;
    }

    private String formatRemoveTagsAndPlaceholders(String str, String color, Pattern placeholderPattern, Pattern removePattern) {
        if (removePattern != null) {
            Matcher removeMatcher = removePattern.matcher(str);
            String htmlResult = "";
            int pos = 0;
            while (removeMatcher.find()) {
                htmlResult = htmlResult + this.formatPlaceholders(str.substring(pos, removeMatcher.start()), color, placeholderPattern);
                htmlResult = htmlResult + "<font color=\"red\"><b>" + this.htmlize(removeMatcher.group(0)) + "</b></font>";
                pos = removeMatcher.end();
            }
            htmlResult = htmlResult + this.formatPlaceholders(str.substring(pos), color, placeholderPattern);
            return htmlResult;
        }
        return this.formatPlaceholders(str, color, placeholderPattern);
    }

    public void displayStringList(List<SourceTextEntry> stringList) {
        this.stringList = stringList;
        this.update();
    }

    private void update() {
        Pattern placeholderPattern = PatternConsts.getPlaceholderPattern();
        Pattern removePattern = PatternConsts.getRemovePattern();
        StringBuffer output = new StringBuffer();
        output.append("<html>\n");
        output.append("<head>\n");
        output.append("<style>\n");
        output.append("<style type=\"text/css\">\n");
        output.append("    <!--\n");
        output.append("    body {\n");
        output.append("            font-family: " + this.getFont().getName() + ";\n");
        output.append("            font-size: " + this.getFont().getSize() + "pt;\n");
        output.append("    }\n");
        output.append("    td {\n");
        output.append("            border: 1px solid gray;\n");
        output.append("    }\n");
        output.append("    -->\n");
        output.append("</style>\n");
        output.append("</head>\n");
        output.append("<body>\n");
        output.append("<table border=\"1\" cellspacing=\"1\" cellpadding=\"2\" width=\"100%\">\n");
        for (SourceTextEntry ste : this.stringList) {
            String src = ste.getSrcText();
            TMXEntry trans = Core.getProject().getTranslationInfo(ste);
            if (src.length() <= 0 || !trans.isTranslated()) continue;
            output.append("<tr>");
            output.append("<td>");
            output.append("<a href=");
            output.append("\"");
            output.append(ste.entryNum());
            output.append("\"");
            output.append(">");
            output.append(ste.entryNum());
            output.append("</a>");
            output.append("</td>");
            output.append("<td>");
            output.append(this.colorTags(src, "blue", placeholderPattern, null));
            output.append("</td>");
            output.append("<td>");
            output.append(this.colorTags(trans.translation, "blue", placeholderPattern, removePattern));
            output.append("</td>");
            output.append("</tr>\n");
        }
        output.append("</table>\n");
        output.append("</body>\n");
        output.append("</html>\n");
        this.m_editorPane.setContentType("text/html");
        this.m_editorPane.setText(output.toString());
    }
}

