/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.DiffDriver;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.NearString;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.matches.FindMatchesThread;
import org.omegat.gui.matches.IMatcher;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchesTextArea
extends EntryInfoThreadPane<List<NearString>>
implements IMatcher {
    private static final String EXPLANATION = OStrings.getString("GUI_MATCHWINDOW_explanation");
    private static final AttributeSet ATTRIBUTES_EMPTY = Styles.createAttributeSet(null, null, null, null);
    private static final AttributeSet ATTRIBUTES_CHANGED = Styles.createAttributeSet(Color.blue, null, null, null);
    private static final AttributeSet ATTRIBUTES_UNCHANGED = Styles.createAttributeSet(Color.green, null, null, null);
    private static final AttributeSet ATTRIBUTES_SELECTED = Styles.createAttributeSet(null, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_ACTIVE = Styles.createAttributeSet(null, null, true, null, true, null);
    private static final AttributeSet ATTRIBUTES_DELETED_INACTIVE = Styles.createAttributeSet(null, null, null, null, true, null);
    private static final AttributeSet ATTRIBUTES_INSERTED_ACTIVE = Styles.createAttributeSet(Color.blue, null, true, null, null, true);
    private static final AttributeSet ATTRIBUTES_INSERTED_INACTIVE = Styles.createAttributeSet(Color.gray, null, null, null, null, true);
    private final List<NearString> matches = new ArrayList<NearString>();
    private final List<Integer> delimiters = new ArrayList<Integer>();
    private final List<Integer> sourcePos = new ArrayList<Integer>();
    private final List<Integer> diffPos = new ArrayList<Integer>();
    private final List<List<DiffDriver.TextRun>> diffInfos = new ArrayList<List<DiffDriver.TextRun>>();
    private int activeMatch;
    private final MainWindow mw;
    protected MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            if (MatchesTextArea.this.matches == null || MatchesTextArea.this.matches.isEmpty()) {
                return;
            }
            int clickedItem = -1;
            int mousepos = MatchesTextArea.this.viewToModel(e.getPoint());
            for (int i = 0; i < MatchesTextArea.this.delimiters.size() - 1; ++i) {
                int start = (Integer)MatchesTextArea.this.delimiters.get(i);
                int end = (Integer)MatchesTextArea.this.delimiters.get(i + 1);
                if (mousepos < start || mousepos >= end) continue;
                clickedItem = i;
                break;
            }
            if (clickedItem == -1) {
                clickedItem = MatchesTextArea.this.delimiters.size() - 1;
            }
            if (clickedItem >= MatchesTextArea.this.matches.size()) {
                return;
            }
            if (e.isPopupTrigger() || e.getButton() == 3) {
                MatchesTextArea.this.mouseRightClick(clickedItem, e.getPoint());
            }
            if (e.getButton() == 1 && e.getClickCount() > 1) {
                MatchesTextArea.this.setActiveMatch(clickedItem);
            }
        }
    };

    public MatchesTextArea(MainWindow mw) {
        super(true);
        this.mw = mw;
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Fuzzy_Matches");
        Core.getMainWindow().addDockable(new DockableScrollPane("MATCHES", title, this, true));
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        this.addMouseListener(this.mouseListener);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new FindMatchesThread(this, Core.getProject(), newEntry).start();
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, List<NearString> newMatches) {
        UIThreadsUtil.mustBeSwingThread();
        this.activeMatch = -1;
        this.matches.clear();
        this.delimiters.clear();
        this.sourcePos.clear();
        this.diffPos.clear();
        this.diffInfos.clear();
        if (newMatches == null) {
            this.setText("");
            return;
        }
        this.matches.addAll(newMatches);
        this.delimiters.add(0);
        StringBuffer displayBuffer = new StringBuffer();
        MatchesVarExpansion template = new MatchesVarExpansion(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}) ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>"));
        for (int i = 0; i < newMatches.size(); ++i) {
            NearString match = newMatches.get(i);
            MatchesVarExpansion.Result result = template.apply(match, i + 1);
            displayBuffer.append(result.text);
            this.sourcePos.add(result.sourcePos);
            this.diffPos.add(result.diffPos);
            this.diffInfos.add(result.diffInfo);
            if (i < newMatches.size() - 1) {
                displayBuffer.append("\n\n");
            }
            this.delimiters.add(displayBuffer.length());
        }
        this.setText(displayBuffer.toString());
        this.setActiveMatch(0);
        this.checkForReplaceTranslation();
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
    }

    @Override
    public NearString getActiveMatch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.activeMatch < 0 || this.activeMatch >= this.matches.size()) {
            return null;
        }
        return this.matches.get(this.activeMatch);
    }

    @Override
    public String substituteNumbers(String source, String sourceMatch, String targetMatch) {
        ITokenizer sourceTok = Core.getProject().getSourceTokenizer();
        ITokenizer targetTok = Core.getProject().getTargetTokenizer();
        Token[] sourceMatchStrTokensAll = sourceTok.tokenizeAllExactly(sourceMatch);
        List<String> sourceMatchNumbers = this.getNumberList(sourceMatchStrTokensAll, sourceMatch);
        Token[] targetMatchStrTokensAll = targetTok.tokenizeAllExactly(targetMatch);
        List<String> targetMatchNumbers = this.getNumberList(targetMatchStrTokensAll, targetMatch);
        Token[] sourceStrTokensAll = sourceTok.tokenizeAllExactly(source);
        List<String> sourceNumbers = this.getNumberList(sourceStrTokensAll, source);
        if (sourceMatchNumbers.size() != targetMatchNumbers.size() || sourceMatchNumbers.size() != sourceNumbers.size()) {
            return targetMatch;
        }
        ArrayList<Integer> matchingNumbers = new ArrayList<Integer>();
        ArrayList<Integer> foundLocation = new ArrayList<Integer>();
        for (String oneNumber : sourceMatchNumbers) {
            int pos = -1;
            for (Token oneToken : targetMatchStrTokensAll) {
                if (!oneNumber.equals(oneToken.getTextFromString(targetMatch)) || foundLocation.contains(++pos)) continue;
                matchingNumbers.add(pos);
                foundLocation.add(pos);
            }
            if (pos != -1) continue;
            return targetMatch;
        }
        String finalString = "";
        int pos = -1;
        for (Token oneToken : targetMatchStrTokensAll) {
            ++pos;
            boolean replaced = false;
            for (int numberRank = 0; numberRank < matchingNumbers.size(); ++numberRank) {
                if ((Integer)matchingNumbers.get(numberRank) != pos) continue;
                finalString = finalString + sourceNumbers.get(numberRank);
                replaced = true;
            }
            if (replaced) continue;
            finalString = finalString + oneToken.getTextFromString(targetMatch);
        }
        return finalString;
    }

    private List<String> getNumberList(Token[] strTokenAll, String text) {
        ArrayList<String> numberList = new ArrayList<String>();
        for (Token oneToken : strTokenAll) {
            try {
                Integer.parseInt(oneToken.getTextFromString(text));
                numberList.add(oneToken.getTextFromString(text));
            }
            catch (NumberFormatException nfe) {
                try {
                    Double.parseDouble(oneToken.getTextFromString(text));
                    numberList.add(oneToken.getTextFromString(text));
                }
                catch (NumberFormatException nfe2) {
                    // empty catch block
                }
            }
        }
        return numberList;
    }

    private void checkForReplaceTranslation() {
        if (this.matches.isEmpty()) {
            return;
        }
        if (Preferences.isPreference("wf_insertBestMatch")) {
            String percentage_s = Preferences.getPreferenceDefault("wf_minimalSimilarity", "80");
            int percentage = 0;
            try {
                percentage = Integer.parseInt(percentage_s);
            }
            catch (Exception exception) {
                Log.log("ERROR: exception while parsing percentage:");
                Log.log("Please report to the OmegaT developers (omegat-development@lists.sourceforge.net)");
                Log.log(exception);
                return;
            }
            NearString thebest = this.matches.get(0);
            if (thebest.score >= percentage) {
                SourceTextEntry currentEntry = Core.getEditor().getCurrentEntry();
                TMXEntry te = Core.getProject().getTranslationInfo(currentEntry);
                if (!te.isTranslated()) {
                    String prefix = "";
                    if (!Preferences.getPreferenceDefaultAllowEmptyString("wf_explanatoryText").equals("")) {
                        prefix = Preferences.getPreferenceDefault("wf_explanatoryText", OStrings.getString("WF_DEFAULT_PREFIX"));
                    }
                    String translation = thebest.translation;
                    if (Preferences.isPreference("wf_convertNumbers")) {
                        translation = this.substituteNumbers(currentEntry.getSrcText(), thebest.source, thebest.translation);
                    }
                    Core.getEditor().replaceEditText(prefix + translation);
                }
            }
        }
    }

    @Override
    public void setActiveMatch(int activeMatch) {
        int tokstart;
        UIThreadsUtil.mustBeSwingThread();
        if (activeMatch < 0 || activeMatch >= this.matches.size() || this.activeMatch == activeMatch) {
            return;
        }
        this.activeMatch = activeMatch;
        StyledDocument doc = (StyledDocument)this.getDocument();
        doc.setCharacterAttributes(0, doc.getLength(), ATTRIBUTES_EMPTY, true);
        int start = this.delimiters.get(activeMatch);
        int end = this.delimiters.get(activeMatch + 1);
        NearString match = this.matches.get(activeMatch);
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        if (tokenizer == null) {
            return;
        }
        if (this.sourcePos.get(activeMatch) != -1) {
            Token[] tokens = tokenizer.tokenizeAllExactly(match.source);
            byte[] attributes = match.attr;
            for (int i = 0; i < tokens.length; ++i) {
                Token token = tokens[i];
                tokstart = start + this.sourcePos.get(activeMatch) + token.getOffset();
                int toklength = token.getLength();
                if ((attributes[i] & 1) != 0) {
                    doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_CHANGED, false);
                    continue;
                }
                if ((attributes[i] & 2) == 0) continue;
                doc.setCharacterAttributes(tokstart, toklength, ATTRIBUTES_UNCHANGED, false);
            }
        }
        for (int i = 0; i < this.diffPos.size(); ++i) {
            List<DiffDriver.TextRun> diffInfo = this.diffInfos.get(i);
            if (this.diffPos.get(i) == -1 || diffInfo == null) continue;
            for (DiffDriver.TextRun r : diffInfo) {
                tokstart = this.delimiters.get(i) + this.diffPos.get(i) + r.start;
                switch (r.type) {
                    case DELETE: {
                        doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_DELETED_ACTIVE : ATTRIBUTES_DELETED_INACTIVE, false);
                        break;
                    }
                    case INSERT: {
                        doc.setCharacterAttributes(tokstart, r.length, i == activeMatch ? ATTRIBUTES_INSERTED_ACTIVE : ATTRIBUTES_INSERTED_INACTIVE, false);
                    }
                }
            }
        }
        doc.setCharacterAttributes(start, end - start, ATTRIBUTES_SELECTED, false);
        this.setCaretPosition(end - 2);
        int fstart = start;
        this.setCaretPosition(fstart);
    }

    public void clear() {
        UIThreadsUtil.mustBeSwingThread();
        this.setFoundResult((SourceTextEntry)null, (List<NearString>)new ArrayList<NearString>());
    }

    private void mouseOneClick(int clickedItem, Point clickedPoint) {
    }

    private void mouseRightClick(final int clickedItem, Point clickedPoint) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = popup.add(OStrings.getString("MATCHES_INSERT"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchesTextArea.this.setActiveMatch(clickedItem);
                MatchesTextArea.this.mw.doInsertTrans();
            }
        });
        item = popup.add(OStrings.getString("MATCHES_REPLACE"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MatchesTextArea.this.setActiveMatch(clickedItem);
                MatchesTextArea.this.mw.doRecycleTrans();
            }
        });
        popup.addSeparator();
        final NearString ns = this.matches.get(clickedItem);
        String proj = ns.proj;
        item = popup.add(OStrings.getString("MATCHES_GO_TO_SEGMENT_SOURCE"));
        if (StringUtil.isEmpty(proj)) {
            final IProject project = Core.getProject();
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<SourceTextEntry> entries = Core.getProject().getAllEntries();
                    for (int i = 0; i < entries.size(); ++i) {
                        TMXEntry trans;
                        SourceTextEntry ste = entries.get(i);
                        if (!ste.getSrcText().equals(ns.source) || (ns.key != null ? !ste.getKey().equals(ns.key) : !(trans = project.getTranslationInfo(entries.get(i))).isTranslated() || !trans.defaultTranslation)) continue;
                        Core.getEditor().gotoEntry(i + 1);
                        break;
                    }
                }
            });
        } else {
            item.setEnabled(false);
        }
        popup.show(this, clickedPoint.x, clickedPoint.y);
    }
}

