/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.matches.MatchesTextArea;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindMatchesThread
extends EntryInfoSearchThread<List<NearString>> {
    private static final Logger LOGGER = Logger.getLogger(FindMatchesThread.class.getName());
    private static final int PENALTY_FOR_FUZZY = 20;
    private static final int PENALTY_FOR_REMOVED = 5;
    private final IProject project;
    private final SourceTextEntry processedEntry;
    private List<NearString> result = new ArrayList<NearString>(6);
    private ISimilarityCalculator distance = new LevenshteinDistance();
    private Token[] strTokensStem;
    private Token[] strTokensNoStem;
    private Token[] strTokensAll;
    private final ITokenizer tok;
    private Pattern removePattern;
    private String removedText;

    public FindMatchesThread(MatchesTextArea matcherPane, IProject project, SourceTextEntry entry) {
        super(matcherPane, entry);
        this.project = project;
        this.processedEntry = entry;
        this.tok = project.getSourceTokenizer();
    }

    @Override
    protected List<NearString> search() throws Exception {
        if (!this.project.isProjectLoaded()) {
            return this.result;
        }
        if (this.tok == null) {
            return null;
        }
        Map<String, ExternalTMX> memories = this.project.getTransMemories();
        long before = 0L;
        if (LOGGER.isLoggable(Level.FINER)) {
            before = System.currentTimeMillis();
        }
        String srcText = this.processedEntry.getSrcText();
        this.removedText = "";
        this.removePattern = PatternConsts.getRemovePattern();
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(srcText);
            while (removeMatcher.find()) {
                this.removedText = this.removedText + srcText.substring(removeMatcher.start(), removeMatcher.end());
            }
            srcText = removeMatcher.replaceAll("");
        }
        this.strTokensStem = this.tok.tokenizeWords(srcText, ITokenizer.StemmingMode.MATCHING);
        this.strTokensNoStem = this.tok.tokenizeWords(srcText, ITokenizer.StemmingMode.NONE);
        this.strTokensAll = this.tok.tokenizeAllExactly(srcText);
        final String orphanedFileName = OStrings.getString("CT_ORPHAN_STRINGS");
        if (this.project.getProjectProperties().isSupportDefaultTranslations()) {
            this.project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){

                public void iterate(String source, TMXEntry trans) {
                    FindMatchesThread.this.checkEntryChanged();
                    if (source.equals(FindMatchesThread.this.processedEntry.getSrcText())) {
                        return;
                    }
                    if (trans.translation == null) {
                        return;
                    }
                    String fileName = FindMatchesThread.this.project.isOrphaned(source) ? orphanedFileName : null;
                    FindMatchesThread.this.processEntry(null, source, trans.translation, false, 0, fileName, trans.changer, trans.changeDate, trans.properties);
                }
            });
        }
        this.project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){

            public void iterate(EntryKey source, TMXEntry trans) {
                FindMatchesThread.this.checkEntryChanged();
                if (source.sourceText.equals(FindMatchesThread.this.processedEntry.getSrcText())) {
                    return;
                }
                if (trans.translation == null) {
                    return;
                }
                String fileName = FindMatchesThread.this.project.isOrphaned(source) ? orphanedFileName : null;
                FindMatchesThread.this.processEntry(source, source.sourceText, trans.translation, false, 0, fileName, trans.changer, trans.changeDate, trans.properties);
            }
        });
        Pattern SEARCH_FOR_PENALTY = Pattern.compile("penalty-(\\d+)");
        for (Map.Entry<String, ExternalTMX> en : memories.entrySet()) {
            int penalty = 0;
            Matcher matcher = SEARCH_FOR_PENALTY.matcher(en.getKey());
            if (matcher.find()) {
                penalty = Integer.parseInt(matcher.group(1));
            }
            for (TMXEntry tmen : en.getValue().getEntries()) {
                this.checkEntryChanged();
                if (tmen.translation == null) continue;
                this.processEntry(null, tmen.source, tmen.translation, false, penalty, en.getKey(), tmen.changer, tmen.changeDate, tmen.properties);
            }
        }
        for (SourceTextEntry ste : this.project.getAllEntries()) {
            this.checkEntryChanged();
            if (ste.getSourceTranslation() == null) continue;
            this.processEntry(ste.getKey(), ste.getSrcText(), ste.getSourceTranslation(), ste.isSourceTranslationFuzzy(), 0, ste.getKey().file, "", 0L, null);
        }
        for (NearString near : this.result) {
            byte[] similarityData = FuzzyMatcher.buildSimilarityData(this.strTokensAll, this.tok.tokenizeAllExactly(near.source));
            near.attr = similarityData;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            long after = System.currentTimeMillis();
            LOGGER.finer("Time for find matches: " + (after - before));
        }
        return this.result;
    }

    protected void processEntry(EntryKey key, String source, String translation, boolean fuzzy, int penalty, String tmxName, String creator, long creationDate, Map<String, String> props) {
        String realSource = source;
        String entryRemovedText = "";
        int realPenaltyForRemoved = 0;
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(realSource);
            while (removeMatcher.find()) {
                entryRemovedText = entryRemovedText + source.substring(removeMatcher.start(), removeMatcher.end());
            }
            realSource = removeMatcher.replaceAll("");
            if (!entryRemovedText.equals(this.removedText)) {
                realPenaltyForRemoved = 5;
            }
        }
        Token[] candTokens = this.tok.tokenizeWords(realSource, ITokenizer.StemmingMode.MATCHING);
        int similarityStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensStem, candTokens);
        similarityStem -= penalty;
        if (fuzzy) {
            similarityStem -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem -= realPenaltyForRemoved, Integer.MAX_VALUE, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensNoStem = this.tok.tokenizeWords(realSource, ITokenizer.StemmingMode.NONE);
        int similarityNoStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensNoStem, candTokensNoStem);
        similarityNoStem -= penalty;
        if (fuzzy) {
            similarityNoStem -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem -= realPenaltyForRemoved, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensAll = this.tok.tokenizeAllExactly(realSource);
        int simAdjusted = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensAll, candTokensAll);
        simAdjusted -= penalty;
        if (fuzzy) {
            simAdjusted -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem, simAdjusted -= realPenaltyForRemoved)) {
            return;
        }
        this.addNearString(key, source, translation, fuzzy, similarityStem, similarityNoStem, simAdjusted, null, tmxName, creator, creationDate, props);
    }

    protected boolean haveChanceToAdd(int simStem, int simNoStem, int simExactly) {
        if (simStem < 30 && simNoStem < 30) {
            return false;
        }
        if (this.result.size() < 5) {
            return true;
        }
        NearString st = this.result.get(this.result.size() - 1);
        Boolean chanse = this.checkScore(st.score, simStem);
        if (chanse == null) {
            chanse = this.checkScore(st.scoreNoStem, simNoStem);
        }
        if (chanse == null) {
            chanse = this.checkScore(st.adjustedScore, simExactly);
        }
        if (chanse == null) {
            chanse = true;
        }
        return chanse;
    }

    private Boolean checkScore(int storedScore, int checkedStore) {
        if (storedScore < checkedStore) {
            return true;
        }
        if (storedScore > checkedStore) {
            return false;
        }
        return null;
    }

    protected void addNearString(EntryKey key, String source, String translation, boolean fuzzy, int similarity, int similarityNoStem, int simAdjusted, byte[] similarityData, String tmxName, String creator, long creationDate, Map<String, String> tuProperties) {
        int pos = 0;
        for (int i = 0; i < this.result.size(); ++i) {
            NearString st = this.result.get(i);
            if (tmxName == null && st.proj.length() == 0 && source.equals(st.source) && (translation == null && st.translation == null || translation != null && translation.equals(st.translation))) {
                return;
            }
            if (st.score < similarity) break;
            if (st.score == similarity) {
                if (st.scoreNoStem < similarityNoStem) break;
                if (st.scoreNoStem == similarityNoStem) {
                    if (st.adjustedScore < simAdjusted) break;
                    String entrySource = this.processedEntry.getSrcText();
                    if (similarity == 100 && !st.source.equals(entrySource) && source.equals(entrySource)) break;
                }
            }
            pos = i + 1;
        }
        this.result.add(pos, new NearString(key, source, translation, fuzzy, similarity, similarityNoStem, simAdjusted, similarityData, tmxName, creator, creationDate, tuProperties));
        if (this.result.size() > 5) {
            this.result.remove(this.result.size() - 1);
        }
    }
}

