/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingworker.SwingWorker;
import org.omegat.core.Core;
import org.omegat.core.KnownException;
import org.omegat.core.data.ProjectFactory;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.team.GITRemoteRepository;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.core.team.RepositoryUtils;
import org.omegat.core.team.SVNRemoteRepository;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.dialogs.NewProjectFileChooser;
import org.omegat.gui.dialogs.NewTeamProject;
import org.omegat.gui.dialogs.ProjectPropertiesDialog;
import org.omegat.gui.main.IMainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.OpenProjectFileChooser;
import org.omegat.util.gui.UIThreadsUtil;

public class ProjectUICommands {
    public static void projectCreate() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        new SwingWorker<Object, Void>(){

            protected Object doInBackground() throws Exception {
                NewProjectFileChooser ndc = new NewProjectFileChooser();
                int ndcResult = ndc.showSaveDialog(Core.getMainWindow().getApplicationFrame());
                if (ndcResult != 0) {
                    return null;
                }
                File dir = ndc.getSelectedFile();
                dir.mkdirs();
                ProjectPropertiesDialog newProjDialog = new ProjectPropertiesDialog(new ProjectProperties(dir), dir.getAbsolutePath(), 1);
                newProjDialog.setVisible(true);
                newProjDialog.dispose();
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                ProjectProperties newProps = newProjDialog.getResult();
                if (newProps == null) {
                    dir.delete();
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                String projectRoot = newProps.getProjectRoot();
                if (projectRoot != null && projectRoot.length() > 0) {
                    try {
                        ProjectFactory.createProject(newProps);
                        Core.getProject().saveProjectProperties();
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    }
                }
                mainWindow.setCursor(oldCursor);
                return null;
            }
        }.execute();
    }

    public static void projectTeamCreate() {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        new SwingWorker<Object, Void>(){

            protected Object doInBackground() throws Exception {
                IRemoteRepository repository;
                Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                final NewTeamProject dialog = ProjectUICommands.displayTeamDialog();
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                File localDirectory = new File(dialog.txtDirectory.getText());
                try {
                    if (!dialog.ok) {
                        Core.getMainWindow().showStatusMessageRB("TEAM_CANCELLED", new Object[0]);
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                    if (dialog.rbSVN.isSelected()) {
                        repository = new SVNRemoteRepository(localDirectory);
                    } else if (dialog.rbGIT.isSelected()) {
                        repository = new GITRemoteRepository(localDirectory);
                    } else {
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                    new RepositoryUtils.AskCredentials(){

                        public void callRepository() throws Exception {
                            Core.getMainWindow().showStatusMessageRB("TEAM_CHECKOUT", new Object[0]);
                            repository.checkoutFullProject(dialog.txtRepositoryURL.getText());
                            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                        }
                    }.execute(repository);
                }
                catch (IRemoteRepository.BadRepositoryException bre) {
                    Object[] args = new Object[]{bre.getMessage()};
                    Core.getMainWindow().showErrorDialogRB("TEAM_BADREPOSITORY_ERROR", args, "TF_ERROR");
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Core.getMainWindow().displayErrorRB(ex, "TEAM_CHECKOUT_ERROR", new Object[0]);
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                try {
                    File[] projectFolders;
                    ProjectProperties props = ProjectFileStorage.loadProjectProperties(localDirectory);
                    for (File f : projectFolders = new File[]{new File(props.getGlossaryRoot()), new File(props.getTMRoot()), new File(props.getTMAutoRoot()), new File(props.getDictRoot()), new File(props.getTargetRoot())}) {
                        try {
                            if (f.exists()) continue;
                            f.mkdir();
                        }
                        catch (Exception e) {
                            Log.logErrorRB(e, "TEAM_MISSING_FOLDER", f.getName());
                        }
                    }
                    ProjectFactory.loadProject(props, repository, true);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
                mainWindow.setCursor(oldCursor);
                return null;
            }
        }.execute();
    }

    public static NewTeamProject displayTeamDialog() {
        final NewTeamProject dialog = new NewTeamProject((Frame)Core.getMainWindow().getApplicationFrame(), true);
        DockingUI.displayCentered(dialog);
        dialog.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.rbGIT.setSelected(false);
                dialog.rbSVN.setSelected(false);
                dialog.dispose();
            }
        });
        dialog.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                dialog.ok = true;
            }
        });
        dialog.btnDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewProjectFileChooser ndc = new NewProjectFileChooser();
                int ndcResult = ndc.showSaveDialog(Core.getMainWindow().getApplicationFrame());
                if (ndcResult == 0) {
                    dialog.txtDirectory.setText(ndc.getSelectedFile().getPath());
                }
            }
        });
        DocumentListener newTeamProjectOkHider = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ProjectUICommands.checkNewTeamProjectDialog(dialog);
            }

            public void removeUpdate(DocumentEvent e) {
                ProjectUICommands.checkNewTeamProjectDialog(dialog);
            }

            public void insertUpdate(DocumentEvent e) {
                ProjectUICommands.checkNewTeamProjectDialog(dialog);
            }
        };
        dialog.txtDirectory.getDocument().addDocumentListener(newTeamProjectOkHider);
        dialog.txtRepositoryURL.getDocument().addDocumentListener(newTeamProjectOkHider);
        dialog.rbGIT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectUICommands.checkNewTeamProjectDialog(dialog);
            }
        });
        dialog.rbSVN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectUICommands.checkNewTeamProjectDialog(dialog);
            }
        });
        dialog.setVisible(true);
        return dialog;
    }

    public static void checkNewTeamProjectDialog(NewTeamProject dialog) {
        boolean enabled = dialog.rbGIT.isSelected() || dialog.rbSVN.isSelected();
        enabled &= !StringUtil.isEmpty(dialog.txtRepositoryURL.getText());
        dialog.btnOk.setEnabled(enabled &= !StringUtil.isEmpty(dialog.txtDirectory.getText()));
    }

    public static void projectOpen(final File projectDirectory) {
        UIThreadsUtil.mustBeSwingThread();
        if (Core.getProject().isProjectLoaded()) {
            return;
        }
        new SwingWorker<Object, Void>(){

            protected Object doInBackground() throws Exception {
                ProjectProperties props;
                File projectRootFolder;
                if (projectDirectory == null) {
                    OpenProjectFileChooser pfc = new OpenProjectFileChooser();
                    if (0 != pfc.showOpenDialog(Core.getMainWindow().getApplicationFrame())) {
                        return null;
                    }
                    projectRootFolder = pfc.getSelectedFile();
                } else {
                    projectRootFolder = projectDirectory;
                }
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                try {
                    props = ProjectFileStorage.loadProjectProperties(projectRootFolder);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                final IRemoteRepository repository = Core.getParams().containsKey("no-team") ? null : (SVNRemoteRepository.isSVNDirectory(projectRootFolder) ? new SVNRemoteRepository(projectRootFolder) : (GITRemoteRepository.isGITDirectory(projectRootFolder) ? new GITRemoteRepository(projectRootFolder) : null));
                if (repository != null) {
                    boolean onlineMode = true;
                    try {
                        File tmxFile = new File(props.getProjectInternal() + "project_save.tmx");
                        File GlossaryFile = new File(props.getWriteableGlossary());
                        if (repository.isChanged(tmxFile) || repository.isChanged(GlossaryFile)) {
                            Log.logWarningRB("TEAM_NOCHECKOUT", new Object[0]);
                            Core.getMainWindow().showErrorDialogRB("TEAM_NOCHECKOUT", null, "TEAM_NOCHECKOUT_TITLE");
                        } else {
                            new RepositoryUtils.AskCredentials(){

                                public void callRepository() throws Exception {
                                    Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE", new Object[0]);
                                    repository.updateFullProject();
                                    Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
                                }
                            }.execute(repository);
                        }
                    }
                    catch (IRemoteRepository.NetworkException ex) {
                        onlineMode = false;
                        Log.logInfoRB("VCS_OFFLINE", new Object[0]);
                        Core.getMainWindow().displayWarningRB("VCS_OFFLINE", new Object[0]);
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "TEAM_CHECKOUT_ERROR", ex.getMessage());
                        Core.getMainWindow().displayErrorRB(ex, "TEAM_CHECKOUT_ERROR", ex.getMessage());
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                    try {
                        ProjectFactory.loadProject(props, repository, onlineMode);
                    }
                    catch (Exception ex) {
                        Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                }
                try {
                    boolean needToSaveProperties = false;
                    while (!props.isProjectValid()) {
                        needToSaveProperties = true;
                        ProjectPropertiesDialog prj = new ProjectPropertiesDialog(props, new File(projectRootFolder, "omegat.project").getAbsolutePath(), 2);
                        prj.setVisible(true);
                        props = prj.getResult();
                        prj.dispose();
                        if (props != null) continue;
                        mainWindow.setCursor(oldCursor);
                        return null;
                    }
                    ProjectFactory.loadProject(props, repository, true);
                    if (needToSaveProperties) {
                        Core.getProject().saveProjectProperties();
                    }
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    mainWindow.setCursor(oldCursor);
                    return null;
                }
                mainWindow.setCursor(oldCursor);
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Core.getEditor().requestFocus();
                        }
                    });
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public static void projectReload() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        final ProjectProperties props = Core.getProject().getProjectProperties();
        new SwingWorker<Object, Void>(){
            int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber();

            protected Object doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                IRemoteRepository repository = Core.getProject().getRepository();
                Core.getProject().saveProject();
                ProjectFactory.closeProject();
                ProjectFactory.loadProject(props, repository, true);
                mainWindow.setCursor(oldCursor);
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Core.getEditor().gotoEntry(previousCurEntryNum);
                            Core.getEditor().requestFocus();
                        }
                    });
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectSave() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        new SwingWorker<Object, Void>(){

            protected Object doInBackground() throws Exception {
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                mainWindow.showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                Core.getProject().saveProject();
                mainWindow.showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                mainWindow.setCursor(oldCursor);
                return null;
            }

            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectClose() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        new SwingWorker<Object, Void>(){

            protected Object doInBackground() throws Exception {
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVING", new Object[0]);
                IMainWindow mainWindow = Core.getMainWindow();
                Cursor hourglassCursor = new Cursor(3);
                Cursor oldCursor = mainWindow.getCursor();
                mainWindow.setCursor(hourglassCursor);
                Preferences.save();
                Core.getProject().saveProject();
                Core.getMainWindow().showStatusMessageRB("MW_STATUS_SAVED", new Object[0]);
                mainWindow.setCursor(oldCursor);
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    ProjectFactory.closeProject();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectEditProperties() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        ProjectPropertiesDialog prj = new ProjectPropertiesDialog(Core.getProject().getProjectProperties(), Core.getProject().getProjectProperties().getProjectName(), 3);
        prj.setVisible(true);
        final ProjectProperties newProps = prj.getResult();
        prj.dispose();
        if (newProps == null) {
            return;
        }
        FilterMaster.saveConfig(newProps.getProjectFilters(), newProps.getProjectInternal());
        int res = JOptionPane.showConfirmDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
        if (res != 0) {
            return;
        }
        new SwingWorker<Object, Void>(){
            int previousCurEntryNum = Core.getEditor().getCurrentEntryNumber();

            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject();
                ProjectFactory.closeProject();
                ProjectFactory.loadProject(newProps, null, true);
                Core.getProject().saveProjectProperties();
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    Core.getEditor().gotoEntry(this.previousCurEntryNum);
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE");
                }
            }
        }.execute();
    }

    public static void projectCompile() {
        ProjectUICommands.performProjectMenuItemPreConditions();
        new SwingWorker<Object, Void>(){

            protected Object doInBackground() throws Exception {
                Core.getProject().saveProject();
                Core.getProject().compileProject(".*");
                return null;
            }

            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    ProjectUICommands.processSwingWorkerException(ex, "TF_COMPILE_ERROR");
                }
            }
        }.execute();
    }

    private static void performProjectMenuItemPreConditions() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().commitAndLeave();
    }

    private static void processSwingWorkerException(Exception ex, String errorCode) {
        if (ex instanceof ExecutionException) {
            Log.logErrorRB(ex.getCause(), errorCode, new Object[0]);
            if (ex.getCause() instanceof KnownException) {
                KnownException e = (KnownException)ex.getCause();
                Core.getMainWindow().displayErrorRB(e.getCause(), e.getMessage(), e.getParams());
            } else {
                Core.getMainWindow().displayErrorRB(ex.getCause(), errorCode, new Object[0]);
            }
        } else {
            Log.logErrorRB(ex, errorCode, new Object[0]);
            Core.getMainWindow().displayErrorRB(ex, errorCode, new Object[0]);
        }
    }
}

