/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jdesktop.swingworker.SwingWorker;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.spellchecker.ISpellChecker;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.dialogs.AboutDialog;
import org.omegat.gui.dialogs.ExternalTMXMatchesDialog;
import org.omegat.gui.dialogs.FontSelectionDialog;
import org.omegat.gui.dialogs.SaveOptionsDialog;
import org.omegat.gui.dialogs.SpellcheckerConfigurationDialog;
import org.omegat.gui.dialogs.TagValidationOptionsDialog;
import org.omegat.gui.dialogs.TeamOptionsDialog;
import org.omegat.gui.dialogs.UserPassDialog;
import org.omegat.gui.dialogs.ViewOptionsDialog;
import org.omegat.gui.dialogs.WorkflowOptionsDialog;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.help.HelpFrame;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.search.SearchWindow;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.Base64;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class MainWindowMenuHandler {
    private final MainWindow mainWindow;

    public MainWindowMenuHandler(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void projectNewMenuItemActionPerformed() {
        ProjectUICommands.projectCreate();
    }

    public void projectTeamNewMenuItemActionPerformed() {
        ProjectUICommands.projectTeamCreate();
    }

    public void projectOpenMenuItemActionPerformed() {
        ProjectUICommands.projectOpen(null);
    }

    public void projectImportMenuItemActionPerformed() {
        this.mainWindow.doImportSourceFiles();
    }

    public void projectWikiImportMenuItemActionPerformed() {
        this.mainWindow.doWikiImport();
    }

    public void projectReloadMenuItemActionPerformed() {
        ProjectUICommands.projectReload();
    }

    public void projectCloseMenuItemActionPerformed() {
        ProjectUICommands.projectClose();
    }

    public void projectSaveMenuItemActionPerformed() {
        ProjectUICommands.projectSave();
    }

    public void projectCompileMenuItemActionPerformed() {
        ProjectUICommands.projectCompile();
    }

    public void projectEditMenuItemActionPerformed() {
        ProjectUICommands.projectEditProperties();
    }

    public void viewFileListMenuItemActionPerformed() {
        if (this.mainWindow.m_projWin == null) {
            this.mainWindow.menu.viewFileListMenuItem.setSelected(false);
            return;
        }
        if (!this.mainWindow.m_projWin.isActive()) {
            this.mainWindow.m_projWin.buildDisplay();
            this.mainWindow.m_projWin.setVisible(true);
            this.mainWindow.m_projWin.toFront();
        } else {
            this.mainWindow.m_projWin.setVisible(false);
        }
    }

    private void flushExportedSegments() {
        FileUtil.writeScriptFile("", "source.txt");
        FileUtil.writeScriptFile("", "target.txt");
    }

    public void projectExitMenuItemActionPerformed() {
        boolean projectModified = false;
        if (Core.getProject().isProjectLoaded()) {
            projectModified = Core.getProject().isProjectModified();
        }
        if ((projectModified || Preferences.isPreference("always_confirm_quit")) && 0 != JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_QUIT_CONFIRM"), OStrings.getString("CONFIRM_DIALOG_TITLE"), 0)) {
            return;
        }
        this.flushExportedSegments();
        new SwingWorker<Object, Void>(){

            protected Object doInBackground() throws Exception {
                if (Core.getProject().isProjectLoaded()) {
                    ISpellChecker sc = Core.getSpellChecker();
                    sc.saveWordLists();
                    try {
                        Core.getProject().saveProject();
                    }
                    catch (KnownException knownException) {
                        // empty catch block
                    }
                }
                CoreEvents.fireApplicationShutdown();
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    MainWindowUI.saveScreenLayout(MainWindowMenuHandler.this.mainWindow);
                    Preferences.save();
                    System.exit(0);
                }
                catch (Exception ex) {
                    Log.logErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                    Core.getMainWindow().displayErrorRB(ex, "PP_ERROR_UNABLE_TO_READ_PROJECT_FILE", new Object[0]);
                }
            }
        }.execute();
    }

    public void editUndoMenuItemActionPerformed() {
        Core.getEditor().undo();
    }

    public void editRedoMenuItemActionPerformed() {
        Core.getEditor().redo();
    }

    public void editOverwriteTranslationMenuItemActionPerformed() {
        this.mainWindow.doRecycleTrans();
    }

    public void editInsertTranslationMenuItemActionPerformed() {
        this.mainWindow.doInsertTrans();
    }

    public void editOverwriteMachineTranslationMenuItemActionPerformed() {
        String tr = Core.getMachineTranslatePane().getDisplayedTranslation();
        if (!StringUtil.isEmpty(tr)) {
            Core.getEditor().replaceEditText(tr);
        }
    }

    public void editOverwriteSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().replaceEditText(Core.getEditor().getCurrentEntry().getSrcText());
    }

    public void editInsertSourceMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getEditor().insertText(Core.getEditor().getCurrentEntry().getSrcText());
    }

    public void editExportSelectionMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = Core.getEditor().getSelectedText();
        if (selection == null) {
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            TMXEntry te = Core.getProject().getTranslationInfo(ste);
            selection = te.isTranslated() ? te.translation : ste.getSrcText();
        }
        FileUtil.writeScriptFile(selection, "selection.txt");
    }

    public void editCreateGlossaryEntryMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Core.getGlossary().showCreateGlossaryEntryDialog();
    }

    public void editFindInProjectMenuItemActionPerformed() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        String selection = Core.getEditor().getSelectedText();
        if (selection != null) {
            selection.trim();
        }
        SearchWindow search = new SearchWindow(this.mainWindow, selection);
        search.setVisible(true);
        this.mainWindow.addSearchWindow(search);
    }

    public void editSelectFuzzy1MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(0);
    }

    public void editSelectFuzzy2MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(1);
    }

    public void editSelectFuzzy3MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(2);
    }

    public void editSelectFuzzy4MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(3);
    }

    public void editSelectFuzzy5MenuItemActionPerformed() {
        Core.getMatcher().setActiveMatch(4);
    }

    public void editMultipleDefaultActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(false);
    }

    public void editMultipleAlternateActionPerformed() {
        Core.getEditor().setAlternateTranslationForCurrentEntry(true);
    }

    public void cycleSwitchCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.CYCLE);
    }

    public void titleCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.TITLE);
    }

    public void upperCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.UPPER);
    }

    public void lowerCaseMenuItemActionPerformed() {
        Core.getEditor().changeCase(IEditor.CHANGE_CASE_TO.LOWER);
    }

    public void gotoNextUntranslatedMenuItemActionPerformed() {
        Core.getEditor().nextUntranslatedEntry();
    }

    public void gotoNextSegmentMenuItemActionPerformed() {
        Core.getEditor().nextEntry();
    }

    public void gotoPreviousSegmentMenuItemActionPerformed() {
        Core.getEditor().prevEntry();
    }

    public void gotoNextNoteMenuItemActionPerformed() {
        Core.getEditor().nextEntryWithNote();
    }

    public void gotoPreviousNoteMenuItemActionPerformed() {
        Core.getEditor().prevEntryWithNote();
    }

    public void gotoSegmentMenuItemActionPerformed() {
        final JOptionPane input = new JOptionPane(OStrings.getString("MW_PROMPT_SEG_NR_MSG"), -1, 2);
        input.setWantsInput(true);
        final JDialog dialog = new JDialog(this.mainWindow, OStrings.getString("MW_PROMPT_SEG_NR_TITLE"), true);
        dialog.setContentPane(input);
        input.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == input) {
                    String property = event.getPropertyName();
                    Object value = input.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if (property.equals("inputValue") || property.equals("value") && (Integer)value == 0) {
                        input.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        String inputValue = (String)input.getInputValue();
                        int maxNr = Core.getProject().getAllEntries().size();
                        if (inputValue == null || inputValue.trim().length() == 0) {
                            this.displayErrorMessage(maxNr);
                            return;
                        }
                        int segmentNr = -1;
                        try {
                            segmentNr = Integer.parseInt(inputValue);
                        }
                        catch (NumberFormatException e) {
                            this.displayErrorMessage(maxNr);
                            return;
                        }
                        if (segmentNr < 1 || segmentNr > maxNr) {
                            this.displayErrorMessage(maxNr);
                            return;
                        }
                    }
                    dialog.setVisible(false);
                }
            }

            private void displayErrorMessage(int maxNr) {
                JOptionPane.showMessageDialog(dialog, StaticUtils.format(OStrings.getString("MW_SEGMENT_NUMBER_ERROR"), maxNr), OStrings.getString("TF_ERROR"), 0);
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(Core.getMainWindow().getApplicationFrame());
        dialog.setVisible(true);
        Object inputValue = input.getInputValue();
        if (inputValue != null && !inputValue.equals(JOptionPane.UNINITIALIZED_VALUE)) {
            try {
                Core.getEditor().gotoEntry(Integer.parseInt((String)inputValue));
            }
            catch (ClassCastException e) {
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public void gotoHistoryBackMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryBack();
    }

    public void gotoHistoryForwardMenuItemActionPerformed() {
        Core.getEditor().gotoHistoryForward();
    }

    public void viewMarkTranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkTranslated(this.mainWindow.menu.viewMarkTranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkUntranslatedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkUntranslated(this.mainWindow.menu.viewMarkUntranslatedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewDisplaySegmentSourceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplaySegmentSources(this.mainWindow.menu.viewDisplaySegmentSourceCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNonUniqueSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNonUniqueSegments(this.mainWindow.menu.viewMarkNonUniqueSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNotedSegmentsCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNotedSegments(this.mainWindow.menu.viewMarkNotedSegmentsCheckBoxMenuItem.isSelected());
    }

    public void viewMarkNBSPCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkNBSP(this.mainWindow.menu.viewMarkNBSPCheckBoxMenuItem.isSelected());
    }

    public void viewMarkWhitespaceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkWhitespace(this.mainWindow.menu.viewMarkWhitespaceCheckBoxMenuItem.isSelected());
    }

    public void viewMarkBidiCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setMarkBidi(this.mainWindow.menu.viewMarkBidiCheckBoxMenuItem.isSelected());
    }

    public void viewDisplayModificationInfoNoneRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_NONE);
    }

    public void viewDisplayModificationInfoSelectedRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_SELECTED);
    }

    public void viewDisplayModificationInfoAllRadioButtonMenuItemActionPerformed() {
        Core.getEditor().getSettings().setDisplayModificationInfo(EditorSettings.DISPLAY_MODIFICATION_INFO_ALL);
    }

    public void toolsValidateTagsMenuItemActionPerformed() {
        Core.getTagValidation().validateTags();
    }

    public void editTagPainterMenuItemActionPerformed() {
        String sourceText = Core.getEditor().getCurrentEntry().getSrcText();
        String placeholderString = StaticUtils.buildPaintPlaceholderList(sourceText);
        if (!placeholderString.equals("")) {
            Core.getEditor().insertText(placeholderString);
        }
    }

    public void toolsShowStatisticsStandardMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.STANDARD).setVisible(true);
    }

    public void toolsShowStatisticsMatchesMenuItemActionPerformed() {
        new StatisticsWindow(StatisticsWindow.STAT_TYPE.MATCHES).setVisible(true);
    }

    public void optionsTabAdvanceCheckBoxMenuItemActionPerformed() {
        Core.getEditor().getSettings().setUseTabForAdvance(this.mainWindow.menu.optionsTabAdvanceCheckBoxMenuItem.isSelected());
    }

    public void optionsAlwaysConfirmQuitCheckBoxMenuItemActionPerformed() {
        Preferences.setPreference("always_confirm_quit", this.mainWindow.menu.optionsAlwaysConfirmQuitCheckBoxMenuItem.isSelected());
    }

    public void optionsTransTipsEnableMenuItemActionPerformed() {
        Preferences.setPreference("transtips", this.mainWindow.menu.optionsTransTipsEnableMenuItem.isSelected());
    }

    public void optionsTransTipsExactMatchMenuItemActionPerformed() {
        Preferences.setPreference("transtips_exact_search", this.mainWindow.menu.optionsTransTipsExactMatchMenuItem.isSelected());
    }

    public void optionsFontSelectionMenuItemActionPerformed() {
        FontSelectionDialog dlg = new FontSelectionDialog((Frame)Core.getMainWindow().getApplicationFrame(), Core.getMainWindow().getApplicationFont());
        dlg.setVisible(true);
        if (dlg.getReturnStatus() == 1) {
            this.mainWindow.setApplicationFont(dlg.getSelectedFont());
        }
    }

    public void optionsSetupFileFiltersMenuItemActionPerformed() {
        FiltersCustomizer dlg = new FiltersCustomizer(this.mainWindow, false, FilterMaster.createDefaultFiltersConfig(), FilterMaster.loadConfig(StaticUtils.getConfigDir()), null);
        dlg.setVisible(true);
        if (dlg.getReturnStatus() == 1) {
            FilterMaster.saveConfig(dlg.result, StaticUtils.getConfigDir());
            if (Core.getProject().isProjectLoaded()) {
                if (FilterMaster.loadConfig(Core.getProject().getProjectProperties().getProjectInternal()) != null) {
                    return;
                }
                int res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0);
                if (res == 0) {
                    ProjectUICommands.projectReload();
                }
            }
        }
    }

    public void optionsSentsegMenuItemActionPerformed() {
        SegmentationCustomizer segment_window = new SegmentationCustomizer(this.mainWindow, false, SRX.getDefault(), Preferences.getSRX(), null);
        segment_window.setVisible(true);
        if (segment_window.getReturnStatus() == 1) {
            int res;
            Preferences.setSRX(segment_window.getSRX());
            if (Core.getProject().isProjectLoaded() && Core.getProject().getProjectProperties().getProjectSRX() == null && (res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
                ProjectUICommands.projectReload();
            }
        }
    }

    public void optionsSpellCheckMenuItemActionPerformed() {
        Language currentLanguage = null;
        currentLanguage = Core.getProject().isProjectLoaded() ? Core.getProject().getProjectProperties().getTargetLanguage() : new Language(Preferences.getPreference("target_lang"));
        SpellcheckerConfigurationDialog sd = new SpellcheckerConfigurationDialog((Frame)this.mainWindow, currentLanguage);
        sd.setVisible(true);
        if (sd.getReturnStatus() == 1) {
            boolean isNeedToSpell = Preferences.isPreference("allow_auto_spellchecking");
            if (isNeedToSpell && Core.getProject().isProjectLoaded()) {
                ISpellChecker sc = Core.getSpellChecker();
                sc.destroy();
                sc.initialize();
            }
            Core.getEditor().getSettings().setAutoSpellChecking(isNeedToSpell);
        }
    }

    public void optionsWorkflowMenuItemActionPerformed() {
        new WorkflowOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsTagValidationMenuItemActionPerformed() {
        TagValidationOptionsDialog tagValidationOptionsDialog = new TagValidationOptionsDialog(this.mainWindow);
        tagValidationOptionsDialog.setVisible(true);
        if (tagValidationOptionsDialog.getReturnStatus() == 1 && Core.getProject().isProjectLoaded()) {
            Core.getEditor().getSettings().updateTagValidationPreferences();
        }
    }

    public void optionsTeamMenuItemActionPerformed() {
        new TeamOptionsDialog(this.mainWindow).setVisible(true);
    }

    public void optionsExtTMXMenuItemActionPerformed() {
        int res;
        ExternalTMXMatchesDialog externalTMXOptions = new ExternalTMXMatchesDialog(this.mainWindow);
        externalTMXOptions.setVisible(true);
        if (externalTMXOptions.getReturnStatus() == 1 && Core.getProject().isProjectLoaded() && (res = JOptionPane.showConfirmDialog(this.mainWindow, OStrings.getString("MW_REOPEN_QUESTION"), OStrings.getString("MW_REOPEN_TITLE"), 0)) == 0) {
            ProjectUICommands.projectReload();
        }
    }

    public void optionsViewOptionsMenuItemActionPerformed() {
        ViewOptionsDialog viewOptions = new ViewOptionsDialog(this.mainWindow);
        viewOptions.setVisible(true);
        if (viewOptions.getReturnStatus() == 1 && Core.getProject().isProjectLoaded()) {
            Core.getEditor().getSettings().updateViewPreferences();
        }
    }

    public void optionsSaveOptionsMenuItemActionPerformed() {
        SaveOptionsDialog saveOptions = new SaveOptionsDialog(this.mainWindow);
        saveOptions.setVisible(true);
    }

    public void optionsRestoreGUIMenuItemActionPerformed() {
        MainWindowUI.resetDesktopLayout(this.mainWindow);
    }

    public void helpContentsMenuItemActionPerformed() {
        HelpFrame hf = HelpFrame.getInstance();
        hf.setVisible(true);
        hf.toFront();
    }

    public void helpAboutMenuItemActionPerformed() {
        new AboutDialog(this.mainWindow).setVisible(true);
    }

    public void optionsViewOptionsMenuLoginItemActionPerformed() {
        UserPassDialog proxyOptions = new UserPassDialog(this.mainWindow);
        String encodedUser = Preferences.getPreference("proxy_user_name");
        String encodedPassword = Preferences.getPreference("proxy_password");
        try {
            proxyOptions.userText.setText(new String(Base64.decode(encodedUser)));
            proxyOptions.passwordField.setText(new String(Base64.decode(encodedPassword)));
        }
        catch (IOException ex) {
            Log.logErrorRB("LOG_DECODING_ERROR", new Object[0]);
            Log.log(ex);
        }
        proxyOptions.setVisible(true);
        if (proxyOptions.getReturnStatus() == 1) {
            encodedUser = Base64.encodeBytes(proxyOptions.userText.getText().getBytes());
            encodedPassword = Base64.encodeBytes(new String(proxyOptions.passwordField.getPassword()).getBytes());
            Preferences.setPreference("proxy_user_name", encodedUser);
            Preferences.setPreference("proxy_password", encodedPassword);
        }
    }
}

