/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import net.roydesign.mac.MRJAdapter;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.main.IMainMenu;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.gui.main.MainWindowMenuShortcuts;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.Styles;
import org.openide.awt.Mnemonics;

public class MainWindowMenu
implements ActionListener,
IMainMenu {
    private static final Logger LOGGER = Logger.getLogger(MainWindowMenu.class.getName());
    protected final MainWindow mainWindow;
    protected final MainWindowMenuHandler mainWindowMenuHandler;
    private static final int ICON_SIZE = 12;
    JMenuItem cycleSwitchCaseMenuItem;
    JMenuItem editFindInProjectMenuItem;
    JMenuItem editInsertSourceMenuItem;
    JMenuItem editInsertTranslationMenuItem;
    JMenu editMenu;
    JMenuItem editOverwriteSourceMenuItem;
    JMenuItem editOverwriteTranslationMenuItem;
    JMenuItem editOverwriteMachineTranslationMenuItem;
    JMenuItem editRedoMenuItem;
    JMenuItem editSelectFuzzy1MenuItem;
    JMenuItem editSelectFuzzy2MenuItem;
    JMenuItem editSelectFuzzy3MenuItem;
    JMenuItem editSelectFuzzy4MenuItem;
    JMenuItem editSelectFuzzy5MenuItem;
    public JMenuItem editMultipleDefault;
    public JMenuItem editMultipleAlternate;
    JMenuItem editUndoMenuItem;
    JMenuItem editTagPainterMenuItem;
    JMenuItem editExportSelectionMenuItem;
    JMenuItem editCreateGlossaryEntryMenuItem;
    public JMenuItem gotoHistoryBackMenuItem;
    public JMenuItem gotoHistoryForwardMenuItem;
    JMenu gotoMenu;
    JMenuItem gotoNextSegmentMenuItem;
    JMenuItem gotoNextUntranslatedMenuItem;
    JMenuItem gotoPreviousSegmentMenuItem;
    JMenuItem gotoSegmentMenuItem;
    JMenuItem gotoNextNoteMenuItem;
    JMenuItem gotoPreviousNoteMenuItem;
    JMenuItem helpAboutMenuItem;
    JMenuItem helpContentsMenuItem;
    JMenu helpMenu;
    JMenuItem lowerCaseMenuItem;
    JMenuBar mainMenu;
    JCheckBoxMenuItem optionsAlwaysConfirmQuitCheckBoxMenuItem;
    JMenuItem optionsFontSelectionMenuItem;
    JMenu optionsMenu;
    JMenuItem optionsRestoreGUIMenuItem;
    JMenuItem optionsSentsegMenuItem;
    JMenuItem optionsSetupFileFiltersMenuItem;
    JMenuItem optionsSpellCheckMenuItem;
    JCheckBoxMenuItem optionsTabAdvanceCheckBoxMenuItem;
    JMenu optionsMachineTranslateMenu;
    JMenu optionsGlossaryMenu;
    JMenu optionsTransTipsMenu;
    JCheckBoxMenuItem optionsTransTipsEnableMenuItem;
    JCheckBoxMenuItem optionsTransTipsExactMatchMenuItem;
    JMenuItem optionsWorkflowMenuItem;
    JMenuItem optionsTagValidationMenuItem;
    JMenuItem optionsTeamMenuItem;
    JMenuItem optionsExtTMXMenuItem;
    JMenuItem optionsViewOptionsMenuItem;
    JMenuItem optionsSaveOptionsMenuItem;
    JMenuItem optionsViewOptionsMenuLoginItem;
    JMenuItem projectCloseMenuItem;
    JMenuItem projectCompileMenuItem;
    JMenuItem projectEditMenuItem;
    JMenuItem projectExitMenuItem;
    JMenuItem projectImportMenuItem;
    JMenu projectMenu;
    JMenuItem projectNewMenuItem;
    JMenuItem projectTeamNewMenuItem;
    JMenuItem projectOpenMenuItem;
    JMenuItem projectReloadMenuItem;
    JMenuItem projectSaveMenuItem;
    JMenuItem projectWikiImportMenuItem;
    JMenu switchCaseSubMenu;
    JMenuItem titleCaseMenuItem;
    JMenu toolsMenu;
    JMenuItem toolsValidateTagsMenuItem;
    JMenuItem toolsShowStatisticsStandardMenuItem;
    JMenuItem toolsShowStatisticsMatchesMenuItem;
    JMenuItem upperCaseMenuItem;
    JCheckBoxMenuItem viewDisplaySegmentSourceCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkNonUniqueSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkNotedSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkNBSPCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkWhitespaceCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkBidiCheckBoxMenuItem;
    JMenu viewModificationInfoMenu;
    JRadioButtonMenuItem viewDisplayModificationInfoNoneRadioButtonMenuItem;
    JRadioButtonMenuItem viewDisplayModificationInfoSelectedRadioButtonMenuItem;
    JRadioButtonMenuItem viewDisplayModificationInfoAllRadioButtonMenuItem;
    JMenuItem viewFileListMenuItem;
    JCheckBoxMenuItem viewMarkTranslatedSegmentsCheckBoxMenuItem;
    JCheckBoxMenuItem viewMarkUntranslatedSegmentsCheckBoxMenuItem;
    JMenu viewMenu;

    public MainWindowMenu(MainWindow mainWindow, MainWindowMenuHandler mainWindowMenuHandler) {
        this.mainWindow = mainWindow;
        this.mainWindowMenuHandler = mainWindowMenuHandler;
    }

    private Icon getViewMenuMarkBGIcon(final Color color) {
        Icon i = new Icon(){

            public void paintIcon(Component cmpnt, Graphics grphcs, int x, int y) {
                if (color != null) {
                    grphcs.setColor(color);
                    grphcs.fillRect(x, y, 12, 12);
                }
            }

            public int getIconWidth() {
                return 12;
            }

            public int getIconHeight() {
                return 12;
            }
        };
        return i;
    }

    private Icon getViewMenuMarkTextIcon(final Color color) {
        Icon i = new Icon(){

            public void paintIcon(Component cmpnt, Graphics grphcs, int x, int y) {
                if (color != null && grphcs != null) {
                    grphcs.setColor(color);
                    char[] data = new char[]{'M'};
                    grphcs.drawChars(data, 0, 1, x, y + 12);
                }
            }

            public int getIconWidth() {
                return 12;
            }

            public int getIconHeight() {
                return 12;
            }
        };
        return i;
    }

    public void actionPerformed(ActionEvent evt) {
        JMenuItem menuItem = (JMenuItem)evt.getSource();
        String action = menuItem.getActionCommand();
        Log.logInfoRB("LOG_MENU_CLICK", action);
        String methodName = action + "ActionPerformed";
        Method method = null;
        try {
            method = this.mainWindowMenuHandler.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu: there is no method " + methodName);
        }
        try {
            method.invoke((Object)this.mainWindowMenuHandler, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, "Error execute method", ex);
            throw new IncompatibleClassChangeError("Error invoke method handler for main menu");
        }
    }

    JMenuBar initComponents() {
        this.mainMenu = new JMenuBar();
        this.projectMenu = this.createMenu("TF_MENU_FILE");
        this.mainMenu.add(this.projectMenu);
        this.editMenu = this.createMenu("TF_MENU_EDIT");
        this.mainMenu.add(this.editMenu);
        this.gotoMenu = this.createMenu("MW_GOTOMENU");
        this.mainMenu.add(this.gotoMenu);
        this.viewMenu = this.createMenu("MW_VIEW_MENU");
        this.mainMenu.add(this.viewMenu);
        this.toolsMenu = this.createMenu("TF_MENU_TOOLS");
        this.mainMenu.add(this.toolsMenu);
        this.optionsMenu = this.createMenu("MW_OPTIONSMENU");
        this.mainMenu.add(this.optionsMenu);
        this.helpMenu = this.createMenu("TF_MENU_HELP");
        this.mainMenu.add(this.helpMenu);
        this.projectNewMenuItem = this.createMenuItem("TF_MENU_FILE_CREATE");
        this.projectMenu.add(this.projectNewMenuItem);
        this.projectTeamNewMenuItem = this.createMenuItem("TF_MENU_FILE_TEAM_CREATE");
        this.projectMenu.add(this.projectTeamNewMenuItem);
        this.projectOpenMenuItem = this.createMenuItem("TF_MENU_FILE_OPEN");
        this.projectMenu.add(this.projectOpenMenuItem);
        this.projectImportMenuItem = this.createMenuItem("TF_MENU_FILE_IMPORT");
        this.projectMenu.add(this.projectImportMenuItem);
        this.projectWikiImportMenuItem = this.createMenuItem("TF_MENU_WIKI_IMPORT");
        this.projectMenu.add(this.projectWikiImportMenuItem);
        this.projectReloadMenuItem = this.createMenuItem("TF_MENU_PROJECT_RELOAD");
        this.projectMenu.add(this.projectReloadMenuItem);
        this.projectCloseMenuItem = this.createMenuItem("TF_MENU_FILE_CLOSE");
        this.projectMenu.add(this.projectCloseMenuItem);
        this.projectMenu.add(new JSeparator());
        this.projectSaveMenuItem = this.createMenuItem("TF_MENU_FILE_SAVE");
        this.projectMenu.add(this.projectSaveMenuItem);
        this.projectMenu.add(new JSeparator());
        this.projectCompileMenuItem = this.createMenuItem("TF_MENU_FILE_COMPILE");
        this.projectMenu.add(this.projectCompileMenuItem);
        this.projectMenu.add(new JSeparator());
        this.projectEditMenuItem = this.createMenuItem("MW_PROJECTMENU_EDIT");
        this.projectMenu.add(this.projectEditMenuItem);
        this.viewFileListMenuItem = this.createMenuItem("TF_MENU_FILE_PROJWIN");
        this.projectMenu.add(this.viewFileListMenuItem);
        this.projectExitMenuItem = this.createMenuItem("TF_MENU_FILE_QUIT");
        if (!StaticUtils.onMacOSX()) {
            this.projectMenu.add(new JSeparator());
            this.projectMenu.add(this.projectExitMenuItem);
        }
        this.editUndoMenuItem = this.createMenuItem("TF_MENU_EDIT_UNDO");
        this.editMenu.add(this.editUndoMenuItem);
        this.editRedoMenuItem = this.createMenuItem("TF_MENU_EDIT_REDO");
        this.editMenu.add(this.editRedoMenuItem);
        this.editMenu.add(new JSeparator());
        this.editOverwriteTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_RECYCLE");
        this.editMenu.add(this.editOverwriteTranslationMenuItem);
        this.editInsertTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_INSERT");
        this.editMenu.add(this.editInsertTranslationMenuItem);
        this.editMenu.add(new JSeparator());
        this.editOverwriteMachineTranslationMenuItem = this.createMenuItem("TF_MENU_EDIT_OVERWRITE_MACHITE_TRANSLATION");
        this.editMenu.add(this.editOverwriteMachineTranslationMenuItem);
        this.editMenu.add(new JSeparator());
        this.editOverwriteSourceMenuItem = this.createMenuItem("TF_MENU_EDIT_SOURCE_OVERWRITE");
        this.editMenu.add(this.editOverwriteSourceMenuItem);
        this.editInsertSourceMenuItem = this.createMenuItem("TF_MENU_EDIT_SOURCE_INSERT");
        this.editMenu.add(this.editInsertSourceMenuItem);
        this.editMenu.add(new JSeparator());
        this.editTagPainterMenuItem = this.createMenuItem("TF_MENU_EDIT_TAGPAINT");
        this.editMenu.add(this.editTagPainterMenuItem);
        this.editMenu.add(new JSeparator());
        this.editExportSelectionMenuItem = this.createMenuItem("TF_MENU_EDIT_EXPORT_SELECTION");
        this.editMenu.add(this.editExportSelectionMenuItem);
        this.editCreateGlossaryEntryMenuItem = this.createMenuItem("TF_MENU_EDIT_CREATE_GLOSSARY_ENTRY");
        this.editMenu.add(this.editCreateGlossaryEntryMenuItem);
        this.editMenu.add(new JSeparator());
        this.editFindInProjectMenuItem = this.createMenuItem("TF_MENU_EDIT_FIND");
        this.editMenu.add(this.editFindInProjectMenuItem);
        this.editMenu.add(new JSeparator());
        this.switchCaseSubMenu = this.createMenu("TF_EDIT_MENU_SWITCH_CASE");
        this.editMenu.add(this.switchCaseSubMenu);
        this.editMenu.add(new JSeparator());
        this.editSelectFuzzy1MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_1");
        this.editMenu.add(this.editSelectFuzzy1MenuItem);
        this.editSelectFuzzy2MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_2");
        this.editMenu.add(this.editSelectFuzzy2MenuItem);
        this.editSelectFuzzy3MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_3");
        this.editMenu.add(this.editSelectFuzzy3MenuItem);
        this.editSelectFuzzy4MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_4");
        this.editMenu.add(this.editSelectFuzzy4MenuItem);
        this.editSelectFuzzy5MenuItem = this.createMenuItem("TF_MENU_EDIT_COMPARE_5");
        this.editMenu.add(this.editSelectFuzzy5MenuItem);
        this.editMenu.add(new JSeparator());
        this.editMultipleDefault = this.createMenuItem("MULT_MENU_DEFAULT");
        this.editMenu.add(this.editMultipleDefault);
        this.editMultipleAlternate = this.createMenuItem("MULT_MENU_MULTIPLE");
        this.editMenu.add(this.editMultipleAlternate);
        this.lowerCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_LOWER");
        this.switchCaseSubMenu.add(this.lowerCaseMenuItem);
        this.upperCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_UPPER");
        this.switchCaseSubMenu.add(this.upperCaseMenuItem);
        this.titleCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_TO_TITLE");
        this.switchCaseSubMenu.add(this.titleCaseMenuItem);
        this.switchCaseSubMenu.add(new JSeparator());
        this.cycleSwitchCaseMenuItem = this.createMenuItem("TF_EDIT_MENU_SWITCH_CASE_CYCLE");
        this.switchCaseSubMenu.add(this.cycleSwitchCaseMenuItem);
        this.gotoNextUntranslatedMenuItem = this.createMenuItem("TF_MENU_EDIT_UNTRANS");
        this.gotoMenu.add(this.gotoNextUntranslatedMenuItem);
        this.gotoNextSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_NEXT");
        this.gotoMenu.add(this.gotoNextSegmentMenuItem);
        this.gotoPreviousSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_PREV");
        this.gotoMenu.add(this.gotoPreviousSegmentMenuItem);
        this.gotoSegmentMenuItem = this.createMenuItem("TF_MENU_EDIT_GOTO");
        this.gotoMenu.add(this.gotoSegmentMenuItem);
        this.gotoNextNoteMenuItem = this.createMenuItem("TF_MENU_EDIT_NEXT_NOTE");
        this.gotoMenu.add(this.gotoNextNoteMenuItem);
        this.gotoPreviousNoteMenuItem = this.createMenuItem("TF_MENU_EDIT_PREV_NOTE");
        this.gotoMenu.add(this.gotoPreviousNoteMenuItem);
        this.gotoMenu.add(new JSeparator());
        this.gotoHistoryForwardMenuItem = this.createMenuItem("TF_MENU_GOTO_FORWARD_IN_HISTORY");
        this.gotoMenu.add(this.gotoHistoryForwardMenuItem);
        this.gotoHistoryBackMenuItem = this.createMenuItem("TF_MENU_GOTO_BACK_IN_HISTORY");
        this.gotoMenu.add(this.gotoHistoryBackMenuItem);
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_MARK_TRANSLATED");
        this.viewMenu.add(this.viewMarkTranslatedSegmentsCheckBoxMenuItem);
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_MARK_UNTRANSLATED");
        this.viewMenu.add(this.viewMarkUntranslatedSegmentsCheckBoxMenuItem);
        this.viewDisplaySegmentSourceCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_DISPLAY_SEGMENT_SOURCES");
        this.viewMenu.add(this.viewDisplaySegmentSourceCheckBoxMenuItem);
        this.viewMarkNonUniqueSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_NON_UNIQUE_SEGMENTS");
        this.viewMenu.add(this.viewMarkNonUniqueSegmentsCheckBoxMenuItem);
        this.viewMarkNotedSegmentsCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_NOTED_SEGMENTS");
        this.viewMenu.add(this.viewMarkNotedSegmentsCheckBoxMenuItem);
        this.viewMarkNBSPCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_NBSP");
        this.viewMenu.add(this.viewMarkNBSPCheckBoxMenuItem);
        this.viewMarkWhitespaceCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_WHITESPACE");
        this.viewMenu.add(this.viewMarkWhitespaceCheckBoxMenuItem);
        this.viewMarkBidiCheckBoxMenuItem = this.createCheckboxMenuItem("MW_VIEW_MENU_MARK_BIDI");
        this.viewMenu.add(this.viewMarkBidiCheckBoxMenuItem);
        this.viewModificationInfoMenu = this.createMenu("MW_VIEW_MENU_MODIFICATION_INFO");
        this.viewMenu.add(this.viewModificationInfoMenu);
        ButtonGroup viewModificationInfoMenuBG = new ButtonGroup();
        this.viewDisplayModificationInfoNoneRadioButtonMenuItem = this.createRadioButtonMenuItem("MW_VIEW_MENU_MODIFICATION_INFO_NONE", viewModificationInfoMenuBG);
        this.viewModificationInfoMenu.add(this.viewDisplayModificationInfoNoneRadioButtonMenuItem);
        this.viewDisplayModificationInfoSelectedRadioButtonMenuItem = this.createRadioButtonMenuItem("MW_VIEW_MENU_MODIFICATION_INFO_SELECTED", viewModificationInfoMenuBG);
        this.viewModificationInfoMenu.add(this.viewDisplayModificationInfoSelectedRadioButtonMenuItem);
        this.viewDisplayModificationInfoAllRadioButtonMenuItem = this.createRadioButtonMenuItem("MW_VIEW_MENU_MODIFICATION_INFO_ALL", viewModificationInfoMenuBG);
        this.viewModificationInfoMenu.add(this.viewDisplayModificationInfoAllRadioButtonMenuItem);
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem.setIcon(this.getViewMenuMarkBGIcon(Styles.COLOR_TRANSLATED));
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.setIcon(this.getViewMenuMarkBGIcon(Styles.COLOR_UNTRANSLATED));
        this.viewDisplaySegmentSourceCheckBoxMenuItem.setIcon(this.getViewMenuMarkBGIcon(Styles.COLOR_SOURCE));
        this.viewMarkNonUniqueSegmentsCheckBoxMenuItem.setIcon(this.getViewMenuMarkTextIcon(Styles.COLOR_NON_UNIQUE));
        this.viewMarkNotedSegmentsCheckBoxMenuItem.setIcon(this.getViewMenuMarkBGIcon(Styles.COLOR_NOTED));
        this.viewMarkNBSPCheckBoxMenuItem.setIcon(this.getViewMenuMarkBGIcon(Styles.COLOR_NBSP));
        this.viewMarkWhitespaceCheckBoxMenuItem.setIcon(this.getViewMenuMarkBGIcon(Styles.COLOR_WHITESPACE));
        this.viewMarkBidiCheckBoxMenuItem.setIcon(this.getViewMenuMarkBGIcon(Styles.COLOR_BIDIMARKERS));
        this.viewModificationInfoMenu.setIcon(this.getViewMenuMarkBGIcon(null));
        this.toolsValidateTagsMenuItem = this.createMenuItem("TF_MENU_TOOLS_VALIDATE");
        this.toolsMenu.add(this.toolsValidateTagsMenuItem);
        this.toolsShowStatisticsStandardMenuItem = this.createMenuItem("TF_MENU_TOOLS_STATISTICS_STANDARD");
        this.toolsMenu.add(this.toolsShowStatisticsStandardMenuItem);
        this.toolsShowStatisticsMatchesMenuItem = this.createMenuItem("TF_MENU_TOOLS_STATISTICS_MATCHES");
        this.toolsMenu.add(this.toolsShowStatisticsMatchesMenuItem);
        this.optionsTabAdvanceCheckBoxMenuItem = this.createCheckboxMenuItem("TF_MENU_DISPLAY_ADVANCE");
        this.optionsMenu.add(this.optionsTabAdvanceCheckBoxMenuItem);
        this.optionsAlwaysConfirmQuitCheckBoxMenuItem = this.createCheckboxMenuItem("MW_OPTIONSMENU_ALWAYS_CONFIRM_QUIT");
        this.optionsMenu.add(this.optionsAlwaysConfirmQuitCheckBoxMenuItem);
        this.optionsMachineTranslateMenu = this.createMenu("TF_OPTIONSMENU_MACHINETRANSLATE");
        this.optionsMenu.add(this.optionsMachineTranslateMenu);
        this.optionsGlossaryMenu = this.createMenu("TF_OPTIONSMENU_GLOSSARY");
        this.optionsMenu.add(this.optionsGlossaryMenu);
        this.optionsTransTipsMenu = this.createMenu("TF_OPTIONSMENU_TRANSTIPS");
        this.optionsMenu.add(this.optionsTransTipsMenu);
        this.optionsTransTipsEnableMenuItem = this.createCheckboxMenuItem("TF_OPTIONSMENU_TRANSTIPS_ENABLE");
        this.optionsTransTipsMenu.add(this.optionsTransTipsEnableMenuItem);
        this.optionsTransTipsExactMatchMenuItem = this.createCheckboxMenuItem("TF_OPTIONSMENU_TRANSTIPS_EXACTMATCH");
        this.optionsTransTipsMenu.add(this.optionsTransTipsExactMatchMenuItem);
        this.optionsMenu.add(new JSeparator());
        this.optionsFontSelectionMenuItem = this.createMenuItem("TF_MENU_DISPLAY_FONT");
        this.optionsMenu.add(this.optionsFontSelectionMenuItem);
        this.optionsSetupFileFiltersMenuItem = this.createMenuItem("TF_MENU_DISPLAY_FILTERS");
        this.optionsMenu.add(this.optionsSetupFileFiltersMenuItem);
        this.optionsSentsegMenuItem = this.createMenuItem("MW_OPTIONSMENU_SENTSEG");
        this.optionsMenu.add(this.optionsSentsegMenuItem);
        this.optionsSpellCheckMenuItem = this.createMenuItem("MW_OPTIONSMENU_SPELLCHECK");
        this.optionsMenu.add(this.optionsSpellCheckMenuItem);
        this.optionsWorkflowMenuItem = this.createMenuItem("MW_OPTIONSMENU_WORKFLOW");
        this.optionsMenu.add(this.optionsWorkflowMenuItem);
        this.optionsTagValidationMenuItem = this.createMenuItem("MW_OPTIONSMENU_TAGVALIDATION");
        this.optionsMenu.add(this.optionsTagValidationMenuItem);
        this.optionsTeamMenuItem = this.createMenuItem("MW_OPTIONSMENU_TEAM");
        this.optionsMenu.add(this.optionsTeamMenuItem);
        this.optionsExtTMXMenuItem = this.createMenuItem("MW_OPTIONSMENU_EXT_TMX");
        this.optionsMenu.add(this.optionsExtTMXMenuItem);
        this.optionsViewOptionsMenuItem = this.createMenuItem("MW_OPTIONSMENU_VIEW");
        this.optionsMenu.add(this.optionsViewOptionsMenuItem);
        this.optionsSaveOptionsMenuItem = this.createMenuItem("MW_OPTIONSMENU_SAVE");
        this.optionsMenu.add(this.optionsSaveOptionsMenuItem);
        this.optionsViewOptionsMenuLoginItem = this.createMenuItem("MW_OPTIONSMENU_LOGIN");
        this.optionsMenu.add(this.optionsViewOptionsMenuLoginItem);
        this.optionsRestoreGUIMenuItem = this.createMenuItem("MW_OPTIONSMENU_RESTORE_GUI");
        this.optionsMenu.add(this.optionsRestoreGUIMenuItem);
        this.optionsMenu.add(new JSeparator());
        this.helpContentsMenuItem = this.createMenuItem("TF_MENU_HELP_CONTENTS");
        this.helpMenu.add(this.helpContentsMenuItem);
        this.helpAboutMenuItem = this.createMenuItem("TF_MENU_HELP_ABOUT");
        this.helpMenu.add(this.helpAboutMenuItem);
        this.optionsGlossaryMenu.setEnabled(false);
        this.setActionCommands();
        MainWindowMenuShortcuts.setShortcuts(this.mainMenu);
        this.initMacSpecific();
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            public void onApplicationStartup() {
                MainWindowMenu.this.updateCheckboxesOnStart();
                MainWindowMenu.this.onProjectStatusChanged(false);
            }

            public void onApplicationShutdown() {
            }
        });
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                if (Core.getProject().isProjectLoaded()) {
                    MainWindowMenu.this.onProjectStatusChanged(true);
                } else {
                    MainWindowMenu.this.onProjectStatusChanged(false);
                }
            }
        });
        return this.mainMenu;
    }

    private void updateCheckboxesOnStart() {
        this.optionsTabAdvanceCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isUseTabForAdvance());
        this.optionsAlwaysConfirmQuitCheckBoxMenuItem.setSelected(Preferences.isPreference("always_confirm_quit"));
        this.optionsTransTipsEnableMenuItem.setSelected(Preferences.isPreference("transtips"));
        this.optionsTransTipsExactMatchMenuItem.setSelected(Preferences.isPreference("transtips_exact_search"));
        this.viewMarkTranslatedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkTranslated());
        this.viewMarkUntranslatedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkUntranslated());
        this.viewDisplaySegmentSourceCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isDisplaySegmentSources());
        this.viewMarkNonUniqueSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkNonUniqueSegments());
        this.viewMarkNotedSegmentsCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkNotedSegments());
        this.viewMarkNBSPCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkNBSP());
        this.viewMarkWhitespaceCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkWhitespace());
        this.viewMarkBidiCheckBoxMenuItem.setSelected(Core.getEditor().getSettings().isMarkBidi());
        this.viewDisplayModificationInfoNoneRadioButtonMenuItem.setSelected(EditorSettings.DISPLAY_MODIFICATION_INFO_NONE.equals(Core.getEditor().getSettings().getDisplayModificationInfo()));
        this.viewDisplayModificationInfoSelectedRadioButtonMenuItem.setSelected(EditorSettings.DISPLAY_MODIFICATION_INFO_SELECTED.equals(Core.getEditor().getSettings().getDisplayModificationInfo()));
        this.viewDisplayModificationInfoAllRadioButtonMenuItem.setSelected(EditorSettings.DISPLAY_MODIFICATION_INFO_ALL.equals(Core.getEditor().getSettings().getDisplayModificationInfo()));
    }

    private void initMacSpecific() {
        try {
            MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindowMenu.this.mainWindowMenuHandler.projectExitMenuItemActionPerformed();
                }
            });
            MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainWindowMenu.this.mainWindowMenuHandler.helpAboutMenuItemActionPerformed();
                }
            });
        }
        catch (NoClassDefFoundError e) {
            Log.log(e);
        }
    }

    private JMenu createMenu(String titleKey) {
        JMenu result = new JMenu();
        Mnemonics.setLocalizedText(result, OStrings.getString(titleKey));
        return result;
    }

    private JMenuItem createMenuItem(String titleKey) {
        JMenuItem result = new JMenuItem();
        Mnemonics.setLocalizedText(result, OStrings.getString(titleKey));
        result.addActionListener(this);
        return result;
    }

    private JCheckBoxMenuItem createCheckboxMenuItem(String titleKey) {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem();
        Mnemonics.setLocalizedText(result, OStrings.getString(titleKey));
        result.addActionListener(this);
        return result;
    }

    private JRadioButtonMenuItem createRadioButtonMenuItem(String titleKey, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem result = new JRadioButtonMenuItem();
        Mnemonics.setLocalizedText(result, OStrings.getString(titleKey));
        result.addActionListener(this);
        buttonGroup.add(result);
        return result;
    }

    protected void setActionCommands() {
        try {
            for (Field f : this.getClass().getDeclaredFields()) {
                if (!JMenuItem.class.isAssignableFrom(f.getType()) || f.getType() == JMenu.class) continue;
                JMenuItem menuItem = (JMenuItem)f.get(this);
                menuItem.setActionCommand(f.getName());
            }
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private void onProjectStatusChanged(boolean isProjectOpened) {
        JMenuItem[] itemsToSwitchOff = new JMenuItem[]{this.projectNewMenuItem, this.projectTeamNewMenuItem, this.projectOpenMenuItem};
        JMenuItem[] itemsToSwitchOn = new JMenuItem[]{this.projectImportMenuItem, this.projectWikiImportMenuItem, this.projectReloadMenuItem, this.projectCloseMenuItem, this.projectSaveMenuItem, this.projectEditMenuItem, this.projectCompileMenuItem, this.editMenu, this.editFindInProjectMenuItem, this.editInsertSourceMenuItem, this.editInsertTranslationMenuItem, this.editTagPainterMenuItem, this.editOverwriteSourceMenuItem, this.editOverwriteTranslationMenuItem, this.editRedoMenuItem, this.editSelectFuzzy1MenuItem, this.editSelectFuzzy2MenuItem, this.editSelectFuzzy3MenuItem, this.editSelectFuzzy4MenuItem, this.editSelectFuzzy5MenuItem, this.editUndoMenuItem, this.switchCaseSubMenu, this.editOverwriteMachineTranslationMenuItem, this.editMultipleDefault, this.editMultipleAlternate, this.gotoMenu, this.gotoNextSegmentMenuItem, this.gotoNextUntranslatedMenuItem, this.gotoPreviousSegmentMenuItem, this.gotoSegmentMenuItem, this.gotoNextNoteMenuItem, this.gotoPreviousNoteMenuItem, this.viewFileListMenuItem, this.toolsValidateTagsMenuItem, this.toolsShowStatisticsStandardMenuItem, this.toolsShowStatisticsMatchesMenuItem};
        for (JMenuItem item : itemsToSwitchOff) {
            item.setEnabled(!isProjectOpened);
        }
        for (JMenuItem item : itemsToSwitchOn) {
            item.setEnabled(isProjectOpened);
        }
    }

    public JMenu getMachineTranslationMenu() {
        return this.optionsMachineTranslateMenu;
    }

    public JMenu getOptionsMenu() {
        return this.optionsMenu;
    }

    public JMenu getToolsMenu() {
        return this.toolsMenu;
    }

    public JMenu getGlossaryMenu() {
        return this.optionsGlossaryMenu;
    }

    public JMenu getProjectMenu() {
        return this.projectMenu;
    }
}

