/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.FloatingDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.NearString;
import org.omegat.gui.filelist.ProjectFrame;
import org.omegat.gui.main.IMainMenu;
import org.omegat.gui.main.IMainWindow;
import org.omegat.gui.main.MainWindowMenu;
import org.omegat.gui.main.MainWindowMenuHandler;
import org.omegat.gui.main.MainWindowUI;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.LFileCopy;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.WikiGet;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.UIThreadsUtil;

public class MainWindow
extends JFrame
implements IMainWindow {
    public final MainWindowMenu menu;
    protected ProjectFrame m_projWin;
    private Font m_font;
    private final Set<SearchWindow> m_searches = new HashSet<SearchWindow>();
    protected JLabel lengthLabel;
    protected JLabel progressLabel;
    protected JLabel statusLabel;
    protected DockingDesktop desktop;

    public MainWindow() {
        this.menu = new MainWindowMenu(this, new MainWindowMenuHandler(this));
        this.setJMenuBar(this.menu.initComponents());
        this.getContentPane().add((Component)MainWindowUI.createStatusBar(this), "South");
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainWindow.this.menu.mainWindowMenuHandler.projectExitMenuItemActionPerformed();
            }
        });
        String fontName = Preferences.getPreferenceDefault("source_font", "Dialog");
        int fontSize = Preferences.getPreferenceDefault("source_font_size", 12);
        this.m_font = new Font(fontName, 0, fontSize);
        MainWindowUI.createMainComponents(this, this.m_font);
        this.getContentPane().add((Component)MainWindowUI.initDocking(this), "Center");
        this.setIconImage(ResourcesUtil.getIcon("/org/omegat/gui/resources/OmegaT_small.gif").getImage());
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                MainWindow.this.updateTitle();
                if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                    MainWindow.this.closeSearchWindows();
                }
            }
        });
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            public void onApplicationStartup() {
                MainWindowUI.resetDesktopLayout(MainWindow.this);
                MainWindowUI.loadScreenLayout(MainWindow.this);
                DockingUI.removeUnusedMenuSeparators(MainWindow.this.menu.getOptionsMenu().getPopupMenu());
            }

            public void onApplicationShutdown() {
            }
        });
        this.updateTitle();
    }

    public JFrame getApplicationFrame() {
        return this;
    }

    public Font getApplicationFont() {
        return this.m_font;
    }

    public IMainMenu getMainMenu() {
        return this.menu;
    }

    protected void setApplicationFont(Font newFont) {
        this.m_font = newFont;
        Preferences.setPreference("source_font", newFont.getName());
        Preferences.setPreference("source_font_size", newFont.getSize());
        CoreEvents.fireFontChanged(newFont);
    }

    public void addDockable(Dockable pane) {
        this.desktop.addDockable(pane);
    }

    private void updateTitle() {
        String s = OStrings.getDisplayVersion();
        if (Core.getProject().isProjectLoaded()) {
            s = s + " :: " + Core.getProject().getProjectProperties().getProjectName();
        }
        this.setTitle(s);
    }

    public void doInsertTrans() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        NearString near = Core.getMatcher().getActiveMatch();
        if (near != null) {
            Core.getEditor().insertText(near.translation);
        }
    }

    public void doRecycleTrans() {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        NearString near = Core.getMatcher().getActiveMatch();
        if (near != null) {
            String translation = near.translation;
            if (Preferences.isPreference("wf_convertNumbers")) {
                translation = Core.getMatcher().substituteNumbers(Core.getEditor().getCurrentEntry().getSrcText(), Core.getMatcher().getActiveMatch().source, Core.getMatcher().getActiveMatch().translation);
            }
            Core.getEditor().replaceEditText(translation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSearchWindow(SearchWindow newSearchWindow) {
        Set<SearchWindow> set = this.m_searches;
        synchronized (set) {
            this.m_searches.add(newSearchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSearchWindow(SearchWindow searchWindow) {
        Set<SearchWindow> set = this.m_searches;
        synchronized (set) {
            this.m_searches.remove(searchWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSearchWindows() {
        Set<SearchWindow> set = this.m_searches;
        synchronized (set) {
            for (SearchWindow sw : this.m_searches) {
                sw.dispose();
            }
            this.m_searches.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doImportSourceFiles() {
        OmegaTFileChooser chooser = new OmegaTFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle(OStrings.getString("TF_FILE_IMPORT_TITLE"));
        int result = chooser.showOpenDialog(this);
        if (result != 0) return;
        String projectsource = Core.getProject().getProjectProperties().getSourceRoot();
        File sourcedir = new File(projectsource);
        File[] selFiles = chooser.getSelectedFiles();
        try {
            int i = 0;
            while (true) {
                if (i >= selFiles.length) {
                    ProjectUICommands.projectReload();
                    return;
                }
                File selSrc = selFiles[i];
                if (selSrc.isDirectory()) {
                    ArrayList<String> files = new ArrayList<String>();
                    StaticUtils.buildFileList(files, selSrc, true);
                    String selSourceParent = selSrc.getParent();
                    for (String filename : files) {
                        String midName = filename.substring(selSourceParent.length());
                        File src = new File(filename);
                        File dest = new File(sourcedir, midName);
                        LFileCopy.copy(src, dest);
                    }
                } else {
                    File dest = new File(sourcedir, selFiles[i].getName());
                    LFileCopy.copy(selSrc, dest);
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            this.displayErrorRB(ioe, "MAIN_ERROR_File_Import_Failed", new Object[0]);
        }
    }

    public void doWikiImport() {
        String remote_url = JOptionPane.showInputDialog(this, OStrings.getString("TF_WIKI_IMPORT_PROMPT"), OStrings.getString("TF_WIKI_IMPORT_TITLE"), 2);
        String projectsource = Core.getProject().getProjectProperties().getSourceRoot();
        if (remote_url != null && remote_url.trim().length() > 0) {
            WikiGet.doWikiGet(remote_url, projectsource);
            ProjectUICommands.projectReload();
        }
    }

    public void showStatusMessageRB(String messageKey, Object ... params) {
        final String msg = messageKey == null ? new String() + ' ' : (params != null ? StaticUtils.format(OStrings.getString(messageKey), params) : OStrings.getString(messageKey));
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                MainWindow.this.statusLabel.setText(msg);
            }
        });
    }

    public void showProgressMessage(String messageText) {
        this.progressLabel.setText(messageText);
    }

    public void showLengthMessage(String messageText) {
        this.lengthLabel.setText(messageText);
    }

    public void displayWarningRB(final String warningKey, final Object ... params) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                String msg = params != null ? StaticUtils.format(OStrings.getString(warningKey), params) : OStrings.getString(warningKey);
                MainWindow.this.statusLabel.setText(msg);
                String fulltext = msg;
                JOptionPane.showMessageDialog(MainWindow.this, fulltext, OStrings.getString("TF_WARNING"), 2);
            }
        });
    }

    public void displayErrorRB(final Throwable ex, final String errorKey, final Object ... params) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                String msg = params != null ? StaticUtils.format(OStrings.getString(errorKey), params) : OStrings.getString(errorKey);
                MainWindow.this.statusLabel.setText(msg);
                String fulltext = msg;
                if (ex != null) {
                    fulltext = fulltext + "\n" + ex.toString();
                }
                JOptionPane.showMessageDialog(MainWindow.this, fulltext, OStrings.getString("TF_ERROR"), 0);
            }
        });
    }

    public void lockUI() {
        UIThreadsUtil.mustBeSwingThread();
        this.setEnabled(false);
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(false);
        }
        block1: for (Frame frame : this.desktop.getDockables()) {
            if (frame.isDocked()) continue;
            frame.getDockable().getComponent().setEnabled(false);
            for (Container parent = frame.getDockable().getComponent().getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof FloatingDialog)) continue;
                parent.setEnabled(false);
                continue block1;
            }
        }
    }

    public void unlockUI() {
        UIThreadsUtil.mustBeSwingThread();
        for (DockableState dockableState : this.desktop.getDockables()) {
            if (dockableState.isDocked()) continue;
            for (Container parent = dockableState.getDockable().getComponent().getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof FloatingDialog)) continue;
                parent.setEnabled(true);
                break;
            }
            dockableState.getDockable().getComponent().setEnabled(true);
        }
        for (Frame frame : Frame.getFrames()) {
            frame.setEnabled(true);
        }
        this.setEnabled(true);
    }

    public void showErrorDialogRB(String message, Object[] args, String title) {
        JOptionPane.showMessageDialog(this.getApplicationFrame(), StaticUtils.format(OStrings.getString(message), args), OStrings.getString(title), 0);
    }

    public int showConfirmDialog(Object message, String title, int optionType, int messageType) throws HeadlessException {
        return JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
    }

    public void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message);
    }
}

