/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.openide.awt.Mnemonics;

public class HelpFrame
extends JFrame {
    private static HelpFrame singleton;
    private static final String ANCH_SETHOME = "#__sethome";
    private JEditorPane m_helpPane;
    private JButton m_closeButton;
    private JButton m_homeButton;
    private JButton m_backButton;
    private List<URL> m_historyList = new ArrayList<URL>();
    private URL m_filename;
    private URL m_home;

    private HelpFrame() {
        this.initWindowLayout();
        Container cp = this.getContentPane();
        this.m_helpPane = new JEditorPane();
        this.m_helpPane.setEditable(false);
        this.m_helpPane.setContentType("text/html");
        JScrollPane scroller = new JScrollPane(this.m_helpPane);
        cp.add((Component)scroller, "Center");
        this.m_homeButton = new JButton();
        this.m_homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpFrame.this.m_historyList.add(HelpFrame.this.m_filename);
                HelpFrame.this.displayHome();
                HelpFrame.this.m_backButton.setEnabled(!HelpFrame.this.m_historyList.isEmpty());
            }
        });
        this.m_backButton = new JButton();
        this.m_backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HelpFrame.this.m_historyList.size() > 0) {
                    URL u = (URL)HelpFrame.this.m_historyList.remove(HelpFrame.this.m_historyList.size() - 1);
                    HelpFrame.this.displayURL(u);
                }
                HelpFrame.this.m_backButton.setEnabled(!HelpFrame.this.m_historyList.isEmpty());
            }
        });
        this.m_backButton.setEnabled(false);
        this.m_closeButton = new JButton();
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpFrame.this.dispose();
            }
        });
        Box bbut = Box.createHorizontalBox();
        bbut.add(this.m_backButton);
        bbut.add(Box.createHorizontalStrut(10));
        bbut.add(this.m_homeButton);
        bbut.add(Box.createHorizontalGlue());
        bbut.add(this.m_closeButton);
        cp.add((Component)bbut, "North");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                HelpFrame.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.m_helpPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpFrame.this.m_historyList.add(HelpFrame.this.m_filename);
                    HelpFrame.this.gotoLink(he.getDescription());
                    HelpFrame.this.m_backButton.setEnabled(!HelpFrame.this.m_historyList.isEmpty());
                }
            }
        });
        this.updateUIText();
        this.displayHome();
    }

    public static HelpFrame getInstance() {
        if (singleton == null) {
            singleton = new HelpFrame();
        }
        return singleton;
    }

    public static URL getHelpFileURL(String lang, String filename) {
        String path = lang != null ? lang + File.separator + filename : filename;
        File f = new File(StaticUtils.installDir() + File.separator + "docs" + File.separator + path);
        try {
            if (f.exists()) {
                return f.toURI().toURL();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        path = lang != null ? lang + '/' + filename : filename;
        URL r = HelpFrame.class.getResource("/docs/" + path);
        return r;
    }

    public void displayHome() {
        if (this.m_home != null) {
            this.displayURL(this.m_home);
        } else {
            String lang = HelpFrame.detectInitialLanguage();
            this.displayURL(HelpFrame.getHelpFileURL(lang, "index.html"));
        }
    }

    private void gotoLink(String link) {
        if (link.startsWith("http://")) {
            String txt = "<b>" + link + "</b>";
            StringBuffer buf = new StringBuffer();
            buf.append("<html><body><p>");
            buf.append(StaticUtils.format(OStrings.getString("HF_ERROR_EXTLINK_TITLE"), txt));
            buf.append("<p>");
            buf.append(StaticUtils.format(OStrings.getString("HF_ERROR_EXTLINK_MSG"), "<b>index.html</b>"));
            buf.append("</body></html>");
            this.m_helpPane.setText(buf.toString());
        } else {
            try {
                URL newPage = new URL(this.m_filename, link);
                if (link.endsWith(ANCH_SETHOME)) {
                    String s = newPage.toExternalForm();
                    s = s.substring(0, s.length() - ANCH_SETHOME.length());
                    this.m_home = newPage = new URL(s);
                }
                this.displayURL(newPage);
            }
            catch (IOException e) {
                String s = this.errorHaiku() + "<p>&nbsp;<p>" + OStrings.getString("HF_CANT_FIND_HELP") + link;
                this.m_helpPane.setText(s);
            }
        }
    }

    private void displayURL(URL url) {
        try {
            this.m_helpPane.setPage(url);
            this.m_filename = url;
        }
        catch (IOException e) {
            String s = this.errorHaiku() + "<p>&nbsp;<p>" + OStrings.getString("HF_CANT_FIND_HELP") + url;
            this.m_helpPane.setText(s);
        }
    }

    private String errorHaiku() {
        int id = new Random().nextInt(11) + 1;
        return OStrings.getString("HF_HAIKU_" + id);
    }

    private void updateUIText() {
        Mnemonics.setLocalizedText(this.m_closeButton, OStrings.getString("BUTTON_CLOSE"));
        Mnemonics.setLocalizedText(this.m_homeButton, OStrings.getString("BUTTON_HOME"));
        Mnemonics.setLocalizedText(this.m_backButton, OStrings.getString("BUTTON_BACK"));
        this.setTitle(OStrings.getString("HF_WINDOW_TITLE"));
    }

    private static String detectInitialLanguage() {
        String language = Locale.getDefault().getLanguage().toLowerCase(Locale.ENGLISH);
        String country = Locale.getDefault().getCountry().toUpperCase(Locale.ENGLISH);
        String locale = language + "_" + country;
        String version = HelpFrame.getDocVersion(locale);
        if (version != null && version.equals(OStrings.VERSION)) {
            return locale;
        }
        locale = language;
        version = HelpFrame.getDocVersion(locale);
        if (version != null && version.equals(OStrings.VERSION)) {
            return locale;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDocVersion(String locale) {
        if (HelpFrame.getHelpFileURL(locale, "index.html") == null) {
            return null;
        }
        Properties prop = new Properties();
        InputStream in = null;
        try {
            URL u = HelpFrame.getHelpFileURL(locale, "version.properties");
            in = u.openStream();
            if (in == null) {
                String string = null;
                return string;
            }
            prop.load(in);
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
        }
        return prop.getProperty("version");
    }

    private void initWindowLayout() {
        try {
            String dx = Preferences.getPreference("help_window_x");
            String dy = Preferences.getPreference("help_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.setLocation(x, y);
            String dw = Preferences.getPreference("help_window_width");
            String dh = Preferences.getPreference("help_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            this.setSize(600, 500);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("help_window_width", this.getWidth());
        Preferences.setPreference("help_window_height", this.getHeight());
        Preferences.setPreference("help_window_x", this.getX());
        Preferences.setPreference("help_window_y", this.getY());
    }

    public void processWindowEvent(WindowEvent w) {
        int evt = w.getID();
        if (evt == 201 || evt == 202) {
            this.saveWindowLayout();
        }
        super.processWindowEvent(w);
    }
}

