/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.gui.glossary.TransTips;
import org.omegat.util.Preferences;

public class TransTipsPopup
implements IPopupMenuConstructor {
    protected static final char SEPARATOR = ',';

    public void addItems(final JPopupMenu menu, JTextComponent comp, final int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        if (!Preferences.isPreference("transtips")) {
            return;
        }
        if (!isInActiveEntry || isInActiveTranslation) {
            return;
        }
        final int startSource = sb.getStartSourcePosition();
        int len = sb.getSourceText().length();
        if (mousepos < startSource || mousepos > startSource + len) {
            return;
        }
        TransTips.Search callback = new TransTips.Search(){

            public void found(GlossaryEntry ge, int start, int end) {
                if (startSource + start <= mousepos && mousepos <= startSource + end) {
                    int l;
                    String[] locs = TransTipsPopup.parseLine(ge.getLocText());
                    for (l = 1; l < locs.length; ++l) {
                        locs[l] = locs[l].trim();
                    }
                    for (l = 0; l < locs.length; ++l) {
                        final String txt = locs[l];
                        JMenuItem it = menu.add(locs[l]);
                        it.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Core.getEditor().insertText(txt);
                            }
                        });
                    }
                }
            }
        };
        for (GlossaryEntry ge : GlossaryTextArea.nowEntries) {
            TransTips.search(sb.getSourceText(), ge, callback);
        }
        menu.addSeparator();
    }

    private static String[] parseLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder term = new StringBuilder();
        boolean fopened = false;
        block4: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\"': {
                    if (term.toString().trim().length() == 0 && !fopened) {
                        fopened = true;
                        continue block4;
                    }
                    if (fopened) {
                        fopened = false;
                        continue block4;
                    }
                    term.append(c);
                    continue block4;
                }
                case ',': {
                    if (fopened) {
                        term.append(c);
                        continue block4;
                    }
                    result.add(term.toString());
                    term.setLength(0);
                    continue block4;
                }
                default: {
                    term.append(c);
                }
            }
        }
        result.add(term.toString());
        return result.toArray(new String[result.size()]);
    }
}

