/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Preferences;

public class TransTips {
    protected JTextComponent comp;
    private static List<Character> afterExcludeCases = new ArrayList<Character>();
    private static List<Character> beforeExcludeCases;

    public static void search(String sourceText, GlossaryEntry glossaryEntry, Search callback) {
        int firstOffset = -1;
        String word = glossaryEntry.getSrcText();
        if (word == null || word.equals("")) {
            return;
        }
        String content = sourceText;
        if (!word.equals(word.toUpperCase())) {
            content = sourceText.toLowerCase();
            word = word.toLowerCase();
        }
        int lastIndex = 0;
        int wordSize = word.length();
        while ((lastIndex = content.indexOf(word, lastIndex)) != -1) {
            int endIndex = lastIndex + wordSize;
            if (Preferences.isPreference("transtips_exact_search")) {
                if (TransTips.isWordAlone(content, lastIndex, word)) {
                    callback.found(glossaryEntry, lastIndex, endIndex);
                    if (firstOffset == -1) {
                        firstOffset = lastIndex;
                    }
                }
            } else {
                callback.found(glossaryEntry, lastIndex, endIndex);
                if (firstOffset == -1) {
                    firstOffset = lastIndex;
                }
            }
            lastIndex = endIndex;
        }
    }

    public static boolean isWordAlone(String sourceText, int testIndex, String glosSrc) {
        int after;
        int before;
        sourceText = sourceText.replaceAll("[\u202a|\u202b|\u202c]", " ");
        try {
            before = sourceText.toLowerCase().charAt(testIndex - 1);
        }
        catch (Exception ex) {
            before = 32;
        }
        try {
            after = sourceText.toLowerCase().charAt(testIndex + glosSrc.length());
        }
        catch (Exception cp) {
            after = 32;
        }
        if (afterExcludeCases.contains(Character.valueOf((char)after))) {
            after = 32;
        }
        if (beforeExcludeCases.contains(Character.valueOf((char)before))) {
            before = 32;
        }
        return before == 32 && after == 32;
    }

    static {
        afterExcludeCases.add(Character.valueOf('.'));
        afterExcludeCases.add(Character.valueOf('!'));
        afterExcludeCases.add(Character.valueOf('?'));
        afterExcludeCases.add(Character.valueOf(':'));
        afterExcludeCases.add(Character.valueOf(','));
        afterExcludeCases.add(Character.valueOf(';'));
        afterExcludeCases.add(Character.valueOf('<'));
        afterExcludeCases.add(Character.valueOf(')'));
        afterExcludeCases.add(Character.valueOf('-'));
        beforeExcludeCases = new ArrayList<Character>();
        beforeExcludeCases.add(Character.valueOf('>'));
        beforeExcludeCases.add(Character.valueOf('('));
        beforeExcludeCases.add(Character.valueOf(' '));
    }

    public static interface Search {
        public void found(GlossaryEntry var1, int var2, int var3);
    }
}

