/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.ITokenizer;
import org.omegat.core.matching.Tokenizer;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.util.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindGlossaryThread
extends EntryInfoSearchThread<List<GlossaryEntry>> {
    private final String src;
    private List<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
    private final GlossaryManager manager;

    public FindGlossaryThread(GlossaryTextArea pane, SourceTextEntry newEntry, GlossaryManager manager) {
        super(pane, newEntry);
        this.src = newEntry.getSrcText();
        this.manager = manager;
    }

    @Override
    protected List<GlossaryEntry> search() {
        ITokenizer tok = Core.getProject().getSourceTokenizer();
        if (tok == null) {
            return null;
        }
        Token[] strTokens = tok.tokenizeWords(this.src, ITokenizer.StemmingMode.GLOSSARY);
        List<GlossaryEntry> entries = this.manager.getGlossaryEntries(this.src);
        if (entries != null) {
            for (GlossaryEntry glosEntry : entries) {
                this.checkEntryChanged();
                String glosStr = glosEntry.getSrcText();
                Token[] glosTokens = tok.tokenizeWords(glosStr, ITokenizer.StemmingMode.GLOSSARY);
                int glosTokensN = glosTokens.length;
                if (glosTokensN == 0 || !Tokenizer.isContainsAll(strTokens, glosTokens)) continue;
                this.result.add(glosEntry);
            }
        }
        this.result = this.filterGlossary(this.result);
        for (int z = 0; z < this.result.size(); ++z) {
            for (int x = z + 1; x < this.result.size() - 1; ++x) {
                GlossaryEntry zEntry = this.result.get(z);
                GlossaryEntry xEntry = this.result.get(x);
                if (xEntry.getSrcText().length() <= zEntry.getSrcText().length()) continue;
                GlossaryEntry temp = this.result.get(x);
                this.result.set(x, this.result.get(z));
                this.result.set(z, temp);
            }
        }
        return this.result;
    }

    private String bracketEntry(String entry) {
        if (entry.contains(",") && !entry.contains(";") && !entry.contains("\"")) {
            entry = '\"' + entry + '\"';
        }
        return entry;
    }

    private List<GlossaryEntry> filterGlossary(List<GlossaryEntry> result) {
        int i;
        if (result.size() == 0) {
            return result;
        }
        LinkedList<GlossaryEntry> returnList = new LinkedList<GlossaryEntry>();
        GlossaryEntry replaceEntry = new GlossaryEntry("", "", "");
        boolean removedDuplicate = false;
        for (i = 0; i < result.size(); ++i) {
            GlossaryEntry nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            for (int j = i + 1; j < result.size(); ++j) {
                GlossaryEntry thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("") || !nowEntry.getSrcText().equals(thenEntry.getSrcText()) || !nowEntry.getLocText().equals(thenEntry.getLocText()) || !nowEntry.getCommentText().equals(thenEntry.getCommentText())) continue;
                result.set(j, replaceEntry);
                removedDuplicate = true;
            }
        }
        if (removedDuplicate) {
            Iterator<GlossaryEntry> myIter = result.iterator();
            LinkedList<GlossaryEntry> newList = new LinkedList<GlossaryEntry>();
            while (myIter.hasNext()) {
                GlossaryEntry checkEntry = myIter.next();
                if (checkEntry.getSrcText().equals("") || checkEntry.getLocText().equals("")) {
                    myIter.remove();
                    continue;
                }
                newList.add(checkEntry);
            }
            result = newList;
        }
        for (i = 0; i < result.size(); ++i) {
            LinkedList<GlossaryEntry> srcList = new LinkedList<GlossaryEntry>();
            GlossaryEntry nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            srcList.add(nowEntry);
            for (int j = i + 1; j < result.size(); ++j) {
                GlossaryEntry thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("") || !nowEntry.getSrcText().equals(thenEntry.getSrcText())) continue;
                srcList.add(thenEntry);
                result.set(j, replaceEntry);
            }
            LinkedList<GlossaryEntry> sortList = new LinkedList<GlossaryEntry>();
            if (srcList.size() > 1) {
                for (int k = 0; k < srcList.size(); ++k) {
                    GlossaryEntry srcNow = (GlossaryEntry)srcList.get(k);
                    if (srcNow.getSrcText().equals("")) continue;
                    sortList.add(srcNow);
                    for (int l = k + 1; l < srcList.size(); ++l) {
                        GlossaryEntry srcThen = (GlossaryEntry)srcList.get(l);
                        if (srcThen.getSrcText().equals("") || !srcNow.getLocText().equals(srcThen.getLocText())) continue;
                        sortList.add(srcThen);
                        srcList.set(l, replaceEntry);
                    }
                }
            } else {
                sortList = srcList;
            }
            String srcTxt = ((GlossaryEntry)sortList.get(0)).getSrcText();
            String locTxt = ((GlossaryEntry)sortList.get(0)).getLocText();
            String comTxt = "";
            int comCounter = 1;
            locTxt = this.bracketEntry(locTxt);
            String prevLocTxt = ((GlossaryEntry)sortList.get(0)).getLocText();
            String prevComTxt = ((GlossaryEntry)sortList.get(0)).getCommentText();
            if (!prevComTxt.equals("")) {
                comTxt = comCounter + ". " + prevComTxt;
            }
            for (int m = 1; m < sortList.size(); ++m) {
                if (!((GlossaryEntry)sortList.get(m)).getLocText().equals(prevLocTxt)) {
                    ++comCounter;
                    prevLocTxt = ((GlossaryEntry)sortList.get(m)).getLocText();
                    locTxt = locTxt + ", " + this.bracketEntry(prevLocTxt);
                    if (((GlossaryEntry)sortList.get(m)).getCommentText().equals("")) continue;
                    if (comTxt.equals("")) {
                        comTxt = comCounter + ". " + ((GlossaryEntry)sortList.get(m)).getCommentText();
                        continue;
                    }
                    comTxt = comTxt + "\n" + comCounter + ". " + ((GlossaryEntry)sortList.get(m)).getCommentText();
                    continue;
                }
                if (((GlossaryEntry)sortList.get(m)).getCommentText().equals("")) continue;
                comTxt = comTxt.equals("") ? comCounter + ". " + ((GlossaryEntry)sortList.get(m)).getCommentText() : comTxt + "\n" + comCounter + ". " + ((GlossaryEntry)sortList.get(m)).getCommentText();
            }
            GlossaryEntry combineEntry = new GlossaryEntry(srcTxt, locTxt, comTxt);
            returnList.add(combineEntry);
        }
        return returnList;
    }
}

