/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filters2;

import gen.core.filters.Files;
import gen.core.filters.Filter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.omegat.core.Core;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.OneFilterTableModel;
import org.omegat.gui.filters2.InstanceEditor;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.openide.awt.Mnemonics;

public class FilterEditor
extends JDialog
implements ListSelectionListener {
    private Filter filter;
    public Filter result;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextArea descTextArea;
    private JButton editButton;
    private JLabel fileFormatLabel;
    private JTextField fileFormatTextField;
    private JTextArea hintTextArea;
    private JTable instances;
    private JScrollPane instancesScrollPane;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JButton okButton;
    private JButton removeButton;
    private JButton toDefaultsButton;

    public FilterEditor(Dialog parent, Filter filter) {
        super(parent, true);
        this.filter = FilterMaster.cloneFilter(filter);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FilterEditor.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        IFilter f = FilterMaster.getFilterInstance(filter.getClassName());
        this.fileFormatTextField.setText(f.getFileFormatName());
        if (!StringUtil.isEmpty(f.getHint())) {
            this.hintTextArea.setText(f.getHint());
        } else {
            this.hintTextArea.setVisible(false);
        }
        this.getRootPane().setDefaultButton(this.okButton);
        this.instances.setSelectionMode(0);
        this.instances.getSelectionModel().addListSelectionListener(this);
        TableColumn sourceEnc = this.instances.getColumnModel().getColumn(1);
        sourceEnc.setCellEditor(new DefaultCellEditor(this.encodingComboBox()));
        TableColumn targetEnc = this.instances.getColumnModel().getColumn(2);
        targetEnc.setCellEditor(new DefaultCellEditor(this.encodingComboBox()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.instancesScrollPane.getPreferredSize().width + 200;
        if (width > screenSize.width) {
            width = screenSize.width - this.addButton.getWidth() - 50;
        }
        this.instancesScrollPane.setPreferredSize(new Dimension(width, this.instances.getPreferredSize().height + 70));
        this.pack();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private JComboBox encodingComboBox() {
        return new JComboBox<String>(new Vector<String>(FilterMaster.getSupportedEncodings()));
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.toDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.fileFormatLabel = new JLabel();
        this.fileFormatTextField = new JTextField();
        this.descTextArea = new JTextArea();
        this.jPanel3 = new JPanel();
        this.instancesScrollPane = new JScrollPane();
        this.instances = new JTable();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.addButton = new JButton();
        this.hintTextArea = new JTextArea();
        this.setTitle(OStrings.getString("FILTEREDITOR_Edit_a_single_file_filter"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FilterEditor.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.toDefaultsButton, OStrings.getString("BUTTON_TO_DEFAULTS"));
        this.toDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.toDefaultsButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.toDefaultsButton);
        this.jLabel1.setPreferredSize(new Dimension(20, 0));
        this.buttonPanel.add(this.jLabel1);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        Mnemonics.setLocalizedText(this.fileFormatLabel, OStrings.getString("FILTEREDITOR_File_Format"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fileFormatLabel, gridBagConstraints);
        this.fileFormatTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.fileFormatTextField, gridBagConstraints);
        this.descTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descTextArea.setEditable(false);
        this.descTextArea.setFont(new JLabel().getFont());
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(OStrings.getString("FILTEREDITOR_DESC"));
        this.descTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.descTextArea, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.instances.setModel(new OneFilterTableModel(this.filter));
        this.instancesScrollPane.setViewportView(this.instances);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.instancesScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText(this.removeButton, OStrings.getString("BUTTON_REMOVE"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.editButton, OStrings.getString("BUTTON_EDIT"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.addButton, OStrings.getString("BUTTON_ADD"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.hintTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.hintTextArea.setEditable(false);
        this.hintTextArea.setFont(new JLabel().getFont());
        this.hintTextArea.setLineWrap(true);
        this.hintTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.hintTextArea, gridBagConstraints);
        this.pack();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.instances.getSelectedRow();
        Files instance = this.filter.getFiles().get(row);
        if (0 == JOptionPane.showConfirmDialog(this, StaticUtils.format(OStrings.getString("FILTEREDITOR_really_delete_filter_instance"), instance.getSourceFilenameMask()), OStrings.getString("FILTEREDITOR_Confirm_deletion_TITLE"), 0, 3)) {
            this.filter.getFiles().remove(row);
            this.instances.setModel(new OneFilterTableModel(this.filter));
        }
    }

    private void toDefaultsButtonActionPerformed(ActionEvent evt) {
        try {
            Core.getFilterMaster();
            this.filter = FilterMaster.getDefaultSettingsFromFilter(this.filter.getClassName());
            this.instances.setModel(new OneFilterTableModel(this.filter));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, OStrings.getString("FILTEREDITOR_ERROR_Reverting_To_Def") + e, OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        IFilter f = FilterMaster.getFilterInstance(this.filter.getClassName());
        InstanceEditor ie = new InstanceEditor((Dialog)this, f.isSourceEncodingVariable(), f.isTargetEncodingVariable(), f.getHint());
        ie.setVisible(true);
        if (ie.getReturnStatus() == 1) {
            Files ff = new Files();
            ff.setSourceEncoding(this.setEncodingName(ie.getSourceEncoding()));
            ff.setSourceFilenameMask(ie.getSourceFilenameMask());
            ff.setTargetEncoding(this.setEncodingName(ie.getTargetEncoding()));
            ff.setTargetFilenamePattern(ie.getTargetFilenamePattern());
            this.filter.getFiles().add(ff);
            this.instances.setModel(new OneFilterTableModel(this.filter));
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int row = this.instances.getSelectedRow();
        IFilter f = FilterMaster.getFilterInstance(this.filter.getClassName());
        InstanceEditor ie = new InstanceEditor(this, f.isSourceEncodingVariable(), f.isTargetEncodingVariable(), f.getHint(), this.instances.getModel().getValueAt(row, 0).toString(), this.instances.getModel().getValueAt(row, 1).toString(), this.instances.getModel().getValueAt(row, 2).toString(), this.instances.getModel().getValueAt(row, 3).toString());
        ie.setVisible(true);
        if (ie.getReturnStatus() == 1) {
            Files ff = new Files();
            ff.setSourceEncoding(this.setEncodingName(ie.getSourceEncoding()));
            ff.setSourceFilenameMask(ie.getSourceFilenameMask());
            ff.setTargetEncoding(this.setEncodingName(ie.getTargetEncoding()));
            ff.setTargetFilenamePattern(ie.getTargetFilenamePattern());
            this.filter.getFiles().set(row, ff);
            this.instances.setModel(new OneFilterTableModel(this.filter));
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(this.filter);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(null);
    }

    private void doClose(Filter r) {
        this.result = r;
        this.setVisible(false);
        this.dispose();
    }

    private String setEncodingName(String encName) {
        return OStrings.getString("ENCODING_AUTO").equals(encName) ? null : encName;
    }
}

