/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filelist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class ProjectFrame
extends JFrame {
    private static final Color COLOR_STANDARD_FG = Color.BLACK;
    private static final Color COLOR_STANDARD_BG = Color.WHITE;
    private static final Color COLOR_CURRENT_FG = Color.BLACK;
    private static final Color COLOR_CURRENT_BG = new Color(13164018);
    private static final Color COLOR_SELECTION_FG = Color.WHITE;
    private static final Color COLOR_SELECTION_BG = new Color(3110874);
    private static final int LINE_SPACING = 6;
    private JTable tableFiles;
    private JTable tableTotal;
    private JScrollPane scrollFiles;
    private AbstractTableModel modelFiles;
    private AbstractTableModel modelTotal;
    private List<IProject.FileInfo> files;
    private JTextArea statLabel;
    private JButton m_addNewFileButton;
    private JButton m_wikiImportButton;
    private JButton m_closeButton;
    private MainWindow m_parent;
    private Font dialogFont;

    public ProjectFrame(MainWindow parent) {
        this.m_parent = parent;
        this.createTableFiles();
        this.dialogFont = this.tableFiles.getFont();
        this.createTableTotal();
        this.initWindowLayout();
        JPanel cp = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.scrollFiles = new JScrollPane(this.tableFiles, 20, 31);
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        cp.add((Component)this.scrollFiles, gbc);
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        cp.add((Component)this.tableTotal, gbc);
        cp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setContentPane(cp);
        this.m_addNewFileButton = new JButton();
        Mnemonics.setLocalizedText(this.m_addNewFileButton, OStrings.getString("TF_MENU_FILE_IMPORT"));
        this.m_addNewFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.doImportSourceFiles();
            }
        });
        this.m_wikiImportButton = new JButton();
        Mnemonics.setLocalizedText(this.m_wikiImportButton, OStrings.getString("TF_MENU_WIKI_IMPORT"));
        this.m_wikiImportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.doWikiImport();
            }
        });
        this.m_closeButton = new JButton();
        this.m_closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.doCancel();
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        Mnemonics.setLocalizedText(this.m_closeButton, OStrings.getString("BUTTON_CLOSE"));
        this.setTitle(OStrings.getString("PF_WINDOW_TITLE"));
        this.statLabel = new JTextArea();
        this.statLabel.setFont(this.getFont());
        this.statLabel.setEditable(false);
        this.statLabel.setLineWrap(true);
        this.statLabel.setBackground(this.getBackground());
        gbc.gridy = 5;
        gbc.insets = new Insets(10, 0, 0, 0);
        cp.add((Component)this.statLabel, gbc);
        Box bbut = Box.createHorizontalBox();
        bbut.add(Box.createHorizontalGlue());
        bbut.add(this.m_addNewFileButton);
        bbut.add(this.m_wikiImportButton);
        bbut.add(this.m_closeButton);
        bbut.add(Box.createHorizontalGlue());
        bbut.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        gbc.gridy = 6;
        cp.add((Component)bbut, gbc);
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                switch (eventType) {
                    case CLOSE: {
                        ProjectFrame.this.setVisible(false);
                        break;
                    }
                    case LOAD: 
                    case CREATE: {
                        ProjectFrame.this.buildDisplay();
                        ProjectFrame.this.setVisible(true);
                        ProjectFrame.this.tableFiles.requestFocus();
                        ProjectFrame.this.buildTotalTableLayout();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ProjectFrame.this.toFront();
                            }
                        });
                    }
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String activeFileName) {
                ProjectFrame.this.tableFiles.repaint();
                ProjectFrame.this.tableTotal.repaint();
                ProjectFrame.this.modelTotal.fireTableDataChanged();
            }

            public void onEntryActivated(SourceTextEntry newEntry) {
                UIThreadsUtil.mustBeSwingThread();
                ProjectFrame.this.modelTotal.fireTableDataChanged();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font newFont) {
                if (!Preferences.isPreference("project_files_use_font")) {
                    newFont = ProjectFrame.this.dialogFont;
                }
                ProjectFrame.this.tableFiles.setFont(newFont);
                ProjectFrame.this.tableTotal.setFont(new Font(newFont.getName(), 1, newFont.getSize()));
                ProjectFrame.this.tableFiles.setRowHeight(newFont.getSize() + 6);
                ProjectFrame.this.tableTotal.setRowHeight(newFont.getSize() + 6);
            }
        });
        CoreEvents.registerApplicationEventListener(new IApplicationEventListener(){

            public void onApplicationStartup() {
            }

            public void onApplicationShutdown() {
                ProjectFrame.this.saveWindowLayout();
            }
        });
        this.tableFiles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ProjectFrame.this.gotoFile(ProjectFrame.this.tableFiles.rowAtPoint(e.getPoint()));
            }
        });
        this.tableFiles.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ProjectFrame.this.gotoFile(ProjectFrame.this.tableFiles.getSelectedRow());
                    e.consume();
                }
            }
        });
    }

    private void initWindowLayout() {
        try {
            String dx = Preferences.getPreference("project_files_window_x");
            String dy = Preferences.getPreference("project_files_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.setLocation(x, y);
            String dw = Preferences.getPreference("project_files_window_width");
            String dh = Preferences.getPreference("project_files_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds((screenSize.width - 640) / 2, (screenSize.height - 400) / 2, 640, 400);
        }
    }

    private void saveWindowLayout() {
        Preferences.setPreference("project_files_window_width", this.getWidth());
        Preferences.setPreference("project_files_window_height", this.getHeight());
        Preferences.setPreference("project_files_window_x", this.getX());
        Preferences.setPreference("project_files_window_y", this.getY());
    }

    private void doCancel() {
        this.setVisible(false);
    }

    public void buildDisplay() {
        String path;
        UIThreadsUtil.mustBeSwingThread();
        String statFileName = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats.txt";
        File statFile = new File(statFileName);
        try {
            path = statFile.getCanonicalPath();
        }
        catch (IOException ex) {
            path = statFile.getAbsolutePath();
        }
        String statText = MessageFormat.format(OStrings.getString("PF_STAT_PATH"), path);
        this.statLabel.setText(statText);
        this.files = Core.getProject().getProjectFiles();
        this.modelFiles.fireTableDataChanged();
        String currentFile = Core.getEditor().getCurrentFile();
        List<IProject.FileInfo> fs = this.files;
        for (int i = 0; i < fs.size(); ++i) {
            if (!fs.get((int)i).filePath.equals(currentFile)) continue;
            this.tableFiles.getSelectionModel().setSelectionInterval(i, i);
            this.tableFiles.scrollRectToVisible(this.tableFiles.getCellRect(i, 0, true));
            break;
        }
        this.uiUpdateImportButtonStatus();
    }

    private void buildTotalTableLayout() {
        this.scrollFiles.setBorder(BorderFactory.createEmptyBorder());
        Border b2 = this.scrollFiles.getBorder();
        Insets i1 = b2.getBorderInsets(this.tableFiles);
        int sc = this.scrollFiles.getVerticalScrollBar().isVisible() ? this.scrollFiles.getVerticalScrollBar().getWidth() : 0;
        GridBagLayout ly = (GridBagLayout)this.getContentPane().getLayout();
        GridBagConstraints c = ly.getConstraints(this.tableTotal);
        c.insets = new Insets(0, i1.left, 0, sc);
        ly.setConstraints(this.tableTotal, c);
    }

    private void createTableFiles() {
        this.tableFiles = new JTable();
        this.tableFiles.setForeground(COLOR_STANDARD_FG);
        this.tableFiles.setBackground(COLOR_STANDARD_BG);
        this.tableFiles.setSelectionForeground(COLOR_SELECTION_FG);
        this.tableFiles.setSelectionBackground(COLOR_SELECTION_BG);
        this.modelFiles = new AbstractTableModel(){

            public Object getValueAt(int rowIndex, int columnIndex) {
                IProject.FileInfo fi;
                try {
                    fi = (IProject.FileInfo)ProjectFrame.this.files.get(rowIndex);
                }
                catch (IndexOutOfBoundsException ex) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return fi.filePath;
                    }
                    case 1: {
                        return fi.filterFileFormatName;
                    }
                    case 2: {
                        return fi.fileEncoding;
                    }
                    case 3: {
                        return fi.entries.size();
                    }
                }
                return null;
            }

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                return ProjectFrame.this.files.size();
            }
        };
        this.tableFiles.setModel(this.modelFiles);
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        TableColumn cFile = new TableColumn(0, 150);
        cFile.setHeaderValue(OStrings.getString("PF_FILENAME"));
        cFile.setCellRenderer(new CustomRenderer(2, null, true));
        TableColumn cFilter = new TableColumn(1, 100);
        cFilter.setHeaderValue(OStrings.getString("PF_FILTERNAME"));
        cFilter.setCellRenderer(new CustomRenderer(2, null, true));
        TableColumn cEncoding = new TableColumn(2, 50);
        cEncoding.setHeaderValue(OStrings.getString("PF_ENCODING"));
        cEncoding.setCellRenderer(new CustomRenderer(2, null, true));
        TableColumn cCount = new TableColumn(3, 50);
        cCount.setHeaderValue(OStrings.getString("PF_NUM_SEGMENTS"));
        cCount.setCellRenderer(new CustomRenderer(4, ",##0", true));
        columns.addColumn(cFile);
        columns.addColumn(cFilter);
        columns.addColumn(cEncoding);
        columns.addColumn(cCount);
        this.tableFiles.setColumnModel(columns);
        this.tableFiles.setSelectionMode(1);
    }

    private void createTableTotal() {
        this.tableTotal = new JTable();
        this.tableTotal.setForeground(COLOR_STANDARD_FG);
        this.tableTotal.setBackground(COLOR_STANDARD_BG);
        this.tableTotal.setSelectionForeground(COLOR_SELECTION_FG);
        this.tableTotal.setSelectionBackground(COLOR_SELECTION_BG);
        this.modelTotal = new AbstractTableModel(){

            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    switch (rowIndex) {
                        case 0: {
                            return OStrings.getString("GUI_PROJECT_TOTAL_SEGMENTS");
                        }
                        case 1: {
                            return OStrings.getString("GUI_PROJECT_UNIQUE_SEGMENTS");
                        }
                        case 2: {
                            return OStrings.getString("GUI_PROJECT_TRANSLATED");
                        }
                    }
                } else {
                    if (columnIndex == 1) {
                        return "";
                    }
                    if (columnIndex == 2) {
                        return "";
                    }
                    StatisticsInfo stat = Core.getProject().getStatistics();
                    switch (rowIndex) {
                        case 0: {
                            return stat.numberOfSegmentsTotal;
                        }
                        case 1: {
                            return stat.numberOfUniqueSegments;
                        }
                        case 2: {
                            return stat.numberofTranslatedSegments;
                        }
                    }
                }
                return null;
            }

            public int getColumnCount() {
                return 4;
            }

            public int getRowCount() {
                return 3;
            }
        };
        this.tableTotal.setModel(this.modelTotal);
        DefaultTableColumnModel columns = new DefaultTableColumnModel();
        TableColumn cFile = new TableColumn(0, 150);
        cFile.setCellRenderer(new CustomRenderer(2, null, false));
        TableColumn cFilter = new TableColumn(1, 100);
        cFilter.setCellRenderer(new CustomRenderer(2, null, false));
        TableColumn cEncoding = new TableColumn(2, 50);
        cEncoding.setCellRenderer(new CustomRenderer(2, null, false));
        TableColumn cCount = new TableColumn(3, 50);
        cCount.setCellRenderer(new CustomRenderer(4, ",##0", false));
        columns.addColumn(cFile);
        columns.addColumn(cFilter);
        columns.addColumn(cEncoding);
        columns.addColumn(cCount);
        this.tableTotal.setColumnModel(columns);
        this.tableTotal.setBorder(BorderFactory.createEmptyBorder(50, 5, 10, 5));
        this.tableFiles.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
                ProjectFrame.this.changeTotalColumns();
            }

            public void columnMoved(TableColumnModelEvent e) {
                ProjectFrame.this.tableTotal.getColumnModel().moveColumn(e.getFromIndex(), e.getToIndex());
                ProjectFrame.this.changeTotalColumns();
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.tableFiles.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ProjectFrame.this.changeTotalColumns();
            }
        });
    }

    private void changeTotalColumns() {
        for (int i = 0; i < this.tableFiles.getColumnCount(); ++i) {
            TableColumn f = this.tableFiles.getColumnModel().getColumn(i);
            TableColumn t = this.tableTotal.getColumnModel().getColumn(i);
            t.setMaxWidth(f.getWidth());
            t.setMinWidth(f.getWidth());
            t.setPreferredWidth(f.getWidth());
        }
    }

    private void doImportSourceFiles() {
        this.m_parent.doImportSourceFiles();
    }

    private void doWikiImport() {
        this.m_parent.doWikiImport();
    }

    public void uiUpdateImportButtonStatus() {
        this.m_addNewFileButton.setEnabled(Core.getProject().isProjectLoaded());
        this.m_wikiImportButton.setEnabled(Core.getProject().isProjectLoaded());
    }

    private void gotoFile(int row) {
        try {
            this.files.get(row);
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.getCursor();
        this.setCursor(hourglassCursor);
        Core.getEditor().gotoFile(row);
        Core.getEditor().requestFocus();
        this.setCursor(oldCursor);
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (Preferences.isPreference("project_files_use_font")) {
            String fontName = Preferences.getPreference("source_font");
            int fontSize = Integer.valueOf(Preferences.getPreference("source_font_size"));
            this.tableFiles.setFont(new Font(fontName, 0, fontSize));
            this.tableTotal.setFont(new Font(fontName, 1, fontSize));
            this.tableFiles.setRowHeight(fontSize + 6);
            this.tableTotal.setRowHeight(fontSize + 6);
        }
    }

    private class CustomRenderer
    extends DefaultTableCellRenderer {
        protected DecimalFormat pattern;
        private boolean showCurrentFile;

        public CustomRenderer(int alignment, String decimalPattern, boolean showCurrentFile) {
            this.setHorizontalAlignment(alignment);
            this.showCurrentFile = showCurrentFile;
            if (decimalPattern != null) {
                this.pattern = new DecimalFormat(decimalPattern);
            }
        }

        protected void setValue(Object value) {
            if (this.pattern != null && value instanceof Number) {
                super.setValue(this.pattern.format((Number)value));
            } else {
                super.setValue(value);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this.showCurrentFile) {
                IProject.FileInfo fi;
                try {
                    fi = (IProject.FileInfo)ProjectFrame.this.files.get(row);
                }
                catch (IndexOutOfBoundsException ex) {
                    fi = null;
                }
                if (isSelected) {
                    super.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    super.setForeground(table.getForeground());
                    super.setBackground(table.getBackground());
                }
                if (fi != null && fi.filePath.equals(Core.getEditor().getCurrentFile())) {
                    result.setForeground(COLOR_CURRENT_FG);
                    result.setBackground(COLOR_CURRENT_BG);
                }
            }
            return result;
        }
    }
}

