/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.gui.editor.mark.AbstractMarker;
import org.omegat.gui.editor.mark.SymbolPainter;
import org.omegat.util.OStrings;
import org.omegat.util.gui.Styles;

public class WhitespaceMarkerFactory {

    public static class LFMarker
    extends AbstractMarker {
        public LFMarker() throws Exception {
            this.PAINTER = new SymbolPainter(Styles.COLOR_WHITESPACE, "\u00b6");
            this.toolTip = "LF";
            this.pattern = Pattern.compile("\\n");
        }

        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }

    public static class TabMarker
    extends AbstractMarker {
        public TabMarker() throws Exception {
            this.PAINTER = new SymbolPainter(Styles.COLOR_WHITESPACE, "\u00bb");
            this.toolTip = OStrings.getString("MARKER_TAB");
            this.pattern = Pattern.compile("\\t");
        }

        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }

    public static class SpaceMarker
    extends AbstractMarker {
        public SpaceMarker() throws Exception {
            this.PAINTER = new SymbolPainter(Styles.COLOR_WHITESPACE, "\u00b7");
            this.toolTip = null;
            this.pattern = Pattern.compile(" ");
        }

        protected boolean isEnabled() {
            return Core.getEditor().getSettings().isMarkWhitespace();
        }
    }
}

