/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.mark.EntryMarks;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.util.Log;

public class CalcMarkersThread
extends Thread {
    private final Queue<EntryMarks> forCheck = new LinkedList<EntryMarks>();
    private final Queue<EntryMarks> forOutput = new LinkedList<EntryMarks>();
    private final MarkerController mController;
    private final int markerIndex;
    private final IMarker marker;

    public CalcMarkersThread(MarkerController mc, IMarker marker, int markerIndex) {
        this.mController = mc;
        this.markerIndex = markerIndex;
        this.marker = marker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Queue<EntryMarks> queue = this.forCheck;
        synchronized (queue) {
            this.forCheck.clear();
        }
        queue = this.forOutput;
        synchronized (queue) {
            this.forOutput.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SegmentBuilder[] entryBuilders) {
        ArrayList<EntryMarks> vers = new ArrayList<EntryMarks>(entryBuilders.length);
        for (int i = 0; i < entryBuilders.length; ++i) {
            EntryMarks v = new EntryMarks(i, entryBuilders[i], entryBuilders[i].getDisplayVersion());
            vers.add(v);
        }
        Queue<EntryMarks> queue = this.forCheck;
        synchronized (queue) {
            this.forCheck.addAll(vers);
            this.forCheck.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int entryIndex, SegmentBuilder entryBuilder) {
        EntryMarks v = new EntryMarks(entryIndex, entryBuilder, entryBuilder.getDisplayVersion());
        Queue<EntryMarks> queue = this.forCheck;
        synchronized (queue) {
            this.forCheck.add(v);
            this.forCheck.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        Thread.currentThread().setName(this.getClass().getSimpleName() + " - " + this.marker.getClass().getSimpleName());
        block10: while (true) {
            try {
                while (true) {
                    EntryMarks ev;
                    Queue<EntryMarks> queue = this.forCheck;
                    synchronized (queue) {
                        ev = this.forCheck.poll();
                        if (ev == null) {
                            this.showOutput();
                            this.forCheck.wait();
                        }
                    }
                    if (ev == null) continue;
                    try {
                        if (this.mController.isEntryChanged(ev)) continue;
                        ev.result = this.marker.getMarksForEntry(ev.sourceText, ev.translationText, ev.isActive);
                        if (ev.result == null || this.mController.isEntryChanged(ev)) continue;
                        queue = this.forOutput;
                        synchronized (queue) {
                            this.forOutput.add(ev);
                            continue block10;
                        }
                    }
                    catch (Exception ex) {
                        Log.log(ex);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                Log.log(ex);
                return;
            }
        }
    }

    protected void showOutput() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    EntryMarks ev;
                    Queue queue = CalcMarkersThread.this.forOutput;
                    synchronized (queue) {
                        ev = (EntryMarks)CalcMarkersThread.this.forOutput.poll();
                    }
                    if (ev == null) {
                        return;
                    }
                    if (CalcMarkersThread.this.mController.isEntryChanged(ev)) continue;
                    CalcMarkersThread.this.mController.setEntryMarks(ev.entryIndex, ev.builder, ev.result, CalcMarkersThread.this.markerIndex);
                }
            }
        });
    }
}

