/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.omegat.util.Log;

public class UnderlineFactory {

    public static abstract class Underliner
    extends LayeredHighlighter.LayerPainter {
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            Rectangle rect = null;
            if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
                rect = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    rect = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                }
                catch (BadLocationException ex) {
                    Log.log(ex);
                    return null;
                }
            }
            this.paint(g, rect, c);
            return rect;
        }

        protected abstract void paint(Graphics var1, Rectangle var2, JTextComponent var3);

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        }
    }

    public static class WaveUnderline
    extends Underliner {
        protected final Color color;

        public WaveUnderline(Color c) {
            this.color = c;
        }

        protected void paint(Graphics g, Rectangle a, JTextComponent c) {
            g.setColor(this.color);
            int y = a.y + a.height - 2;
            int x1 = a.x;
            int x2 = a.x + a.width;
            int w = 3;
            int h = 2;
            Shape prevClip = g.getClip();
            g.setClip(a);
            for (int i = x1; i <= x2; i += w * 2) {
                g.drawArc(i + 0, y - h, w, h, 0, 180);
                g.drawArc(i + w, y - h, w, h, 180, 181);
            }
            g.setClip(prevClip);
        }
    }

    public static class SolidBoldUnderliner
    extends Underliner {
        protected final Color color;

        public SolidBoldUnderliner(Color c) {
            this.color = c;
        }

        protected void paint(Graphics g, Rectangle rect, JTextComponent c) {
            g.setColor(this.color);
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int baseline = rect.y + rect.height - fm.getDescent() + 1;
            g.drawLine(rect.x, baseline, rect.x + rect.width, baseline);
            g.drawLine(rect.x, baseline + 1, rect.x + rect.width, baseline + 1);
        }
    }

    public static class SolidUnderliner
    extends Underliner {
        protected final Color color;

        public SolidUnderliner(Color c) {
            this.color = c;
        }

        protected void paint(Graphics g, Rectangle rect, JTextComponent c) {
            g.setColor(this.color);
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int baseline = rect.y + rect.height - fm.getDescent() + 1;
            g.drawLine(rect.x, baseline, rect.x + rect.width, baseline);
        }
    }
}

