/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.ArrayList;
import java.util.List;

class SegmentHistory {
    private int pointer = -1;
    private List<Integer> history = new ArrayList<Integer>();

    protected SegmentHistory() {
    }

    public boolean hasNext() {
        return this.pointer > -1 && this.pointer < this.history.size() - 1;
    }

    public boolean hasPrev() {
        return this.pointer > 0;
    }

    public void insertNew(int segmentNumber) {
        if (this.pointer > -1) {
            int current = this.history.get(this.pointer);
            if (current == segmentNumber) {
                return;
            }
            if (this.pointer < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.pointer; --i) {
                    this.history.remove(i);
                }
            }
        }
        this.history.add(new Integer(segmentNumber));
        ++this.pointer;
    }

    public int getValue() {
        if (this.pointer > -1) {
            return this.get(this.pointer);
        }
        return -1;
    }

    public int back() {
        if (this.pointer < 0) {
            return -1;
        }
        if (this.pointer > 0) {
            --this.pointer;
        }
        int result = this.get(this.pointer);
        return result;
    }

    public int forward() {
        if (this.pointer == -1 || this.pointer >= this.history.size() - 1) {
            return -1;
        }
        return this.get(++this.pointer);
    }

    private int get(int index) {
        return this.history.get(index);
    }

    public void clear() {
        this.history.clear();
        this.pointer = -1;
    }
}

