/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class EditorUtils {
    public static boolean isRTL(String language) {
        return "ar".equalsIgnoreCase(language) || "iw".equalsIgnoreCase(language) || "he".equalsIgnoreCase(language) || "fa".equalsIgnoreCase(language) || "ur".equalsIgnoreCase(language) || "ug".equalsIgnoreCase(language) || "ji".equalsIgnoreCase(language) || "yi".equalsIgnoreCase(language);
    }

    public static boolean localeIsRTL() {
        String language = Locale.getDefault().getLanguage().toLowerCase();
        return EditorUtils.isRTL(language);
    }

    public static int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        int result = Utilities.getWordStart(c, offs);
        char ch = c.getDocument().getText(result, 1).charAt(0);
        if (EditorUtils.isDirectionChar(ch)) {
            ++result;
        }
        return result;
    }

    public static int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        char ch;
        int result = Utilities.getWordEnd(c, offs);
        if (result > 0 && EditorUtils.isDirectionChar(ch = c.getDocument().getText(result - 1, 1).charAt(0))) {
            --result;
        }
        return result;
    }

    private static boolean isDirectionChar(char ch) {
        return ch == '\u202a' || ch == '\u202b' || ch == '\u202c';
    }

    public static String removeDirectionChars(String text) {
        return text.replaceAll("[\u202a\u202b\u202c]", "");
    }
}

