/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.undo.UndoManager;
import org.omegat.core.CoreEvents;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.ViewLabel;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.DockingUI;

public class EditorTextArea3
extends JEditorPane {
    protected final UndoManager undoManager = new UndoManager();
    protected final EditorController controller;
    protected final List<PopupMenuConstructorInfo> popupConstructors = new ArrayList<PopupMenuConstructorInfo>();
    protected String currentWord;
    protected MouseListener mouseListener = new MouseAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            int mousepos = EditorTextArea3.this.viewToModel(e.getPoint());
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                EditorTextArea3.this.controller.goToSegmentAtLocation(mousepos);
            }
            if (e.isPopupTrigger() || e.getButton() == 3) {
                PopupMenuConstructorInfo[] cons;
                List<PopupMenuConstructorInfo> list = EditorTextArea3.this.popupConstructors;
                synchronized (list) {
                    cons = EditorTextArea3.this.popupConstructors.toArray(new PopupMenuConstructorInfo[EditorTextArea3.this.popupConstructors.size()]);
                }
                boolean isInActiveTranslation = mousepos >= EditorTextArea3.this.getOmDocument().getTranslationStart() && mousepos <= EditorTextArea3.this.getOmDocument().getTranslationEnd();
                int ae = EditorTextArea3.this.controller.displayedEntryIndex;
                SegmentBuilder sb = EditorTextArea3.this.controller.m_docSegList[ae];
                boolean isInActiveEntry = sb.isActive() ? mousepos >= sb.getStartPosition() && mousepos <= sb.getEndPosition() : false;
                JPopupMenu popup = new JPopupMenu();
                for (PopupMenuConstructorInfo c : cons) {
                    c.constructor.addItems(popup, EditorTextArea3.this, mousepos, isInActiveEntry, isInActiveTranslation, sb);
                }
                DockingUI.removeUnusedMenuSeparators(popup);
                if (popup.getComponentCount() > 0) {
                    popup.show(EditorTextArea3.this, (int)e.getPoint().getX(), (int)e.getPoint().getY());
                }
            }
        }
    };
    public static ViewFactory factory3 = new ViewFactory(){

        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new ViewLabel(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new ViewLabel(elem);
        }
    };

    public EditorTextArea3(EditorController controller) {
        this.controller = controller;
        this.setEditorKit(new StyledEditorKit(){

            public ViewFactory getViewFactory() {
                return factory3;
            }

            protected void createInputAttributes(Element element, MutableAttributeSet set) {
                set.removeAttributes(set);
                EditorController c = EditorTextArea3.this.controller;
                try {
                    c.m_docSegList[c.displayedEntryIndex].createInputAttributes(element, set);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        });
        this.addMouseListener(this.mouseListener);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                try {
                    int start = EditorUtils.getWordStart(EditorTextArea3.this, e.getMark());
                    int end = EditorUtils.getWordEnd(EditorTextArea3.this, e.getMark());
                    if (end - start <= 0) {
                        return;
                    }
                    String newWord = EditorTextArea3.this.getText(start, end - start);
                    if (!newWord.equals(EditorTextArea3.this.currentWord)) {
                        EditorTextArea3.this.currentWord = newWord;
                        CoreEvents.fireEditorNewWord(newWord);
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.setToolTipText("");
    }

    public void cancelUndo() {
        this.undoManager.die();
    }

    public Document3 getOmDocument() {
        try {
            return (Document3)this.getDocument();
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerPopupMenuConstructors(int priority, IPopupMenuConstructor constructor) {
        List<PopupMenuConstructorInfo> list = this.popupConstructors;
        synchronized (list) {
            this.popupConstructors.add(new PopupMenuConstructorInfo(priority, constructor));
            Collections.sort(this.popupConstructors, new Comparator<PopupMenuConstructorInfo>(){

                @Override
                public int compare(PopupMenuConstructorInfo o1, PopupMenuConstructorInfo o2) {
                    return o1.priority - o2.priority;
                }
            });
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        int keyEvent = e.getID();
        if (keyEvent == 402) {
            this.reformatTranslation();
            super.processKeyEvent(e);
            return;
        }
        if (keyEvent == 400) {
            super.processKeyEvent(e);
            return;
        }
        boolean processed = false;
        boolean mac = StaticUtils.onMacOSX();
        Document3 doc = this.getOmDocument();
        if (EditorTextArea3.isKey(e, 9, 0)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                processed = true;
            }
        } else if (EditorTextArea3.isKey(e, 9, 1)) {
            if (this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                processed = true;
            }
        } else if (EditorTextArea3.isKey(e, 10, 0)) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.nextEntry();
                processed = true;
            } else {
                processed = true;
            }
        } else if (!mac && EditorTextArea3.isKey(e, 10, 2) || mac && EditorTextArea3.isKey(e, 10, 4)) {
            if (!this.controller.settings.isUseTabForAdvance()) {
                this.controller.prevEntry();
                processed = true;
            }
        } else if (EditorTextArea3.isKey(e, 10, 1)) {
            KeyEvent ke = new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), 0, 10, '\n');
            super.processKeyEvent(ke);
            processed = true;
        } else if (!mac && EditorTextArea3.isKey(e, 65, 2) || mac && EditorTextArea3.isKey(e, 65, 4)) {
            this.setSelectionStart(doc.getTranslationStart());
            this.setSelectionEnd(doc.getTranslationEnd());
            processed = true;
        } else if (EditorTextArea3.isKey(e, 79, 3)) {
            Cursor oldCursor = this.getCursor();
            this.setCursor(new Cursor(3));
            this.controller.toggleOrientation();
            this.setCursor(oldCursor);
            processed = true;
        } else if (!mac && EditorTextArea3.isKey(e, 8, 2) || mac && EditorTextArea3.isKey(e, 8, 8)) {
            try {
                int offset = this.getCaretPosition();
                int prevWord = Utilities.getPreviousWord(this, offset);
                int c = Math.max(prevWord, doc.getTranslationStart());
                this.setSelectionStart(c);
                this.setSelectionEnd(offset);
                this.replaceSelection("");
                processed = true;
            }
            catch (BadLocationException ex) {}
        } else if (!mac && EditorTextArea3.isKey(e, 127, 2) || mac && EditorTextArea3.isKey(e, 127, 8)) {
            try {
                int offset = this.getCaretPosition();
                int nextWord = Utilities.getNextWord(this, offset);
                int c = Math.min(nextWord, doc.getTranslationEnd());
                this.setSelectionStart(offset);
                this.setSelectionEnd(c);
                this.replaceSelection("");
                processed = true;
            }
            catch (BadLocationException ex) {}
        } else if (!mac && EditorTextArea3.isKey(e, 33, 2) || mac && EditorTextArea3.isKey(e, 33, 4)) {
            this.setCaretPosition(0);
            processed = true;
        } else if (!mac && EditorTextArea3.isKey(e, 34, 2) || mac && EditorTextArea3.isKey(e, 34, 4)) {
            this.setCaretPosition(this.getOmDocument().getLength());
            processed = true;
        }
        if (processed) {
            e.consume();
        } else {
            if ((e.getModifiers() & 0xE) == 0 && e.getKeyCode() != 16) {
                this.checkAndFixCaret();
            }
            super.processKeyEvent(e);
        }
        if (!processed && e.getKeyChar() != '\u0000') {
            switch (e.getKeyCode()) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    this.checkAndFixCaret();
                }
            }
        }
    }

    private void reformatTranslation() {
        Document3 doc = this.getOmDocument();
        String trans = doc.extractTranslation();
        if (trans != null && this.controller.currentOrientation == Document3.ORIENTATION.ALL_LTR) {
            this.getOmDocument().removeUndoableEditListener(this.undoManager);
            int start = doc.getTranslationStart();
            int end = doc.getTranslationEnd();
            int ae = this.controller.displayedEntryIndex;
            SegmentBuilder sb = this.controller.m_docSegList[ae];
            sb.formatText(trans, start, end, false);
            this.getOmDocument().addUndoableEditListener(this.undoManager);
        }
    }

    void checkAndFixCaret() {
        Document3 doc = this.getOmDocument();
        if (doc == null) {
            return;
        }
        if (!doc.isEditMode()) {
            return;
        }
        int spos = this.getSelectionStart();
        int epos = this.getSelectionEnd();
        int start = doc.getTranslationStart();
        int end = doc.getTranslationEnd();
        if (spos != epos) {
            if (spos < start) {
                this.fixSelectionStart(start);
            } else if (spos > end) {
                this.fixSelectionStart(end);
            }
            if (epos > end) {
                this.fixSelectionEnd(end);
            } else if (epos < start) {
                this.fixSelectionStart(start);
            }
        } else if (spos < start) {
            this.setCaretPosition(start);
        } else if (spos > end) {
            this.setCaretPosition(end);
        }
    }

    private void fixSelectionStart(int start) {
        if (this.getCaretPosition() <= start) {
            this.setCaretPosition(this.getSelectionEnd());
            this.moveCaretPosition(start);
        } else {
            this.setSelectionStart(start);
        }
    }

    private void fixSelectionEnd(int end) {
        this.setSelectionEnd(end);
    }

    private static boolean isKey(KeyEvent e, int code, int modifiers) {
        return e.getKeyCode() == code && e.getModifiers() == modifiers;
    }

    public void paste() {
        this.checkAndFixCaret();
        super.paste();
    }

    public void cut() {
        this.checkAndFixCaret();
        super.cut();
    }

    public String getSelectedText() {
        String st = super.getSelectedText();
        return st != null ? EditorUtils.removeDirectionChars(st) : null;
    }

    public String getToolTipText(MouseEvent event) {
        int pos = this.viewToModel(event.getPoint());
        int s = this.controller.getSegmentIndexAtLocation(pos);
        return this.controller.markerController.getToolTips(s, pos);
    }

    private static class PopupMenuConstructorInfo {
        final int priority;
        final IPopupMenuConstructor constructor;

        public PopupMenuConstructorInfo(int priority, IPopupMenuConstructor constructor) {
            this.priority = priority;
            this.constructor = constructor;
        }
    }
}

