/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableSelectionEvent;
import com.vlsolutions.swing.docking.event.DockableSelectionListener;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.core.events.IFontChangedEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.DocumentFilter3;
import org.omegat.gui.editor.EditorPopups;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.SegmentExportImport;
import org.omegat.gui.editor.SegmentHistory;
import org.omegat.gui.editor.ViewLabel;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.help.HelpFrame;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorController
implements IEditor {
    private static final Logger LOGGER = Logger.getLogger(EditorController.class.getName());
    private final DockableScrollPane pane;
    private boolean dockableSelected;
    protected final EditorTextArea3 editor;
    protected MarkerController markerController;
    private String introPaneTitle;
    private String emptyProjectPaneTitle;
    private JTextPane introPane;
    private JTextPane emptyProjectPane;
    protected final MainWindow mw;
    protected SegmentBuilder[] m_docSegList;
    protected int displayedFileIndex;
    protected int previousDisplayedFileIndex;
    protected int displayedEntryIndex;
    private SegmentHistory history = new SegmentHistory();
    protected final EditorSettings settings;
    protected Font font;
    protected Font fontb;
    protected Font fonti;
    protected Font fontbi;
    Document3.ORIENTATION currentOrientation;
    protected boolean sourceLangIsRTL;
    protected boolean targetLangIsRTL;
    private List<Integer> entryFilterList;
    private boolean emptyTranslation = false;
    private SegmentExportImport segmentExportImport;

    public EditorController(MainWindow mainWindow) {
        Container c;
        this.mw = mainWindow;
        this.segmentExportImport = new SegmentExportImport(this);
        this.editor = new EditorTextArea3(this);
        this.setFont(Core.getMainWindow().getApplicationFont());
        this.markerController = new MarkerController(this);
        this.pane = new DockableScrollPane("EDITOR", " ", this.editor, false);
        this.pane.setComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.pane.setHorizontalScrollBarPolicy(31);
        this.pane.setMinimumSize(new Dimension(100, 100));
        Core.getMainWindow().addDockable(this.pane);
        for (c = this.pane; c != null && !(c instanceof DockingDesktop); c = c.getParent()) {
        }
        DockingDesktop desktop = (DockingDesktop)c;
        desktop.addDockableSelectionListener(new DockableSelectionListener(){

            public void selectionChanged(DockableSelectionEvent dockableselectionevent) {
                EditorController.this.dockableSelected = EditorController.this.pane == dockableselectionevent.getSelectedDockable();
            }
        });
        this.settings = new EditorSettings(this);
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                SHOW_TYPE showType;
                switch (eventType) {
                    case CREATE: 
                    case LOAD: {
                        EditorController.this.history.clear();
                        EditorController.this.removeFilter();
                        showType = !Core.getProject().getAllEntries().isEmpty() ? SHOW_TYPE.FIRST_ENTRY : SHOW_TYPE.EMPTY_PROJECT;
                        EditorController.this.markerController.reset(0);
                        EditorController.this.setInitialOrientation();
                        break;
                    }
                    case CLOSE: {
                        EditorController.this.history.clear();
                        EditorController.this.removeFilter();
                        EditorController.this.markerController.reset(0);
                        showType = SHOW_TYPE.INTRO;
                        EditorController.this.deactivateWithoutCommit();
                        break;
                    }
                    default: {
                        showType = SHOW_TYPE.NO_CHANGE;
                    }
                }
                if (showType != SHOW_TYPE.NO_CHANGE) {
                    EditorController.this.updateState(showType);
                }
            }
        });
        CoreEvents.registerEntryEventListener(new IEntryEventListener(){

            public void onNewFile(String activeFileName) {
                EditorController.this.updateState(SHOW_TYPE.NO_CHANGE);
            }

            public void onEntryActivated(SourceTextEntry newEntry) {
            }
        });
        this.createAdditionalPanes();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditorController.this.updateState(SHOW_TYPE.INTRO);
                EditorController.this.pane.requestFocus();
            }
        });
        CoreEvents.registerFontChangedEventListener(new IFontChangedEventListener(){

            public void onFontChanged(Font newFont) {
                EditorController.this.setFont(newFont);
                ViewLabel.fontHeight = 0;
                EditorController.this.editor.revalidate();
                EditorController.this.editor.repaint();
                EditorController.this.emptyProjectPane.setFont(EditorController.this.font);
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.log(Level.SEVERE, "Uncatched exception in thread [" + t.getName() + "]", e);
            }
        });
        EditorPopups.init(this);
    }

    private void updateState(SHOW_TYPE showType) {
        UIThreadsUtil.mustBeSwingThread();
        JEditorPane data = null;
        String title = null;
        switch (showType) {
            case INTRO: {
                data = this.introPane;
                title = this.introPaneTitle;
                break;
            }
            case EMPTY_PROJECT: {
                data = this.emptyProjectPane;
                title = this.emptyProjectPaneTitle;
                break;
            }
            case FIRST_ENTRY: {
                this.displayedFileIndex = 0;
                this.displayedEntryIndex = 0;
                title = StaticUtils.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                data = this.editor;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorController.this.loadDocument();
                        EditorController.this.activateEntry();
                    }
                });
                break;
            }
            case NO_CHANGE: {
                title = StaticUtils.format(OStrings.getString("GUI_SUBWINDOWTITLE_Editor"), this.getCurrentFile());
                data = this.editor;
            }
        }
        this.pane.setName(title);
        if (this.pane.getViewport().getView() != data) {
            this.pane.setViewportView(data);
        }
    }

    private void setFont(Font font) {
        this.font = font;
        this.fontb = new Font(font.getFontName(), 1, font.getSize());
        this.fonti = new Font(font.getFontName(), 2, font.getSize());
        this.fontbi = new Font(font.getFontName(), 3, font.getSize());
        this.editor.setFont(font);
    }

    private void setInitialOrientation() {
        String sourceLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        String targetLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
        this.sourceLangIsRTL = EditorUtils.isRTL(sourceLang);
        this.targetLangIsRTL = EditorUtils.isRTL(targetLang);
        this.currentOrientation = this.sourceLangIsRTL != this.targetLangIsRTL || this.sourceLangIsRTL != EditorUtils.localeIsRTL() ? Document3.ORIENTATION.DIFFER : (this.sourceLangIsRTL ? Document3.ORIENTATION.ALL_RTL : Document3.ORIENTATION.ALL_LTR);
        this.applyOrientationToEditor();
    }

    private void applyOrientationToEditor() {
        ComponentOrientation targetOrientation = null;
        switch (this.currentOrientation) {
            case ALL_LTR: {
                targetOrientation = ComponentOrientation.LEFT_TO_RIGHT;
                break;
            }
            case ALL_RTL: {
                targetOrientation = ComponentOrientation.RIGHT_TO_LEFT;
                break;
            }
            case DIFFER: {
                targetOrientation = this.targetLangIsRTL ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
            }
        }
        this.editor.setComponentOrientation(targetOrientation);
    }

    protected void toggleOrientation() {
        this.commitAndDeactivate();
        Document3.ORIENTATION newOrientation = this.currentOrientation;
        switch (this.currentOrientation) {
            case ALL_LTR: {
                newOrientation = Document3.ORIENTATION.ALL_RTL;
                break;
            }
            case ALL_RTL: {
                if (this.sourceLangIsRTL != this.targetLangIsRTL || this.sourceLangIsRTL != EditorUtils.localeIsRTL()) {
                    newOrientation = Document3.ORIENTATION.DIFFER;
                    break;
                }
                newOrientation = Document3.ORIENTATION.ALL_LTR;
                break;
            }
            case DIFFER: {
                newOrientation = Document3.ORIENTATION.ALL_LTR;
            }
        }
        LOGGER.info("Switch document orientation from " + (Object)((Object)this.currentOrientation) + " to " + (Object)((Object)newOrientation));
        this.currentOrientation = newOrientation;
        this.applyOrientationToEditor();
        int activeSegment = this.displayedEntryIndex;
        this.loadDocument();
        this.displayedEntryIndex = activeSegment;
        this.activateEntry();
    }

    public Document3.ORIENTATION getOrientation() {
        return this.currentOrientation;
    }

    @Override
    public void requestFocus() {
        this.pane.getViewport().getView().requestFocusInWindow();
    }

    @Override
    public SourceTextEntry getCurrentEntry() {
        if (this.m_docSegList == null || this.displayedEntryIndex < 0 || this.m_docSegList.length <= this.displayedEntryIndex) {
            return null;
        }
        if (this.m_docSegList[this.displayedEntryIndex] == null) {
            return null;
        }
        return this.m_docSegList[this.displayedEntryIndex].ste;
    }

    @Override
    public String getCurrentFile() {
        if (Core.getProject().getProjectFiles().isEmpty()) {
            return null;
        }
        if (this.displayedFileIndex < Core.getProject().getProjectFiles().size()) {
            return Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).filePath;
        }
        return null;
    }

    protected void loadDocument() {
        IProject.FileInfo file;
        UIThreadsUtil.mustBeSwingThread();
        try {
            file = Core.getProject().getProjectFiles().get(this.displayedFileIndex);
        }
        catch (IndexOutOfBoundsException ex) {
            file = Core.getProject().getProjectFiles().get(0);
        }
        Document3 doc = new Document3(this);
        ArrayList<SegmentBuilder> temp_docSegList2 = new ArrayList<SegmentBuilder>(file.entries.size());
        for (int i = 0; i < file.entries.size(); ++i) {
            SourceTextEntry ste = file.entries.get(i);
            if (!this.isInFilter(new Integer(ste.entryNum()))) continue;
            SegmentBuilder sb = new SegmentBuilder(this, doc, this.settings, ste, ste.entryNum());
            temp_docSegList2.add(sb);
            sb.createSegmentElement(false);
            SegmentBuilder.addSegmentSeparator(doc);
        }
        this.m_docSegList = temp_docSegList2.toArray(new SegmentBuilder[temp_docSegList2.size()]);
        doc.setDocumentFilter(new DocumentFilter3());
        Locale targetLocale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        this.editor.setLocale(targetLocale);
        this.editor.setDocument(doc);
        doc.addUndoableEditListener(this.editor.undoManager);
        doc.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                EditorController.this.showLengthMessage();
                EditorController.this.onTextChanged();
            }
        });
        this.markerController.reset(this.m_docSegList.length);
        this.markerController.process(this.m_docSegList);
        this.editor.repaint();
    }

    @Override
    public void activateEntry() {
        this.activateEntry(-1);
    }

    @Override
    public void activateEntry(int preferredPosition) {
        UIThreadsUtil.mustBeSwingThread();
        SourceTextEntry ste = this.getCurrentEntry();
        if (ste == null) {
            return;
        }
        if (this.pane.getViewport().getView() != this.editor) {
            return;
        }
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        this.markerController.resetEntryMarks(this.displayedEntryIndex);
        this.m_docSegList[this.displayedEntryIndex].createSegmentElement(true);
        Core.getNotes().setNoteText(Core.getProject().getTranslationInfo((SourceTextEntry)ste).note);
        this.markerController.process(this.displayedEntryIndex, this.m_docSegList[this.displayedEntryIndex]);
        this.editor.cancelUndo();
        this.history.insertNew(this.m_docSegList[this.displayedEntryIndex].segmentNumberInProject);
        this.setMenuEnabled();
        this.showStat();
        this.showLengthMessage();
        if (Preferences.isPreference("wf_exportCurrentSegment")) {
            this.segmentExportImport.exportCurrentSegment(ste);
        }
        this.scrollForDisplayNearestSegments(this.editor.getOmDocument().getTranslationStart());
        int te = this.editor.getOmDocument().getTranslationEnd();
        int ts = this.editor.getOmDocument().getTranslationStart();
        int newPosition = preferredPosition == -1 ? ts : (preferredPosition == -2 ? te : (preferredPosition >= ts && preferredPosition <= te ? preferredPosition : ts));
        this.scrollForDisplayNearestSegments(newPosition);
        if (this.previousDisplayedFileIndex != this.displayedFileIndex) {
            this.previousDisplayedFileIndex = this.displayedFileIndex;
            CoreEvents.fireEntryNewFile(Core.getProject().getProjectFiles().get((int)this.displayedFileIndex).filePath);
        }
        this.editor.repaint();
        CoreEvents.fireEntryActivated(ste);
    }

    private void setMenuEnabled() {
        this.mw.menu.gotoHistoryBackMenuItem.setEnabled(this.history.hasPrev());
        this.mw.menu.gotoHistoryForwardMenuItem.setEnabled(this.history.hasNext());
        this.mw.menu.editMultipleDefault.setEnabled(!this.m_docSegList[this.displayedEntryIndex].isDefaultTranslation());
        this.mw.menu.editMultipleAlternate.setEnabled(this.m_docSegList[this.displayedEntryIndex].isDefaultTranslation());
    }

    void showLengthMessage() {
        Document3 doc = this.editor.getOmDocument();
        String trans = doc.extractTranslation();
        if (trans != null) {
            SourceTextEntry ste = this.m_docSegList[this.displayedEntryIndex].ste;
            String lMsg = " " + ste.getSrcText().length() + "/" + trans.length() + " ";
            Core.getMainWindow().showLengthMessage(lMsg);
        }
    }

    void onTextChanged() {
        Document3 doc = this.editor.getOmDocument();
        if (doc.isEditMode()) {
            this.m_docSegList[this.displayedEntryIndex].onActiveEntryChanged();
            this.markerController.process(this.displayedEntryIndex, this.m_docSegList[this.displayedEntryIndex]);
        }
    }

    private void scrollForDisplayNearestSegments(final int requiredPosition) {
        int lookNext;
        int lookPrev;
        try {
            SegmentBuilder prev = this.m_docSegList[this.displayedEntryIndex - 3];
            lookPrev = prev.getStartPosition();
        }
        catch (IndexOutOfBoundsException ex) {
            lookPrev = 0;
        }
        try {
            SegmentBuilder next = this.m_docSegList[this.displayedEntryIndex + 4];
            lookNext = next.getStartPosition() - 1;
        }
        catch (IndexOutOfBoundsException ex) {
            lookNext = this.editor.getOmDocument().getLength();
        }
        final int p = lookPrev;
        final int n = lookNext;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    EditorController.this.editor.setCaretPosition(n);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                EditorController.this.editor.setCaretPosition(p);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        try {
                                            EditorController.this.editor.setCaretPosition(requiredPosition);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            // empty catch block
                                        }
                                    }
                                });
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    private void showStat() {
        IProject project = Core.getProject();
        IProject.FileInfo fi = project.getProjectFiles().get(this.displayedFileIndex);
        int translatedInFile = 0;
        for (SourceTextEntry ste : fi.entries) {
            if (!project.getTranslationInfo(ste).isTranslated()) continue;
            ++translatedInFile;
        }
        StatisticsInfo stat = project.getStatistics();
        String pMsg = " " + Integer.toString(translatedInFile) + "/" + Integer.toString(fi.entries.size()) + " (" + Integer.toString(stat.numberofTranslatedSegments) + "/" + Integer.toString(stat.numberOfUniqueSegments) + ", " + Integer.toString(stat.numberOfSegmentsTotal) + ") ";
        Core.getMainWindow().showProgressMessage(pMsg);
    }

    protected void goToSegmentAtLocation(int location) {
        int segmentAtLocation = this.getSegmentIndexAtLocation(location);
        if (this.displayedEntryIndex != segmentAtLocation) {
            this.doChangeSegmentActions();
            this.displayedEntryIndex = segmentAtLocation;
            this.activateEntry();
        }
    }

    protected int getSegmentIndexAtLocation(int location) {
        int segmentAtLocation = this.m_docSegList.length - 1;
        for (int i = 0; i < this.m_docSegList.length; ++i) {
            if (location >= this.m_docSegList[i].getStartPosition()) continue;
            segmentAtLocation = i - 1;
            break;
        }
        return segmentAtLocation;
    }

    @Override
    public void commitAndDeactivate() {
        UIThreadsUtil.mustBeSwingThread();
        Document3 doc = this.editor.getOmDocument();
        if (doc == null) {
            return;
        }
        if (!doc.isEditMode()) {
            return;
        }
        this.markerController.resetEntryMarks(this.displayedEntryIndex);
        String newTrans = doc.extractTranslation();
        doc.stopEditMode();
        if (newTrans != null) {
            SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
            SourceTextEntry entry = sb.ste;
            TMXEntry oldTE = Core.getProject().getTranslationInfo(entry);
            if (StringUtil.isEmpty(oldTE.translation) && StringUtil.isEmpty(newTrans)) {
                this.setEmptyTranslation(true);
            }
            if (oldTE.translation == null && StringUtil.isEmpty(newTrans) || StringUtil.isEmpty(newTrans) && !this.isEmptyTransation()) {
                newTrans = null;
            }
            String note = Core.getNotes().getNoteText();
            if (entry.getSrcText().equals(newTrans) && !Preferences.isPreference("wf_allowTransEqualToSrc")) {
                newTrans = null;
            }
            Core.getProject().setTranslation(entry, newTrans, note, sb.isDefaultTranslation());
            this.m_docSegList[this.displayedEntryIndex].createSegmentElement(false);
            for (int i = 0; i < this.m_docSegList.length; ++i) {
                if (i == this.displayedEntryIndex || !this.m_docSegList[i].ste.getSrcText().equals(entry.getSrcText())) continue;
                this.m_docSegList[i].createSegmentElement(false);
            }
        }
        Core.getNotes().clear();
        this.markerController.process(this.displayedEntryIndex, this.m_docSegList[this.displayedEntryIndex]);
        this.editor.cancelUndo();
    }

    protected void deactivateWithoutCommit() {
        UIThreadsUtil.mustBeSwingThread();
        this.segmentExportImport.exportCurrentSegment(null);
        Document3 doc = this.editor.getOmDocument();
        if (doc == null) {
            return;
        }
        doc.stopEditMode();
    }

    @Override
    public void commitAndLeave() {
        int currentPosition = this.editor.getCaretPosition();
        this.commitAndDeactivate();
        this.activateEntry(currentPosition);
    }

    @Override
    public void nextEntry() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.doChangeSegmentActions();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        boolean looped = false;
        do {
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex < this.m_docSegList.length) continue;
            ++this.displayedFileIndex;
            this.displayedEntryIndex = 0;
            if (this.displayedFileIndex >= files.size()) {
                this.displayedFileIndex = 0;
                looped = true;
            }
            this.loadDocument();
        } while ((ste = this.getCurrentEntry()) == null && (!looped || this.displayedFileIndex != startFileIndex || this.displayedEntryIndex < startEntryIndex));
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void prevEntry() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.doChangeSegmentActions();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        boolean looped = false;
        do {
            --this.displayedEntryIndex;
            if (this.displayedEntryIndex >= 0) continue;
            --this.displayedFileIndex;
            if (this.displayedFileIndex < 0) {
                this.displayedFileIndex = files.size() - 1;
                looped = true;
            }
            this.loadDocument();
            this.displayedEntryIndex = this.m_docSegList.length - 1;
        } while ((ste = this.getCurrentEntry()) == null && (!looped || this.displayedFileIndex != startFileIndex || this.displayedEntryIndex > startEntryIndex));
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void nextUntranslatedEntry() {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.doChangeSegmentActions();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        while (true) {
            SourceTextEntry ste;
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex >= this.m_docSegList.length) {
                ++this.displayedFileIndex;
                this.displayedEntryIndex = 0;
                if (this.displayedFileIndex >= files.size()) {
                    this.displayedFileIndex = 0;
                }
                this.loadDocument();
            }
            if ((ste = this.getCurrentEntry()) == null || this.displayedFileIndex == startFileIndex && this.displayedEntryIndex == startEntryIndex || !Core.getProject().getTranslationInfo(ste).isTranslated()) break;
            if (!Preferences.isPreference("wf_stopOnAlternativeTranslation")) continue;
            HasMultipleTranslations checker = new HasMultipleTranslations(ste.getSrcText());
            Core.getProject().iterateByMultipleTranslations(checker);
            if (checker.found) break;
        }
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void nextEntryWithNote() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.doChangeSegmentActions();
        List<IProject.FileInfo> files = Core.getProject().getProjectFiles();
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        do {
            ++this.displayedEntryIndex;
            if (this.displayedEntryIndex < this.m_docSegList.length) continue;
            ++this.displayedFileIndex;
            this.displayedEntryIndex = 0;
            if (this.displayedFileIndex >= files.size()) {
                this.displayedFileIndex = 0;
            }
            this.loadDocument();
        } while ((ste = this.getCurrentEntry()) != null && (this.displayedFileIndex != startFileIndex || this.displayedEntryIndex != startEntryIndex) && !Core.getProject().getTranslationInfo(ste).hasNote());
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void prevEntryWithNote() {
        SourceTextEntry ste;
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.doChangeSegmentActions();
        int startFileIndex = this.displayedFileIndex;
        int startEntryIndex = this.displayedEntryIndex;
        do {
            --this.displayedEntryIndex;
            if (this.displayedEntryIndex >= 0) continue;
            --this.displayedFileIndex;
            if (this.displayedFileIndex < 0) {
                this.displayedFileIndex = 0;
            }
            this.loadDocument();
            this.displayedEntryIndex = this.m_docSegList.length - 1;
        } while ((ste = this.getCurrentEntry()) != null && (this.displayedFileIndex != startFileIndex || this.displayedEntryIndex != startEntryIndex) && !Core.getProject().getTranslationInfo(ste).hasNote());
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public int getCurrentEntryNumber() {
        SourceTextEntry e = this.getCurrentEntry();
        return e != null ? e.entryNum() : 0;
    }

    @Override
    public void gotoFile(int fileIndex) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (this.m_docSegList == null) {
            return;
        }
        this.doChangeSegmentActions();
        this.displayedFileIndex = fileIndex;
        this.displayedEntryIndex = 0;
        this.loadDocument();
        this.activateEntry();
    }

    @Override
    public void gotoEntry(int entryNum) {
        UIThreadsUtil.mustBeSwingThread();
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        if (this.m_docSegList == null) {
            return;
        }
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.editor.getCursor();
        this.editor.setCursor(hourglassCursor);
        this.doChangeSegmentActions();
        if (entryNum == 0) {
            this.displayedFileIndex = 0;
            this.displayedEntryIndex = 0;
            this.loadDocument();
        } else {
            IProject dataEngine = Core.getProject();
            block0: for (int i = 0; i < dataEngine.getProjectFiles().size(); ++i) {
                IProject.FileInfo fi = dataEngine.getProjectFiles().get(i);
                SourceTextEntry firstEntry = fi.entries.get(0);
                SourceTextEntry lastEntry = fi.entries.get(fi.entries.size() - 1);
                if (firstEntry.entryNum() > entryNum || lastEntry.entryNum() < entryNum) continue;
                if (i != this.displayedFileIndex) {
                    this.displayedFileIndex = i;
                    this.loadDocument();
                }
                for (int j = 0; j < this.m_docSegList.length; ++j) {
                    if (this.m_docSegList[j].segmentNumberInProject < entryNum) continue;
                    this.displayedEntryIndex = j;
                    break block0;
                }
                break;
            }
        }
        this.activateEntry();
        this.editor.setCursor(oldCursor);
    }

    @Override
    public void changeCase(IEditor.CHANGE_CASE_TO toWhat) {
        UIThreadsUtil.mustBeSwingThread();
        int start = this.editor.getSelectionStart();
        int end = this.editor.getSelectionEnd();
        int caretPosition = this.editor.getCaretPosition();
        int translationStart = this.editor.getOmDocument().getTranslationStart();
        int translationEnd = this.editor.getOmDocument().getTranslationEnd();
        if (end < translationStart || start > translationEnd) {
            return;
        }
        if (start < translationStart && end <= translationEnd) {
            start = translationStart;
        }
        if (end > translationEnd && start >= translationStart) {
            end = translationEnd;
        }
        try {
            if (start == end) {
                start = EditorUtils.getWordStart(this.editor, start);
                end = EditorUtils.getWordEnd(this.editor, end);
                if (start < translationStart && end <= translationEnd) {
                    start = translationStart;
                }
                if (end > translationEnd && start >= translationStart) {
                    end = translationEnd;
                }
            }
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(end);
            String selectionText = this.editor.getText(start, end - start);
            Token[] tokenList = Core.getProject().getTargetTokenizer().tokenizeWordsForSpelling(selectionText);
            StringBuffer buffer = new StringBuffer(selectionText);
            if (toWhat == IEditor.CHANGE_CASE_TO.CYCLE) {
                int lower = 0;
                int upper = 0;
                int title = 0;
                int other = 0;
                for (Token token : tokenList) {
                    String word = token.getTextFromString(selectionText);
                    if (StringUtil.isLowerCase(word)) {
                        ++lower;
                        continue;
                    }
                    if (StringUtil.isTitleCase(word)) {
                        ++title;
                        continue;
                    }
                    if (StringUtil.isUpperCase(word)) {
                        ++upper;
                        continue;
                    }
                    ++other;
                }
                if (lower == 0 && title == 0 && upper == 0 && other == 0) {
                    return;
                }
                if (lower != 0 && title == 0 && upper == 0) {
                    toWhat = IEditor.CHANGE_CASE_TO.TITLE;
                }
                if (lower == 0 && title != 0 && upper == 0) {
                    toWhat = IEditor.CHANGE_CASE_TO.UPPER;
                }
                if (lower == 0 && title == 0 && upper != 0) {
                    toWhat = IEditor.CHANGE_CASE_TO.LOWER;
                }
                if (other != 0) {
                    toWhat = IEditor.CHANGE_CASE_TO.UPPER;
                }
            }
            int lengthIncrement = 0;
            for (Token token : tokenList) {
                String result = this.doChangeCase(token.getTextFromString(selectionText), toWhat);
                buffer.replace(token.getOffset() + lengthIncrement, token.getLength() + token.getOffset() + lengthIncrement, result);
                lengthIncrement += result.length() - token.getLength();
            }
            this.editor.replaceSelection(buffer.toString());
            this.editor.setCaretPosition(caretPosition);
            this.editor.setSelectionStart(start);
            this.editor.setSelectionEnd(end);
        }
        catch (BadLocationException ble) {
            Log.log("bad location exception when changing case");
            Log.log(ble);
        }
    }

    private String doChangeCase(String input, IEditor.CHANGE_CASE_TO toWhat) {
        Locale locale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        switch (toWhat) {
            case LOWER: {
                return input.toLowerCase(locale);
            }
            case UPPER: {
                return input.toUpperCase(locale);
            }
            case TITLE: {
                return Character.toTitleCase(input.charAt(0)) + input.substring(1).toLowerCase(locale);
            }
        }
        return input.toUpperCase(locale);
    }

    @Override
    public void replaceEditText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        int start = this.editor.getOmDocument().getTranslationStart();
        int end = this.editor.getOmDocument().getTranslationEnd();
        this.editor.select(start, end);
        this.editor.replaceSelection(text);
    }

    @Override
    public void insertText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        this.editor.checkAndFixCaret();
        this.editor.replaceSelection(text);
    }

    @Override
    public void gotoHistoryBack() {
        UIThreadsUtil.mustBeSwingThread();
        int prevValue = this.history.back();
        if (prevValue != -1) {
            this.gotoEntry(prevValue);
        }
    }

    @Override
    public void gotoHistoryForward() {
        UIThreadsUtil.mustBeSwingThread();
        int nextValue = this.history.forward();
        if (nextValue != -1) {
            this.gotoEntry(nextValue);
        }
    }

    @Override
    public EditorSettings getSettings() {
        return this.settings;
    }

    @Override
    public void undo() {
        UIThreadsUtil.mustBeSwingThread();
        try {
            if (this.editor.undoManager.canUndo()) {
                this.editor.undoManager.undo();
            }
        }
        catch (CannotUndoException cue) {
            Log.log(cue);
        }
    }

    @Override
    public void redo() {
        UIThreadsUtil.mustBeSwingThread();
        try {
            if (this.editor.undoManager.canRedo()) {
                this.editor.undoManager.redo();
            }
        }
        catch (CannotRedoException cue) {
            Log.log(cue);
        }
    }

    @Override
    public String getSelectedText() {
        UIThreadsUtil.mustBeSwingThread();
        return this.dockableSelected ? this.editor.getSelectedText() : null;
    }

    private void createAdditionalPanes() {
        this.introPaneTitle = OStrings.getString("DOCKING_INSTANT_START_TITLE");
        try {
            String language = this.detectInstantStartLanguage();
            this.introPane = new JTextPane();
            this.introPane.setComponentOrientation(EditorUtils.isRTL(language) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
            this.introPane.setEditable(false);
            this.introPane.setPage(HelpFrame.getHelpFileURL(language, "instantStartGuideNoTOC.html"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.emptyProjectPaneTitle = OStrings.getString("TF_INTRO_EMPTYPROJECT_FILENAME");
        this.emptyProjectPane = new JTextPane();
        this.emptyProjectPane.setEditable(false);
        this.emptyProjectPane.setText(OStrings.getString("TF_INTRO_EMPTYPROJECT"));
        this.emptyProjectPane.setFont(Core.getMainWindow().getApplicationFont());
    }

    private String detectInstantStartLanguage() {
        String language = Locale.getDefault().getLanguage().toLowerCase(Locale.ENGLISH);
        String country = Locale.getDefault().getCountry().toUpperCase(Locale.ENGLISH);
        if (HelpFrame.getHelpFileURL(language + "_" + country, "instantStartGuideNoTOC.html") != null) {
            return language + "_" + country;
        }
        if (HelpFrame.getHelpFileURL(language, "instantStartGuideNoTOC.html") != null) {
            return language;
        }
        return "en";
    }

    @Override
    public void remarkOneMarker(String markerClassName) {
        int mi = this.markerController.getMarkerIndex(markerClassName);
        this.markerController.process(this.m_docSegList, mi);
    }

    @Override
    public void markActiveEntrySource(SourceTextEntry requiredActiveEntry, List<Mark> marks, String markerClassName) {
        UIThreadsUtil.mustBeSwingThread();
        for (Mark m : marks) {
            if (m.entryPart == Mark.ENTRY_PART.SOURCE) continue;
            throw new RuntimeException("Mark must be for source only");
        }
        SourceTextEntry realActive = this.m_docSegList[this.displayedEntryIndex].ste;
        if (realActive != requiredActiveEntry) {
            return;
        }
        int mi = this.markerController.getMarkerIndex(markerClassName);
        this.markerController.setEntryMarks(this.displayedEntryIndex, this.m_docSegList[this.displayedEntryIndex], marks, mi);
    }

    @Override
    public void registerPopupMenuConstructors(int priority, IPopupMenuConstructor constructor) {
        this.editor.registerPopupMenuConstructors(priority, constructor);
    }

    @Override
    public void addFilter(List<Integer> entryList) {
        this.entryFilterList = entryList;
        int curEntryNum = this.getCurrentEntryNumber();
        Document3 doc = this.editor.getOmDocument();
        IProject project = Core.getProject();
        if (doc != null && project != null && project.getProjectFiles() != null) {
            this.loadDocument();
            if (this.isInFilter(curEntryNum)) {
                this.gotoEntry(curEntryNum);
            } else {
                for (int j = 0; j < this.m_docSegList.length; ++j) {
                    if (this.m_docSegList[j].segmentNumberInProject < curEntryNum) continue;
                    this.displayedEntryIndex = j - 1;
                    break;
                }
                this.nextEntry();
            }
        }
    }

    @Override
    public void removeFilter() {
        List<IProject.FileInfo> files;
        this.entryFilterList = null;
        int curEntryNum = this.getCurrentEntryNumber();
        Document3 doc = this.editor.getOmDocument();
        IProject project = Core.getProject();
        if (doc != null && project != null && (files = project.getProjectFiles()) != null && !files.isEmpty()) {
            this.loadDocument();
            this.gotoEntry(curEntryNum);
        }
    }

    public boolean isInFilter(Integer entry) {
        if (this.entryFilterList == null) {
            return true;
        }
        return this.entryFilterList.contains(entry);
    }

    @Override
    public void setAlternateTranslationForCurrentEntry(boolean alternate) {
        SegmentBuilder sb = this.m_docSegList[this.displayedEntryIndex];
        if (!alternate) {
            SourceTextEntry ste = sb.getSourceTextEntry();
            Core.getProject().setTranslation(ste, null, null, false);
            sb.setDefaultTranslation(true);
        } else {
            sb.setDefaultTranslation(false);
        }
        this.setMenuEnabled();
    }

    @Override
    public void setEmptyTranslation(boolean flag) {
        this.emptyTranslation = flag;
    }

    private boolean isEmptyTransation() {
        return this.emptyTranslation;
    }

    private void doChangeSegmentActions() {
        this.commitAndDeactivate();
        this.setEmptyTranslation(false);
    }

    protected static class HasMultipleTranslations
    implements IProject.MultipleTranslationsIterator {
        final String sourceEntryText;
        IProject project;
        boolean found;

        public HasMultipleTranslations(String sourceEntryText) {
            this.sourceEntryText = sourceEntryText;
            this.project = Core.getProject();
        }

        public void iterate(EntryKey source, TMXEntry trans) {
            if (this.found) {
                return;
            }
            if (this.sourceEntryText.equals(source.sourceText)) {
                this.found = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SHOW_TYPE {
        INTRO,
        EMPTY_PROJECT,
        FIRST_ENTRY,
        NO_CHANGE;

    }
}

