/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class WorkflowOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JCheckBox allowTranslationEqualToSource;
    private JButton cancelButton;
    private JCheckBox convertNumbers;
    private JRadioButton defaultRadio;
    private JTextArea descriptionTextArea;
    private JCheckBox exportCurrentSegment;
    private JCheckBox insertFuzzyCheckBox;
    private JRadioButton leaveEmptyRadio;
    private JButton okButton;
    private ButtonGroup ourButtonGroup;
    private JLabel prefixLabel;
    private JTextField prefixText;
    private JLabel similarityLabel;
    private JSpinner similaritySpinner;
    private JCheckBox stopOnAlternativeTranslation;
    private int returnStatus = 0;

    public WorkflowOptionsDialog(Frame parent) {
        super(parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                WorkflowOptionsDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.leaveEmptyRadio.setSelected(Preferences.isPreference("wf_noSourceText"));
        this.insertFuzzyCheckBox.setSelected(Preferences.isPreference("wf_insertBestMatch"));
        this.similarityLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.similaritySpinner.setValue(new Integer(Preferences.getPreferenceDefault("wf_minimalSimilarity", "80")));
        this.similaritySpinner.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        if (!Preferences.existsPreference("wf_explanatoryText")) {
            this.prefixText.setText(OStrings.getString("WF_DEFAULT_PREFIX"));
        } else {
            this.prefixText.setText(Preferences.getPreferenceDefaultAllowEmptyString("wf_explanatoryText"));
        }
        this.prefixText.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.allowTranslationEqualToSource.setSelected(Preferences.isPreference("wf_allowTransEqualToSrc"));
        this.exportCurrentSegment.setSelected(Preferences.isPreference("wf_exportCurrentSegment"));
        this.stopOnAlternativeTranslation.setSelected(Preferences.isPreference("wf_stopOnAlternativeTranslation"));
        this.convertNumbers.setSelected(Preferences.isPreference("wf_convertNumbers"));
        this.invalidate();
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.ourButtonGroup = new ButtonGroup();
        this.similarityLabel = new JLabel();
        this.similaritySpinner = new JSpinner();
        this.descriptionTextArea = new JTextArea();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.convertNumbers = new JCheckBox();
        this.allowTranslationEqualToSource = new JCheckBox();
        this.defaultRadio = new JRadioButton();
        this.leaveEmptyRadio = new JRadioButton();
        this.prefixLabel = new JLabel();
        this.prefixText = new JTextField();
        this.insertFuzzyCheckBox = new JCheckBox();
        this.exportCurrentSegment = new JCheckBox();
        this.stopOnAlternativeTranslation = new JCheckBox();
        this.setTitle(OStrings.getString("GUI_TITLE_Workflow_Options"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                WorkflowOptionsDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.similarityLabel.setLabelFor(this.similaritySpinner);
        Mnemonics.setLocalizedText(this.similarityLabel, OStrings.getString("GUI_WORKFLOW_OPTION_Minimal_Similarity"));
        this.similarityLabel.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.getContentPane().add((Component)this.similarityLabel, gridBagConstraints);
        this.similaritySpinner.setEnabled(false);
        this.similaritySpinner.setValue(new Integer(90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.similaritySpinner, gridBagConstraints);
        this.descriptionTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(new JLabel().getFont());
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(OStrings.getString("GUI_WORKFLOW_DESCRIPTION"));
        this.descriptionTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.descriptionTextArea, gridBagConstraints);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.convertNumbers, OStrings.getString("WF_OPTION_CONVERT_NUMBERS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.convertNumbers, gridBagConstraints);
        Mnemonics.setLocalizedText(this.allowTranslationEqualToSource, OStrings.getString("WF_OPTION_ALLOW_TRANS_EQ_TO_SRC"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.allowTranslationEqualToSource, gridBagConstraints);
        this.ourButtonGroup.add(this.defaultRadio);
        this.defaultRadio.setSelected(true);
        Mnemonics.setLocalizedText(this.defaultRadio, OStrings.getString("WF_OPTION_INSERT_SOURCE"));
        this.defaultRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultRadio.setMargin(new Insets(0, 0, 0, 0));
        this.defaultRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.radiosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.defaultRadio, gridBagConstraints);
        this.ourButtonGroup.add(this.leaveEmptyRadio);
        Mnemonics.setLocalizedText(this.leaveEmptyRadio, OStrings.getString("WF_OPTION_INSERT_NOTHTHING"));
        this.leaveEmptyRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.leaveEmptyRadio.setMargin(new Insets(0, 0, 0, 0));
        this.leaveEmptyRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.radiosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.leaveEmptyRadio, gridBagConstraints);
        this.prefixLabel.setLabelFor(this.prefixText);
        Mnemonics.setLocalizedText(this.prefixLabel, OStrings.getString("WF_OPTION_INSERT_FUZZY_PREFIX"));
        this.prefixLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.getContentPane().add((Component)this.prefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.prefixText, gridBagConstraints);
        Mnemonics.setLocalizedText(this.insertFuzzyCheckBox, OStrings.getString("WF_OPTION_INSERT_FUZZY_MATCH"));
        this.insertFuzzyCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WorkflowOptionsDialog.this.radiosActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 4);
        this.getContentPane().add((Component)this.insertFuzzyCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText(this.exportCurrentSegment, OStrings.getString("WF_OPTION_EXPORT__CURRENT_SEGMENT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.exportCurrentSegment, gridBagConstraints);
        Mnemonics.setLocalizedText(this.stopOnAlternativeTranslation, OStrings.getString("WF_OPTION_GOTO_NEXT_UNTRANSLATED"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.stopOnAlternativeTranslation, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void radiosActionPerformed(ActionEvent evt) {
        this.similarityLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.similaritySpinner.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixLabel.setEnabled(this.insertFuzzyCheckBox.isSelected());
        this.prefixText.setEnabled(this.insertFuzzyCheckBox.isSelected());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("wf_noSourceText", this.leaveEmptyRadio.isSelected());
        Preferences.setPreference("wf_insertBestMatch", this.insertFuzzyCheckBox.isSelected());
        if (this.insertFuzzyCheckBox.isSelected()) {
            Preferences.setPreference("wf_minimalSimilarity", this.similaritySpinner.getValue().toString());
            Preferences.setPreference("wf_explanatoryText", this.prefixText.getText());
        }
        Preferences.setPreference("wf_allowTransEqualToSrc", this.allowTranslationEqualToSource.isSelected());
        Preferences.setPreference("wf_exportCurrentSegment", this.exportCurrentSegment.isSelected());
        Preferences.setPreference("wf_stopOnAlternativeTranslation", this.stopOnAlternativeTranslation.isSelected());
        Preferences.setPreference("wf_convertNumbers", this.convertNumbers.isSelected());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

