/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.gui.dialogs.DictionaryInstallerDialog;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class SpellcheckerConfigurationDialog
extends JDialog {
    private final JFileChooser fileChooser = new JFileChooser();
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private Language currentLanguage;
    private DictionaryManager dicMan;
    private DefaultListModel languageListModel;
    private JCheckBox autoSpellcheckCheckBox;
    private JButton cancelButton;
    private JLabel contentLabel;
    private JPanel detailPanel;
    private JLabel dictionaryUrlLabel;
    private JTextField dictionaryUrlTextField;
    private JButton directoryChooserButton;
    private JLabel directoryLabel;
    private JTextField directoryTextField;
    private JButton installButton;
    private JPanel jPanel2;
    private JList languageList;
    private JScrollPane languageScrollPane;
    private JButton okButton;
    private JButton uninstallButton;

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public SpellcheckerConfigurationDialog(Frame parent, Language current) {
        super(parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SpellcheckerConfigurationDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.pack();
        this.currentLanguage = current;
        this.languageListModel = new DefaultListModel();
        this.autoSpellcheckCheckBox.setSelected(Preferences.isPreference("allow_auto_spellchecking"));
        this.updateDetailPanel();
        this.directoryTextField.setText(Preferences.getPreference("spellcheker_dir"));
        this.updateLanguageList();
        String dictionaryUrl = Preferences.getPreference("dictionary_url");
        if ("".equalsIgnoreCase(dictionaryUrl) || "http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries/".equalsIgnoreCase(dictionaryUrl)) {
            this.dictionaryUrlTextField.setText("http://download.services.openoffice.org/files/contrib/dictionaries/");
        } else {
            this.dictionaryUrlTextField.setText(Preferences.getPreference("dictionary_url"));
        }
    }

    public void updateLanguageList() {
        String dirName = this.directoryTextField.getText();
        if (dirName == null || dirName.equals("")) {
            return;
        }
        this.dicMan = new DictionaryManager(dirName);
        List<String> aList = this.dicMan.getLocalDictionaryNameList();
        Collections.sort(aList);
        this.languageListModel.clear();
        for (String str : aList) {
            this.languageListModel.addElement(str);
        }
        this.languageList.setModel(this.languageListModel);
    }

    private void updateDetailPanel() {
        boolean enabled = this.autoSpellcheckCheckBox.isSelected();
        this.detailPanel.setEnabled(enabled);
        this.contentLabel.setEnabled(enabled);
        this.directoryChooserButton.setEnabled(enabled);
        this.directoryLabel.setEnabled(enabled);
        this.directoryTextField.setEnabled(enabled);
        this.installButton.setEnabled(enabled);
        this.setUninstalButtonStatus();
        this.languageScrollPane.setEnabled(enabled);
        this.languageList.setEnabled(enabled);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.autoSpellcheckCheckBox = new JCheckBox();
        this.detailPanel = new JPanel();
        this.directoryTextField = new JTextField();
        this.languageScrollPane = new JScrollPane();
        this.languageList = new JList();
        this.contentLabel = new JLabel();
        this.directoryLabel = new JLabel();
        this.directoryChooserButton = new JButton();
        this.dictionaryUrlLabel = new JLabel();
        this.dictionaryUrlTextField = new JTextField();
        this.installButton = new JButton();
        this.uninstallButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("GUI_SPELLCHECKER_TITLE"));
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(420, Short.MAX_VALUE).add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.okButton)));
        Mnemonics.setLocalizedText(this.autoSpellcheckCheckBox, OStrings.getString("GUI_SPELLCHECKER_AUTOSPELLCHECKCHECKBOX"));
        this.autoSpellcheckCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoSpellcheckCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.autoSpellcheckCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.autoSpellcheckCheckBoxActionPerformed(evt);
            }
        });
        this.detailPanel.setBorder(BorderFactory.createEtchedBorder());
        this.directoryTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.directoryTextFieldActionPerformed(evt);
            }
        });
        this.languageList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SpellcheckerConfigurationDialog.this.languageListMouseClicked(evt);
            }
        });
        this.languageScrollPane.setViewportView(this.languageList);
        Mnemonics.setLocalizedText(this.contentLabel, OStrings.getString("GUI_SPELLCHECKER_AVAILABLE_LABEL"));
        Mnemonics.setLocalizedText(this.directoryLabel, OStrings.getString("GUI_SPELLCHECKER_DICTIONARYLABEL"));
        Mnemonics.setLocalizedText(this.directoryChooserButton, OStrings.getString("GUI_SPELLCHECKER_DIRECTORYCHOOSERBUTTON"));
        this.directoryChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.directoryChooserButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.dictionaryUrlLabel, OStrings.getString("GUI_SPELLCHECKER_URL_LABEL"));
        Mnemonics.setLocalizedText(this.installButton, OStrings.getString("GUI_SPELLCHECKER_INSTALLBUTTON"));
        this.installButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.installButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.uninstallButton, OStrings.getString("GUI_SPELLCHECKER_UNINSTALLBUTTON"));
        this.uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.uninstallButtonActionPerformed(evt);
            }
        });
        GroupLayout detailPanelLayout = new GroupLayout((Container)this.detailPanel);
        this.detailPanel.setLayout((LayoutManager)detailPanelLayout);
        detailPanelLayout.setHorizontalGroup((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add((GroupLayout.Group)detailPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add((GroupLayout.Group)detailPanelLayout.createSequentialGroup().add((Component)this.dictionaryUrlTextField, -1, 514, Short.MAX_VALUE).addContainerGap()).add((Component)this.dictionaryUrlLabel).add((GroupLayout.Group)detailPanelLayout.createSequentialGroup().add((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add((Component)this.contentLabel).add((Component)this.directoryLabel).add((GroupLayout.Group)detailPanelLayout.createSequentialGroup().add((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add((Component)this.languageScrollPane, -1, 415, Short.MAX_VALUE).add(2, (Component)this.directoryTextField, -1, 415, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)detailPanelLayout.createParallelGroup(1, false).add((Component)this.uninstallButton, -1, -1, Short.MAX_VALUE).add((Component)this.directoryChooserButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, -1, Short.MAX_VALUE))).addContainerGap()).add((GroupLayout.Group)detailPanelLayout.createSequentialGroup().add((Component)this.installButton, -1, -1, Short.MAX_VALUE).add(377, 377, 377)))));
        detailPanelLayout.setVerticalGroup((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)detailPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.directoryLabel).addPreferredGap(0).add((GroupLayout.Group)detailPanelLayout.createParallelGroup(3).add((Component)this.directoryChooserButton).add((Component)this.directoryTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.contentLabel).addPreferredGap(0).add((GroupLayout.Group)detailPanelLayout.createParallelGroup(1).add((GroupLayout.Group)detailPanelLayout.createSequentialGroup().add((Component)this.languageScrollPane, -1, 123, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.dictionaryUrlLabel)).add((Component)this.uninstallButton)).addPreferredGap(0).add((Component)this.dictionaryUrlTextField, -2, -1, -2).add(9, 9, 9).add((Component)this.installButton)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.autoSpellcheckCheckBox).add((Component)this.detailPanel, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.autoSpellcheckCheckBox).addPreferredGap(0).add((Component)this.detailPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void languageListMouseClicked(MouseEvent evt) {
        this.setUninstalButtonStatus();
    }

    private void setUninstalButtonStatus() {
        Object[] selection = this.languageList.getSelectedValues();
        this.uninstallButton.setEnabled(selection.length > 0 && this.autoSpellcheckCheckBox.isSelected());
    }

    private void directoryTextFieldActionPerformed(ActionEvent evt) {
        this.updateLanguageList();
    }

    private void directoryChooserButtonActionPerformed(ActionEvent evt) {
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle(OStrings.getString("GUI_SPELLCHECKER_FILE_CHOOSER_TITLE"));
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.directoryTextField.setText(file.getAbsolutePath());
        }
        this.updateLanguageList();
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        if (this.dicMan == null) {
            JOptionPane.showMessageDialog(this, OStrings.getString("GUI_SPELLCHECKER_INSTALL_UNABLE"), OStrings.getString("GUI_SPELLCHECKER_INSTALL_UNABLE_TITLE"), 0);
            return;
        }
        Preferences.setPreference("dictionary_url", this.dictionaryUrlTextField.getText());
        Cursor hourglassCursor = new Cursor(3);
        Cursor oldCursor = this.getCursor();
        this.setCursor(hourglassCursor);
        try {
            DictionaryInstallerDialog installerDialog = new DictionaryInstallerDialog(this, this.dicMan);
            this.setCursor(oldCursor);
            installerDialog.setVisible(true);
            this.updateLanguageList();
        }
        catch (IOException ex) {
            this.setCursor(oldCursor);
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
        }
        this.setUninstalButtonStatus();
    }

    private void uninstallButtonActionPerformed(ActionEvent evt) {
        if (this.dicMan == null) {
            return;
        }
        if (this.currentLanguage != null) {
            Object[] selection = this.languageList.getSelectedValues();
            for (int i = 0; i < selection.length; ++i) {
                String selectedItem = (String)selection[i];
                String selectedLocaleName = selectedItem.substring(0, selectedItem.indexOf(" "));
                if (selectedLocaleName.equals(this.currentLanguage.getLocaleCode()) && JOptionPane.showConfirmDialog(this, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT_TITLE"), 0) == 1) {
                    return;
                }
                if (!this.dicMan.uninstallDictionary(selectedLocaleName)) {
                    JOptionPane.showMessageDialog(this, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE_TITLE"), 0);
                }
                this.languageListModel.remove(this.languageList.getSelectedIndex());
            }
            this.setUninstalButtonStatus();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("allow_auto_spellchecking", this.autoSpellcheckCheckBox.isSelected());
        Preferences.setPreference("spellcheker_dir", this.directoryTextField.getText());
        Preferences.setPreference("dictionary_url", this.dictionaryUrlTextField.getText());
        this.doClose(1);
    }

    private void autoSpellcheckCheckBoxActionPerformed(ActionEvent evt) {
        this.updateDetailPanel();
    }
}

