/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

public class SaveOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JCheckBox allowProjectCmdCheckBox;
    private JButton cancelButton;
    private JTextArea externalCmdDescriptionTextArea;
    private JLabel externalCommandLabel;
    private JScrollPane externalCommandScrollPane;
    private JTextArea externalCommandTextArea;
    private JButton insertButton;
    private JTextArea intervalDescriptionTextArea;
    private JLabel minutesLabel;
    private JSpinner minutesSpinner;
    private JButton okButton;
    private JLabel secondsLabel;
    private JSpinner secondsSpinner;
    private JLabel variablesLabel;
    private JComboBox variablesList;
    private int returnStatus = 0;

    public SaveOptionsDialog(Frame parent) {
        super(parent, true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SaveOptionsDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        int saveInterval = new Integer(Preferences.getPreferenceDefault("auto_save_interval", "180"));
        this.minutesSpinner.setValue(saveInterval / 60);
        this.secondsSpinner.setValue(saveInterval % 60);
        this.externalCommandTextArea.setText(Preferences.getPreference("external_command"));
        this.allowProjectCmdCheckBox.setSelected(Preferences.isPreference("allow_project_extern_cmd"));
        this.invalidate();
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.minutesLabel = new JLabel();
        this.minutesSpinner = new JSpinner();
        this.secondsLabel = new JLabel();
        this.secondsSpinner = new JSpinner();
        this.intervalDescriptionTextArea = new JTextArea();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.externalCmdDescriptionTextArea = new JTextArea();
        this.externalCommandScrollPane = new JScrollPane();
        this.externalCommandTextArea = new JTextArea();
        this.allowProjectCmdCheckBox = new JCheckBox();
        this.variablesLabel = new JLabel();
        this.variablesList = new JComboBox();
        this.insertButton = new JButton();
        this.externalCommandLabel = new JLabel();
        this.setTitle(OStrings.getString("SAVE_DIALOG_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SaveOptionsDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.minutesLabel.setLabelFor(this.minutesSpinner);
        Mnemonics.setLocalizedText(this.minutesLabel, OStrings.getString("SAVE_DIALOG_MINUTES"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.getContentPane().add((Component)this.minutesLabel, gridBagConstraints);
        this.minutesSpinner.setValue(new Integer(90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.minutesSpinner, gridBagConstraints);
        this.secondsLabel.setLabelFor(this.secondsSpinner);
        Mnemonics.setLocalizedText(this.secondsLabel, OStrings.getString("SAVE_DIALOG_SECONDS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 16, 4, 4);
        this.getContentPane().add((Component)this.secondsLabel, gridBagConstraints);
        this.secondsSpinner.setValue(new Integer(90));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.secondsSpinner, gridBagConstraints);
        this.intervalDescriptionTextArea.setEditable(false);
        this.intervalDescriptionTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.intervalDescriptionTextArea.setFont(new JLabel().getFont());
        this.intervalDescriptionTextArea.setLineWrap(true);
        this.intervalDescriptionTextArea.setText(OStrings.getString("SAVE_DIALOG_DESCRIPTION"));
        this.intervalDescriptionTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.intervalDescriptionTextArea, gridBagConstraints);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SaveOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SaveOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.externalCmdDescriptionTextArea.setEditable(false);
        this.externalCmdDescriptionTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.externalCmdDescriptionTextArea.setFont(new JLabel().getFont());
        this.externalCmdDescriptionTextArea.setLineWrap(true);
        this.externalCmdDescriptionTextArea.setText(OStrings.getString("EXTERNAL_COMMAND_DESCRIPTION"));
        this.externalCmdDescriptionTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.getContentPane().add((Component)this.externalCmdDescriptionTextArea, gridBagConstraints);
        this.externalCommandTextArea.setColumns(20);
        this.externalCommandTextArea.setLineWrap(true);
        this.externalCommandTextArea.setRows(5);
        this.externalCommandScrollPane.setViewportView(this.externalCommandTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.externalCommandScrollPane, gridBagConstraints);
        this.allowProjectCmdCheckBox.setFont(new JLabel().getFont());
        Mnemonics.setLocalizedText(this.allowProjectCmdCheckBox, OStrings.getString("ALLOW_PROJECT_EXTERN_CMD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 4, 4);
        this.getContentPane().add((Component)this.allowProjectCmdCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText(this.variablesLabel, OStrings.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.variablesLabel, gridBagConstraints);
        this.variablesList.setModel(new DefaultComboBoxModel<String>(CommandVarExpansion.COMMAND_VARIABLES));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.variablesList, gridBagConstraints);
        Mnemonics.setLocalizedText(this.insertButton, OStrings.getString("BUTTON_INSERT"));
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SaveOptionsDialog.this.insertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.insertButton, gridBagConstraints);
        this.externalCommandLabel.setLabelFor(this.externalCommandTextArea);
        Mnemonics.setLocalizedText(this.externalCommandLabel, OStrings.getString("EXTERNAL_COMMAND_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 4);
        this.getContentPane().add((Component)this.externalCommandLabel, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.externalCommandTextArea.insert(this.variablesList.getSelectedItem().toString(), this.externalCommandTextArea.getCaretPosition());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int saveMinutes = 0;
        int saveSeconds = 0;
        try {
            saveMinutes = Integer.parseInt(this.minutesSpinner.getValue().toString());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            saveSeconds = Integer.parseInt(this.secondsSpinner.getValue().toString());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int saveInterval = saveMinutes * 60 + saveSeconds;
        if (saveInterval < 10) {
            saveInterval = 10;
        }
        Preferences.setPreference("auto_save_interval", saveInterval);
        Preferences.setPreference("external_command", this.externalCommandTextArea.getText());
        Preferences.setPreference("allow_project_extern_cmd", this.allowProjectCmdCheckBox.isSelected());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

