/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import gen.core.filters.Filters;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.omegat.core.Core;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.segmentation.SRX;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.filters2.FiltersCustomizer;
import org.omegat.gui.segmentation.SegmentationCustomizer;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.LanguageComboBoxRenderer;
import org.omegat.util.gui.OmegaTFileChooser;
import org.openide.awt.Mnemonics;

public class ProjectPropertiesDialog
extends JDialog {
    private ProjectProperties projectProperties;
    public static final int NEW_PROJECT = 1;
    public static final int RESOLVE_DIRS = 2;
    public static final int EDIT_PROJECT = 3;
    private int dialogType;
    private SRX srx;
    private Filters filters;
    private boolean m_dialogCancelled;

    public ProjectPropertiesDialog(ProjectProperties projectProperties, String projFileName, int dialogTypeValue) {
        super((Frame)Core.getMainWindow().getApplicationFrame(), true);
        this.projectProperties = projectProperties;
        this.srx = projectProperties.getProjectSRX();
        this.dialogType = dialogTypeValue;
        this.filters = FilterMaster.loadConfig(projectProperties.getProjectInternal());
        EmptyBorder emptyBorder = new EmptyBorder(2, 0, 2, 0);
        Box centerBox = Box.createVerticalBox();
        centerBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTextArea m_messageArea = new JTextArea();
        m_messageArea.setEditable(false);
        m_messageArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        m_messageArea.setFont(new Label().getFont());
        Box bMes = Box.createHorizontalBox();
        bMes.setBorder(emptyBorder);
        bMes.add(m_messageArea);
        bMes.add(Box.createHorizontalGlue());
        centerBox.add(bMes);
        Box localesBox = Box.createVerticalBox();
        localesBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OStrings.getString("PP_LANGUAGES")));
        JLabel m_sourceLocaleLabel = new JLabel();
        Mnemonics.setLocalizedText(m_sourceLocaleLabel, OStrings.getString("PP_SRC_LANG"));
        Box bSL = Box.createHorizontalBox();
        bSL.setBorder(emptyBorder);
        bSL.add(m_sourceLocaleLabel);
        bSL.add(Box.createHorizontalGlue());
        localesBox.add(bSL);
        final JComboBox<Language> m_sourceLocaleField = new JComboBox<Language>(Language.LANGUAGES);
        if (m_sourceLocaleField.getMaximumRowCount() < 20) {
            m_sourceLocaleField.setMaximumRowCount(20);
        }
        m_sourceLocaleField.setEditable(true);
        m_sourceLocaleField.setRenderer(new LanguageComboBoxRenderer());
        m_sourceLocaleField.setSelectedItem(projectProperties.getSourceLanguage());
        localesBox.add(m_sourceLocaleField);
        JLabel m_targetLocaleLabel = new JLabel();
        Mnemonics.setLocalizedText(m_targetLocaleLabel, OStrings.getString("PP_LOC_LANG"));
        Box bLL = Box.createHorizontalBox();
        bLL.setBorder(emptyBorder);
        bLL.add(m_targetLocaleLabel);
        bLL.add(Box.createHorizontalGlue());
        localesBox.add(bLL);
        final JComboBox<Language> m_targetLocaleField = new JComboBox<Language>(Language.LANGUAGES);
        if (m_targetLocaleField.getMaximumRowCount() < 20) {
            m_targetLocaleField.setMaximumRowCount(20);
        }
        m_targetLocaleField.setEditable(true);
        m_targetLocaleField.setRenderer(new LanguageComboBoxRenderer());
        m_targetLocaleField.setSelectedItem(projectProperties.getTargetLanguage());
        localesBox.add(m_targetLocaleField);
        centerBox.add(localesBox);
        centerBox.add(Box.createVerticalStrut(5));
        Box optionsBox = Box.createVerticalBox();
        optionsBox.setBorder(new EtchedBorder());
        optionsBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OStrings.getString("PP_OPTIONS")));
        final JCheckBox m_sentenceSegmentingCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText(m_sentenceSegmentingCheckBox, OStrings.getString("PP_SENTENCE_SEGMENTING"));
        JButton m_sentenceSegmentingButton = new JButton();
        Mnemonics.setLocalizedText(m_sentenceSegmentingButton, OStrings.getString("MW_OPTIONSMENU_SENTSEG"));
        Box bSent = Box.createHorizontalBox();
        bSent.add(m_sentenceSegmentingCheckBox);
        bSent.add(Box.createHorizontalGlue());
        bSent.add(m_sentenceSegmentingButton);
        optionsBox.add(bSent);
        JButton m_fileFiltersButton = new JButton();
        Mnemonics.setLocalizedText(m_fileFiltersButton, OStrings.getString("WM_PROJECTMENU_FILEFILTERS"));
        Box bFF = Box.createHorizontalBox();
        bFF.add(Box.createHorizontalGlue());
        bFF.add(m_fileFiltersButton);
        optionsBox.add(bFF);
        final JCheckBox m_allowDefaultsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText(m_allowDefaultsCheckBox, OStrings.getString("PP_ALLOW_DEFAULTS"));
        Box bMT = Box.createHorizontalBox();
        bMT.setBorder(emptyBorder);
        bMT.add(m_allowDefaultsCheckBox);
        bMT.add(Box.createHorizontalGlue());
        optionsBox.add(bMT);
        final JCheckBox m_removeTagsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText(m_removeTagsCheckBox, OStrings.getString("PP_REMOVE_TAGS"));
        Box bRT = Box.createHorizontalBox();
        bRT.setBorder(emptyBorder);
        bRT.add(m_removeTagsCheckBox);
        bRT.add(Box.createHorizontalGlue());
        optionsBox.add(bRT);
        JLabel m_externalCommandLabel = new JLabel();
        Box bEC = Box.createHorizontalBox();
        bEC.setBorder(emptyBorder);
        bEC.add(m_externalCommandLabel);
        bEC.add(Box.createHorizontalGlue());
        optionsBox.add(bEC);
        final JTextArea m_externalCommandTextArea = new JTextArea();
        m_externalCommandTextArea.setRows(2);
        m_externalCommandTextArea.setLineWrap(true);
        m_externalCommandTextArea.setText(projectProperties.getExternalCommand());
        if (Preferences.isPreference("allow_project_extern_cmd")) {
            Mnemonics.setLocalizedText(m_externalCommandLabel, OStrings.getString("PP_EXTERNAL_COMMAND"));
        } else {
            Mnemonics.setLocalizedText(m_externalCommandLabel, OStrings.getString("PP_EXTERN_CMD_DISABLED"));
            m_externalCommandTextArea.setEditable(false);
            m_externalCommandTextArea.setToolTipText(OStrings.getString("PP_EXTERN_CMD_DISABLED_TOOLTIP"));
            m_externalCommandTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
        }
        JScrollPane m_externalCommandScrollPane = new JScrollPane();
        m_externalCommandScrollPane.setViewportView(m_externalCommandTextArea);
        optionsBox.add(m_externalCommandScrollPane);
        if (Preferences.isPreference("allow_project_extern_cmd")) {
            Box bIC = Box.createHorizontalBox();
            bIC.setBorder(emptyBorder);
            JLabel m_variablesLabel = new JLabel();
            Mnemonics.setLocalizedText(m_variablesLabel, OStrings.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
            bIC.add(m_variablesLabel);
            final JComboBox<String> m_variablesList = new JComboBox<String>(CommandVarExpansion.COMMAND_VARIABLES);
            bIC.add(m_variablesList);
            JButton m_insertButton = new JButton();
            Mnemonics.setLocalizedText(m_insertButton, OStrings.getString("BUTTON_INSERT"));
            m_insertButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectPropertiesDialog.this.insertButtonActionPerformed(m_externalCommandTextArea, m_variablesList);
                }
            });
            bIC.add(m_insertButton);
            bIC.add(Box.createHorizontalGlue());
            optionsBox.add(bIC);
        }
        centerBox.add((Component)optionsBox, "West");
        centerBox.add(Box.createVerticalStrut(5));
        Box dirsBox = Box.createVerticalBox();
        dirsBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OStrings.getString("PP_DIRECTORIES")));
        JLabel m_srcRootLabel = new JLabel();
        Mnemonics.setLocalizedText(m_srcRootLabel, OStrings.getString("PP_SRC_ROOT"));
        Box bSrc = Box.createHorizontalBox();
        bSrc.setBorder(emptyBorder);
        bSrc.add(m_srcRootLabel);
        bSrc.add(Box.createHorizontalGlue());
        JButton m_srcBrowse = new JButton();
        Mnemonics.setLocalizedText(m_srcBrowse, OStrings.getString("PP_BUTTON_BROWSE_SRC"));
        bSrc.add(m_srcBrowse);
        final JTextField m_srcRootField = new JTextField();
        dirsBox.add(bSrc);
        dirsBox.add(m_srcRootField);
        JLabel m_tmRootLabel = new JLabel();
        Mnemonics.setLocalizedText(m_tmRootLabel, OStrings.getString("PP_TM_ROOT"));
        Box bTM = Box.createHorizontalBox();
        bTM.setBorder(emptyBorder);
        bTM.add(m_tmRootLabel);
        bTM.add(Box.createHorizontalGlue());
        JButton m_tmBrowse = new JButton();
        Mnemonics.setLocalizedText(m_tmBrowse, OStrings.getString("PP_BUTTON_BROWSE_TM"));
        bTM.add(m_tmBrowse);
        final JTextField m_tmRootField = new JTextField();
        dirsBox.add(bTM);
        dirsBox.add(m_tmRootField);
        JLabel m_glosRootLabel = new JLabel();
        Mnemonics.setLocalizedText(m_glosRootLabel, OStrings.getString("PP_GLOS_ROOT"));
        Box bGlos = Box.createHorizontalBox();
        bGlos.setBorder(emptyBorder);
        bGlos.add(m_glosRootLabel);
        bGlos.add(Box.createHorizontalGlue());
        JButton m_glosBrowse = new JButton();
        Mnemonics.setLocalizedText(m_glosBrowse, OStrings.getString("PP_BUTTON_BROWSE_GL"));
        bGlos.add(m_glosBrowse);
        final JTextField m_glosRootField = new JTextField();
        dirsBox.add(bGlos);
        dirsBox.add(m_glosRootField);
        JLabel m_writeableGlosLabel = new JLabel();
        Mnemonics.setLocalizedText(m_writeableGlosLabel, OStrings.getString("PP_WRITEABLE_GLOS"));
        Box bwGlos = Box.createHorizontalBox();
        bwGlos.setBorder(emptyBorder);
        bwGlos.add(m_writeableGlosLabel);
        bwGlos.add(Box.createHorizontalGlue());
        JButton m_wGlosBrowse = new JButton();
        Mnemonics.setLocalizedText(m_wGlosBrowse, OStrings.getString("PP_BUTTON_BROWSE_WG"));
        bwGlos.add(m_wGlosBrowse);
        final JTextField m_writeableGlosField = new JTextField();
        dirsBox.add(bwGlos);
        dirsBox.add(m_writeableGlosField);
        JLabel m_locDictLabel = new JLabel();
        Mnemonics.setLocalizedText(m_locDictLabel, OStrings.getString("PP_DICT_ROOT"));
        Box bDict = Box.createHorizontalBox();
        bDict.setBorder(emptyBorder);
        bDict.add(m_locDictLabel);
        bDict.add(Box.createHorizontalGlue());
        JButton m_dictBrowse = new JButton();
        Mnemonics.setLocalizedText(m_dictBrowse, OStrings.getString("PP_BUTTON_BROWSE_DICT"));
        bDict.add(m_dictBrowse);
        final JTextField m_dictRootField = new JTextField();
        dirsBox.add(bDict);
        dirsBox.add(m_dictRootField);
        JLabel m_locRootLabel = new JLabel();
        Mnemonics.setLocalizedText(m_locRootLabel, OStrings.getString("PP_LOC_ROOT"));
        Box bLoc = Box.createHorizontalBox();
        bLoc.setBorder(emptyBorder);
        bLoc.add(m_locRootLabel);
        bLoc.add(Box.createHorizontalGlue());
        JButton m_locBrowse = new JButton();
        Mnemonics.setLocalizedText(m_locBrowse, OStrings.getString("PP_BUTTON_BROWSE_TAR"));
        bLoc.add(m_locBrowse);
        final JTextField m_locRootField = new JTextField();
        dirsBox.add(bLoc);
        dirsBox.add(m_locRootField);
        centerBox.add(dirsBox);
        JScrollPane scrollPane = new JScrollPane(centerBox);
        this.getContentPane().add((Component)scrollPane, "Center");
        JButton m_okButton = new JButton();
        Mnemonics.setLocalizedText(m_okButton, OStrings.getString("BUTTON_OK"));
        JButton m_cancelButton = new JButton();
        Mnemonics.setLocalizedText(m_cancelButton, OStrings.getString("BUTTON_CANCEL"));
        Box southBox = Box.createHorizontalBox();
        southBox.setBorder(new EmptyBorder(5, 5, 5, 5));
        southBox.add(Box.createHorizontalGlue());
        southBox.add(m_okButton);
        southBox.add(Box.createHorizontalStrut(5));
        southBox.add(m_cancelButton);
        this.getContentPane().add((Component)southBox, "South");
        this.setResizable(false);
        m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doOK(m_sourceLocaleField, m_targetLocaleField, m_sentenceSegmentingCheckBox, m_srcRootField, m_locRootField, m_glosRootField, m_writeableGlosField, m_tmRootField, m_dictRootField, m_allowDefaultsCheckBox, m_removeTagsCheckBox, m_externalCommandTextArea);
            }
        });
        m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doCancel();
            }
        });
        m_srcBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(1, m_srcRootField);
            }
        });
        m_locBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(2, m_locRootField);
            }
        });
        m_glosBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(3, m_glosRootField);
            }
        });
        m_wGlosBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(6, m_writeableGlosField);
            }
        });
        m_tmBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(4, m_tmRootField);
            }
        });
        m_dictBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doBrowseDirectoy(5, m_dictRootField);
            }
        });
        final ProjectPropertiesDialog self = this;
        m_sentenceSegmentingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SegmentationCustomizer segmentationCustomizer = new SegmentationCustomizer(self, true, SRX.getDefault(), Preferences.getSRX(), ProjectPropertiesDialog.this.srx);
                segmentationCustomizer.setVisible(true);
                if (segmentationCustomizer.getReturnStatus() == 1) {
                    ProjectPropertiesDialog.this.srx = segmentationCustomizer.getSRX();
                }
            }
        });
        m_fileFiltersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame mainWindow = Core.getMainWindow().getApplicationFrame();
                FiltersCustomizer dlg = new FiltersCustomizer(mainWindow, true, FilterMaster.createDefaultFiltersConfig(), FilterMaster.loadConfig(StaticUtils.getConfigDir()), ProjectPropertiesDialog.this.filters);
                dlg.setVisible(true);
                if (dlg.getReturnStatus() == 1) {
                    ProjectPropertiesDialog.this.filters = dlg.result;
                }
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ProjectPropertiesDialog.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        m_srcRootField.setText(projectProperties.getSourceRoot());
        m_locRootField.setText(projectProperties.getTargetRoot());
        m_glosRootField.setText(projectProperties.getGlossaryRoot());
        m_writeableGlosField.setText(projectProperties.getWriteableGlossary());
        m_tmRootField.setText(projectProperties.getTMRoot());
        m_dictRootField.setText(projectProperties.getDictRoot());
        m_sourceLocaleField.setSelectedItem(projectProperties.getSourceLanguage());
        m_targetLocaleField.setSelectedItem(projectProperties.getTargetLanguage());
        m_sentenceSegmentingCheckBox.setSelected(projectProperties.isSentenceSegmentingEnabled());
        m_allowDefaultsCheckBox.setSelected(projectProperties.isSupportDefaultTranslations());
        m_removeTagsCheckBox.setSelected(projectProperties.isRemoveTags());
        switch (this.dialogType) {
            case 2: {
                String wGlos;
                m_sourceLocaleField.setEnabled(false);
                m_targetLocaleField.setEnabled(false);
                m_sentenceSegmentingCheckBox.setEnabled(false);
                File f = new File(m_srcRootField.getText());
                if (!f.exists() || !f.isDirectory()) {
                    m_srcRootField.setForeground(Color.RED);
                }
                if (!(f = new File(m_locRootField.getText())).exists() || !f.isDirectory()) {
                    m_locRootField.setForeground(Color.RED);
                }
                if (!(f = new File(m_glosRootField.getText())).exists() || !f.isDirectory()) {
                    m_glosRootField.setForeground(Color.RED);
                }
                if (!(wGlos = (f = new File(m_writeableGlosField.getText())).getParent()).endsWith(File.separator)) {
                    wGlos = wGlos + File.separator;
                }
                if (!((f = new File(wGlos)).exists() && f.isDirectory() && wGlos.contains(m_glosRootField.getText()))) {
                    m_writeableGlosField.setForeground(Color.RED);
                }
                if ((f = new File(m_tmRootField.getText())).exists() && f.isDirectory()) break;
                m_tmRootField.setForeground(Color.RED);
            }
        }
        this.updateUIText(m_messageArea);
        this.pack();
        this.setSize(9 * this.getWidth() / 8, this.getHeight() + 10);
        this.setResizable(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void doBrowseDirectoy(int browseTarget, JTextField field) {
        int action;
        File dir;
        String title;
        boolean fileMode = false;
        boolean glossaryFile = false;
        if (browseTarget == 6) {
            fileMode = true;
            glossaryFile = true;
        }
        switch (browseTarget) {
            case 1: {
                title = OStrings.getString("PP_BROWSE_TITLE_SOURCE");
                break;
            }
            case 2: {
                title = OStrings.getString("PP_BROWSE_TITLE_TARGET");
                break;
            }
            case 3: {
                title = OStrings.getString("PP_BROWSE_TITLE_GLOS");
                break;
            }
            case 4: {
                title = OStrings.getString("PP_BROWSE_TITLE_TM");
                break;
            }
            case 5: {
                title = OStrings.getString("PP_BROWSE_TITLE_DICT");
                break;
            }
            case 6: {
                title = OStrings.getString("PP_BROWSE_W_GLOS");
                break;
            }
            default: {
                return;
            }
        }
        OmegaTFileChooser browser = new OmegaTFileChooser();
        browser.setDialogTitle(title);
        if (fileMode) {
            browser.setFileSelectionMode(0);
        } else {
            browser.setFileSelectionMode(1);
        }
        String curDir = field != null ? field.getText() : "";
        File curDirCheck = new File(curDir);
        if (fileMode && !StringUtil.isEmpty(curDirCheck.getName())) {
            String dirOnly = curDirCheck.getParent();
            dirOnly = dirOnly != null ? dirOnly : "";
            curDirCheck = new File(dirOnly);
        }
        if (!curDirCheck.exists() || !curDirCheck.isDirectory()) {
            curDir = this.projectProperties.getProjectRoot();
            curDirCheck = new File(curDir);
        }
        if (!curDirCheck.exists() || !curDirCheck.isDirectory()) {
            switch (browseTarget) {
                case 1: {
                    curDir = Preferences.getPreference("source_folder");
                    break;
                }
                case 2: {
                    curDir = Preferences.getPreference("target_folder");
                    break;
                }
                case 3: {
                    curDir = Preferences.getPreference("glossary_folder");
                    break;
                }
                case 4: {
                    curDir = Preferences.getPreference("tm_folder");
                    break;
                }
                case 5: {
                    curDir = Preferences.getPreference("dict_folder");
                    break;
                }
                case 6: {
                    curDir = Preferences.getPreference("glossary_file");
                }
            }
        }
        if (fileMode) {
            File dirFile = new File(curDir);
            curDir = dirFile.getParent();
        }
        if (curDir.equals("")) {
            curDir = Preferences.getPreference("current_folder");
        }
        if (!curDir.equals("") && (dir = new File(curDir)).exists() && dir.isDirectory()) {
            browser.setCurrentDirectory(dir);
        }
        if ((action = browser.showOpenDialog(this)) != 0) {
            return;
        }
        File dir2 = browser.getSelectedFile();
        if (dir2 == null) {
            return;
        }
        String str = dir2.getAbsolutePath();
        if (!fileMode) {
            str = str + File.separator;
        }
        if (glossaryFile && !str.endsWith(".txt") && !str.endsWith(".utf8")) {
            str = str + ".txt";
        }
        switch (browseTarget) {
            case 1: {
                Preferences.setPreference("source_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setSourceRoot(str);
                field.setText(this.projectProperties.getSourceRoot());
                if (!new File(this.projectProperties.getSourceRoot()).exists() || !new File(this.projectProperties.getSourceRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 2: {
                Preferences.setPreference("target_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setTargetRoot(str);
                field.setText(this.projectProperties.getTargetRoot());
                if (!new File(this.projectProperties.getTargetRoot()).exists() || !new File(this.projectProperties.getTargetRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 3: {
                Preferences.setPreference("glossary_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setGlossaryRoot(str);
                field.setText(this.projectProperties.getGlossaryRoot());
                if (!new File(this.projectProperties.getGlossaryRoot()).exists() || !new File(this.projectProperties.getGlossaryRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 4: {
                Preferences.setPreference("tm_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setTMRoot(str);
                field.setText(this.projectProperties.getTMRoot());
                if (!new File(this.projectProperties.getTMRoot()).exists() || !new File(this.projectProperties.getTMRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 5: {
                Preferences.setPreference("dict_folder", browser.getSelectedFile().getParent());
                this.projectProperties.setDictRoot(str);
                field.setText(this.projectProperties.getDictRoot());
                if (!new File(this.projectProperties.getDictRoot()).exists() || !new File(this.projectProperties.getDictRoot()).isDirectory()) break;
                field.setForeground(SystemColor.textText);
                break;
            }
            case 6: {
                Preferences.setPreference("glossary_file", browser.getSelectedFile().getPath());
                this.projectProperties.setWriteableGlossary(str);
                field.setText(this.projectProperties.getWriteableGlossary());
                if (!new File(this.projectProperties.getWriteableGlossaryDir()).exists() || !new File(this.projectProperties.getWriteableGlossaryDir()).isDirectory() || !this.projectProperties.getWriteableGlossaryDir().contains(this.projectProperties.getGlossaryRoot())) break;
                field.setForeground(SystemColor.textText);
            }
        }
    }

    private void doOK(JComboBox m_sourceLocaleField, JComboBox m_targetLocaleField, JCheckBox m_sentenceSegmentingCheckBox, JTextField m_srcRootField, JTextField m_locRootField, JTextField m_glosRootField, JTextField m_writeableGlosField, JTextField m_tmRootField, JTextField m_dictRootField, JCheckBox m_allowDefaultsCheckBox, JCheckBox m_removeTagsCheckBox, JTextArea m_customCommandTextArea) {
        if (!ProjectProperties.verifySingleLangCode(m_sourceLocaleField.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_INVALID_SOURCE_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
            m_sourceLocaleField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setSourceLanguage(m_sourceLocaleField.getSelectedItem().toString());
        if (!ProjectProperties.verifySingleLangCode(m_targetLocaleField.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_INVALID_TARGET_LOCALE") + OStrings.getString("NP_LOCALE_SUGGESTION"), OStrings.getString("TF_ERROR"), 0);
            m_targetLocaleField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTargetLanguage(m_targetLocaleField.getSelectedItem().toString());
        this.projectProperties.setSentenceSegmentingEnabled(m_sentenceSegmentingCheckBox.isSelected());
        this.projectProperties.setSupportDefaultTranslations(m_allowDefaultsCheckBox.isSelected());
        this.projectProperties.setRemoveTags(m_removeTagsCheckBox.isSelected());
        this.projectProperties.setExternalCommand(m_customCommandTextArea.getText());
        this.projectProperties.setSourceRoot(m_srcRootField.getText());
        if (!this.projectProperties.getSourceRoot().endsWith(File.separator)) {
            this.projectProperties.setSourceRoot(this.projectProperties.getSourceRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getSourceRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_SOURCEDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            m_srcRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTargetRoot(m_locRootField.getText());
        if (!this.projectProperties.getTargetRoot().endsWith(File.separator)) {
            this.projectProperties.setTargetRoot(this.projectProperties.getTargetRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getTargetRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_TRANSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            m_locRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setGlossaryRoot(m_glosRootField.getText());
        if (!this.projectProperties.getGlossaryRoot().endsWith(File.separator)) {
            this.projectProperties.setGlossaryRoot(this.projectProperties.getGlossaryRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getGlossaryRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_GLOSSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            m_glosRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setWriteableGlossary(m_writeableGlosField.getText());
        if (this.dialogType != 1 && !new File(this.projectProperties.getWriteableGlossaryDir()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_W_GLOSSDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            m_writeableGlosField.requestFocusInWindow();
            return;
        }
        String glossaryDir = this.projectProperties.getWriteableGlossaryDir();
        if (!glossaryDir.endsWith(File.separator)) {
            glossaryDir = glossaryDir + File.separator;
        }
        if (!glossaryDir.contains(this.projectProperties.getGlossaryRoot())) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_W_GLOSDIR_NOT_INSIDE_GLOS"), OStrings.getString("TF_ERROR"), 0);
            m_writeableGlosField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setTMRoot(m_tmRootField.getText());
        if (!this.projectProperties.getTMRoot().endsWith(File.separator)) {
            this.projectProperties.setTMRoot(this.projectProperties.getTMRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getTMRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_TMDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            m_tmRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setDictRoot(m_dictRootField.getText());
        if (!this.projectProperties.getDictRoot().endsWith(File.separator)) {
            this.projectProperties.setDictRoot(this.projectProperties.getDictRoot() + File.separator);
        }
        if (this.dialogType != 1 && !new File(this.projectProperties.getDictRoot()).exists()) {
            JOptionPane.showMessageDialog(this, OStrings.getString("NP_DICTDIR_DOESNT_EXIST"), OStrings.getString("TF_ERROR"), 0);
            m_dictRootField.requestFocusInWindow();
            return;
        }
        this.projectProperties.setProjectSRX(this.srx);
        this.projectProperties.setProjectFilters(this.filters);
        this.m_dialogCancelled = false;
        this.setVisible(false);
    }

    private void doCancel() {
        if (this.dialogType == 1) {
            new File(this.projectProperties.getProjectRoot()).delete();
        }
        this.m_dialogCancelled = true;
        this.setVisible(false);
    }

    private void insertButtonActionPerformed(JTextArea area, JComboBox box) {
        area.insert(box.getSelectedItem().toString(), area.getCaretPosition());
    }

    private void updateUIText(JTextArea m_messageArea) {
        switch (this.dialogType) {
            case 1: {
                this.setTitle(OStrings.getString("PP_CREATE_PROJ"));
                m_messageArea.setText(OStrings.getString("PP_MESSAGE_CONFIGPROJ"));
                break;
            }
            case 2: {
                this.setTitle(OStrings.getString("PP_OPEN_PROJ"));
                m_messageArea.setText(OStrings.getString("PP_MESSAGE_BADPROJ"));
                break;
            }
            case 3: {
                this.setTitle(OStrings.getString("PP_EDIT_PROJECT"));
                m_messageArea.setText(OStrings.getString("PP_MESSAGE_EDITPROJ"));
            }
        }
    }

    public ProjectProperties getResult() {
        return this.m_dialogCancelled ? null : this.projectProperties;
    }
}

