/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.comments;

import java.awt.Dimension;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IEntryEventListener;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.OStrings;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentsTextArea
extends EntryInfoPane<SourceTextEntry>
implements IEntryEventListener {
    private static final String EXPLANATION = OStrings.getString("GUI_COMMENTSWINDOW_explanation");

    public CommentsTextArea(MainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_COMMENTSWINDOW_SUBWINDOWTITLE_Comments");
        mw.addDockable(new DockableScrollPane("COMMENTS", title, this, true));
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        CoreEvents.registerEntryEventListener(this);
    }

    @Override
    public void onEntryActivated(SourceTextEntry newEntry) {
        UIThreadsUtil.mustBeSwingThread();
        StringBuilder text = new StringBuilder(1024);
        if (newEntry.getKey().id != null) {
            text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_ID"));
            text.append(' ');
            text.append(newEntry.getKey().id);
            text.append('\n');
        }
        if (newEntry.getKey().path != null) {
            text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_Path"));
            text.append(' ');
            text.append(newEntry.getKey().path);
            text.append('\n');
        }
        if (newEntry.getSourceTranslation() != null) {
            text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_Translation"));
            text.append(' ');
            text.append(newEntry.getSourceTranslation());
            text.append('\n');
        }
        if (newEntry.getComment() != null) {
            text.append(OStrings.getString("GUI_COMMENTSWINDOW_FIELD_Comment"));
            text.append('\n');
            text.append(newEntry.getComment());
            text.append('\n');
        }
        this.setText(text.toString());
        this.setCaretPosition(0);
    }

    @Override
    public void onNewFile(String activeFileName) {
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
    }

    public void clear() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText("");
    }
}

