/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.helpandmanual;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.omegat.filters3.Attribute;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.xml.DefaultXMLDialect;

public class HelpAndManualDialect
extends DefaultXMLDialect {
    public static final Pattern HAM_ROOT_TAG = Pattern.compile("topic|map|helpproject");
    private HashMap<String, String> ignoreTagsAttributes;

    public HelpAndManualDialect() {
        this.defineConstraint(CONSTRAINT_ROOT, HAM_ROOT_TAG);
        this.defineParagraphTags(new String[]{"caption", "config-value", "variable", "para", "title", "keyword", "li"});
        this.defineShortcut("link", "li");
        this.ignoreTagsAttributes = new HashMap();
        this.ignoreTagsAttributes.put("TRANSLATE=FALSE", "");
    }

    private boolean checkIgnoreTags(String key, String value) {
        return this.ignoreTagsAttributes.containsKey(key.toUpperCase() + "=" + value.toUpperCase());
    }

    public Boolean validateIntactTag(String tag, Attributes atts) {
        if (atts != null) {
            for (int i = 0; i < atts.size(); ++i) {
                Attribute oneAttribute = atts.get(i);
                if (!this.checkIgnoreTags(oneAttribute.getName(), oneAttribute.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

