/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Matcher;
import org.omegat.util.Log;
import org.omegat.util.PatternConsts;

public class XMLWriter
extends Writer {
    private StringWriter writer;
    private BufferedWriter realWriter;
    private String XML_HEADER;
    private final int minHeaderedBufferSize = 4096;
    private final int maxBufferSize = 65536;
    private boolean signalClosing = false;
    private boolean signalAlreadyFlushed = false;

    public XMLWriter(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        this.XML_HEADER = encoding == null ? "<?xml version=\"1.0\"?>" : "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
        this.writer = new StringWriter();
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = encoding == null ? new OutputStreamWriter((OutputStream)fos, "UTF-8") : new OutputStreamWriter((OutputStream)fos, encoding);
        this.realWriter = new BufferedWriter(osw);
    }

    public void close() throws IOException {
        this.signalClosing = true;
        this.flush();
        this.realWriter.close();
    }

    public void flush() throws IOException {
        StringBuffer buffer = this.writer.getBuffer();
        if (this.signalAlreadyFlushed) {
            this.realWriter.write(buffer.toString());
            buffer.setLength(0);
        } else if (this.signalClosing || buffer.length() >= 4096) {
            String contents;
            this.signalAlreadyFlushed = true;
            Matcher matcher_header = PatternConsts.XML_HEADER.matcher(buffer);
            if (matcher_header.find()) {
                contents = matcher_header.replaceFirst(this.XML_HEADER);
            } else {
                Log.log("Shouldn't happen! XMLWriter: XML File does not contain XML header:\n" + buffer.substring(0, Math.min(buffer.length(), 80)));
                this.realWriter.write(this.XML_HEADER);
                contents = buffer.toString();
            }
            this.realWriter.write(contents);
            buffer.setLength(0);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        if (this.writer.getBuffer().length() >= 65536) {
            this.flush();
        }
    }
}

