/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.xml.XMLDialect;
import org.omegat.util.MultiMap;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXMLDialect
implements XMLDialect {
    private Set<String> paragraphTags = new HashSet<String>();
    private Set<String> preformatTags = new HashSet<String>();
    private Set<String> intactTags = new HashSet<String>();
    private MultiMap<String, String> translatableTagAttributes = new MultiMap();
    private Set<String> translatableAttributes = new HashSet<String>();
    private Set<String> outOfTurnTags = new HashSet<String>();
    Map<Integer, Pattern> constraints = new HashMap<Integer, Pattern>();
    Map<String, String> shortcuts = new HashMap<String, String>();
    private boolean closingTagRequired = false;
    private boolean tagsAggregationEnabled = false;
    private boolean forceSpacePreserving = false;

    public void defineParagraphTag(String tag) {
        this.paragraphTags.add(tag);
    }

    public void defineParagraphTags(String[] tags) {
        for (String tag : tags) {
            this.defineParagraphTag(tag);
        }
    }

    public void definePreformatTag(String tag) {
        this.preformatTags.add(tag);
    }

    public void definePreformatTags(String[] tags) {
        for (String tag : tags) {
            this.definePreformatTag(tag);
        }
    }

    public void defineIntactTag(String tag) {
        this.intactTags.add(tag);
    }

    public void defineIntactTags(String[] tags) {
        for (String tag : tags) {
            this.defineIntactTag(tag);
        }
    }

    public void defineTranslatableTagAttribute(String tag, String attribute) {
        this.translatableTagAttributes.put(tag, attribute);
    }

    public void defineTranslatableTagAttributes(String tag, String[] attributes) {
        for (String attr : attributes) {
            this.defineTranslatableTagAttribute(tag, attr);
        }
    }

    public void defineTranslatableTagsAttribute(String[] tags, String attribute) {
        for (String tag : tags) {
            this.defineTranslatableTagAttribute(tag, attribute);
        }
    }

    public void defineTranslatableAttribute(String attribute) {
        this.translatableAttributes.add(attribute);
    }

    public void defineTranslatableAttributes(String[] attributes) {
        for (String attr : attributes) {
            this.defineTranslatableAttribute(attr);
        }
    }

    public void defineOutOfTurnTag(String tag) {
        this.outOfTurnTags.add(tag);
    }

    public void defineOutOfTurnTags(String[] tags) {
        for (String tag : tags) {
            this.defineOutOfTurnTag(tag);
        }
    }

    public void defineConstraint(Integer constraintType, Pattern template) {
        this.constraints.put(constraintType, template);
    }

    public void defineShortcut(String tag, String shortcut) {
        this.shortcuts.put(tag, shortcut);
    }

    public void defineShortcuts(String[] mappings) {
        for (int i = 0; i < mappings.length / 2; ++i) {
            this.defineShortcut(mappings[2 * i], mappings[2 * i + 1]);
        }
    }

    @Override
    public Set<String> getParagraphTags() {
        return this.paragraphTags;
    }

    @Override
    public Set<String> getPreformatTags() {
        return this.preformatTags;
    }

    @Override
    public Set<String> getIntactTags() {
        return this.intactTags;
    }

    @Override
    public MultiMap<String, String> getTranslatableTagAttributes() {
        return this.translatableTagAttributes;
    }

    @Override
    public Boolean validateTranslatableTagAttribute(String tag, String attribute, Attributes atts) {
        return true;
    }

    @Override
    public Boolean validateIntactTag(String tag, Attributes atts) {
        return false;
    }

    @Override
    public Boolean validateTranslatableTag(String tag, Attributes atts) {
        return true;
    }

    @Override
    public Boolean validateParagraphTag(String tag, Attributes atts) {
        return false;
    }

    @Override
    public Boolean validatePreformatTag(String tag, Attributes atts) {
        return false;
    }

    @Override
    public Set<String> getTranslatableAttributes() {
        return this.translatableAttributes;
    }

    @Override
    public Set<String> getOutOfTurnTags() {
        return this.outOfTurnTags;
    }

    @Override
    public Map<Integer, Pattern> getConstraints() {
        return this.constraints;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    @Override
    public Map<String, String> getShortcuts() {
        return this.shortcuts;
    }

    @Override
    public void setClosingTagRequired(boolean onOff) {
        this.closingTagRequired = onOff;
    }

    @Override
    public Boolean getClosingTagRequired() {
        return this.closingTagRequired;
    }

    @Override
    public void setTagsAggregationEnabled(boolean onOff) {
        this.tagsAggregationEnabled = onOff;
    }

    @Override
    public Boolean getTagsAggregationEnabled() {
        return this.tagsAggregationEnabled;
    }

    @Override
    public Boolean getForceSpacePreserving() {
        return this.forceSpacePreserving;
    }

    @Override
    public void setForceSpacePreserving(boolean onOff) {
        this.forceSpacePreserving = onOff;
    }
}

