/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3;

import java.util.ArrayList;
import java.util.List;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.AggregatedTag;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.Element;
import org.omegat.filters3.Tag;
import org.omegat.filters3.Text;
import org.omegat.util.PatternConsts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    private boolean tagsAggregationEnabled = false;
    private boolean tagsDetected = false;
    private int firstGood;
    private int lastGood;
    private Text textInstance = null;
    private String translation = new String();
    Entry translatedEntry = null;
    private List<Element> elements = new ArrayList<Element>();

    public void clear() {
        this.tagsDetected = false;
        this.elements.clear();
        this.translation = new String();
        this.translatedEntry = null;
        this.textInstance = null;
    }

    private int getFirstGood() {
        this.detectAndEnumerateTags();
        return this.firstGood;
    }

    private int getLastGood() {
        this.detectAndEnumerateTags();
        return this.lastGood;
    }

    private Text getTextInstance() {
        this.detectAndEnumerateTags();
        return this.textInstance;
    }

    private void detectAndEnumerateTags() {
        if (!this.tagsDetected) {
            if (this.tagsAggregationEnabled) {
                this.aggregateTags();
            }
            this.detectTags();
            this.tagsDetected = true;
            this.enumerateTags();
        }
    }

    private void aggregateTags() {
        ArrayList<Element> newElements = new ArrayList<Element>();
        AggregatedTag aggregated = null;
        for (Element elem : this.elements) {
            if (elem instanceof Tag) {
                if (aggregated == null) {
                    aggregated = new AggregatedTag("tag", null, 3, new Attributes());
                }
                aggregated.add((Tag)elem);
                continue;
            }
            if (aggregated != null) {
                newElements.add(aggregated);
                aggregated = null;
            }
            newElements.add(elem);
        }
        if (aggregated != null) {
            newElements.add(aggregated);
            aggregated = null;
        }
        this.elements.clear();
        for (Element elem : newElements) {
            this.elements.add(elem);
        }
        newElements.clear();
    }

    private void detectTags() {
        Tag cand;
        Element candElement;
        int i;
        int recursion;
        Tag good;
        Element goodElem;
        int textStart = -1;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Element elem = this.get(i2);
            if (!(elem instanceof Text) || !((Text)elem).isMeaningful()) continue;
            textStart = i2;
            this.textInstance = (Text)elem;
            break;
        }
        if (textStart < 0) {
            this.firstGood = -1;
            this.lastGood = -2;
            this.textInstance = null;
            return;
        }
        int textEnd = textStart;
        for (int i3 = this.size() - 1; i3 >= 0; --i3) {
            Element elem = this.get(i3);
            if (!(elem instanceof Text) || !((Text)elem).isMeaningful()) continue;
            textEnd = i3;
            break;
        }
        boolean found = false;
        this.firstGood = 0;
        while (this.firstGood < textStart) {
            goodElem = this.get(this.firstGood);
            if (goodElem instanceof Tag && 1 == (good = (Tag)goodElem).getType()) {
                recursion = 1;
                for (i = this.firstGood + 1; i < textEnd; ++i) {
                    candElement = this.get(i);
                    if (!(candElement instanceof Tag) || !(cand = (Tag)candElement).getTag().equals(good.getTag())) continue;
                    if (1 == cand.getType()) {
                        ++recursion;
                        continue;
                    }
                    if (2 != cand.getType() || --recursion != 0) continue;
                    if (i <= textStart) break;
                    found = true;
                    break;
                }
                if (found) break;
            }
            ++this.firstGood;
        }
        if (!found) {
            this.firstGood = textStart;
        }
        found = false;
        this.lastGood = this.size() - 1;
        while (this.lastGood > textEnd) {
            goodElem = this.get(this.lastGood);
            if (goodElem instanceof Tag && 2 == (good = (Tag)goodElem).getType()) {
                recursion = 1;
                for (i = this.lastGood - 1; i > textStart; --i) {
                    candElement = this.get(i);
                    if (!(candElement instanceof Tag) || !(cand = (Tag)candElement).getTag().equals(good.getTag())) continue;
                    if (2 == cand.getType()) {
                        ++recursion;
                        continue;
                    }
                    if (1 != cand.getType() || --recursion != 0) continue;
                    if (i >= textEnd) break;
                    found = true;
                    break;
                }
                if (found) break;
            }
            --this.lastGood;
        }
        if (!found) {
            this.lastGood = textEnd;
        }
    }

    private void enumerateTags() {
        int n = 0;
        for (int i = this.getFirstGood(); i <= this.getLastGood(); ++i) {
            Element elem = this.get(i);
            if (!(elem instanceof Tag)) continue;
            Tag tag = (Tag)elem;
            if (3 == tag.getType() || 1 == tag.getType()) {
                tag.setIndex(n);
                ++n;
                continue;
            }
            if (2 != tag.getType()) continue;
            tag.setIndex(-1);
            int recursion = 1;
            for (int j = i - 1; j >= this.getFirstGood(); --j) {
                Tag other;
                Element otherElem = this.get(j);
                if (!(otherElem instanceof Tag) || !(other = (Tag)otherElem).getTag().equals(tag.getTag())) continue;
                if (2 == other.getType()) {
                    ++recursion;
                    continue;
                }
                if (1 != other.getType() || --recursion != 0) continue;
                tag.setIndex(other.getIndex());
                break;
            }
            if (tag.getIndex() >= 0) continue;
            tag.setIndex(n);
            ++n;
        }
    }

    public String sourceToShortcut(boolean tagsAggregation) {
        StringBuffer buf = new StringBuffer();
        if (tagsAggregation != this.tagsAggregationEnabled) {
            this.tagsAggregationEnabled = tagsAggregation;
            this.tagsDetected = false;
        }
        for (int i = this.getFirstGood(); i <= this.getLastGood(); ++i) {
            buf.append(this.get(i).toShortcut());
        }
        return buf.toString();
    }

    private String sourceToShortcut() {
        return this.sourceToShortcut(this.tagsAggregationEnabled);
    }

    public String sourceToTMX() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            buf.append(this.get(i).toTMX());
        }
        return buf.toString();
    }

    public String sourceToOriginal() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            buf.append(this.get(i).toOriginal());
        }
        return buf.toString();
    }

    public void setTranslation(String translation) throws TranslationException {
        if (!this.sourceToShortcut().equals(translation)) {
            this.checkAndRecoverTags(translation);
            this.translation = translation;
        }
    }

    private void checkAndRecoverTags(String translation) throws TranslationException {
        this.translatedEntry = new Entry();
        List<ShortTag> shortTags = this.listShortTags(translation);
        int pos = 0;
        block0: for (ShortTag shortTag : shortTags) {
            if (pos < shortTag.pos) {
                this.translatedEntry.add(this.getTextInstance().createInstance(translation.substring(pos, shortTag.pos)));
                pos = shortTag.pos;
            }
            for (int j = this.getFirstGood(); j <= this.getLastGood(); ++j) {
                Tag longTag;
                Element longElem = this.get(j);
                if (!(longElem instanceof Tag) || !(longTag = (Tag)longElem).toShortcut().equals(shortTag.tag)) continue;
                this.translatedEntry.add(longTag);
                pos += shortTag.tag.length();
                continue block0;
            }
        }
        if (pos < translation.length()) {
            this.translatedEntry.add(this.getTextInstance().createInstance(translation.substring(pos)));
        }
    }

    private List<ShortTag> listShortTags(String str) {
        boolean STATE_NORMAL = true;
        int STATE_COLLECT_TAG = 2;
        int state = 1;
        ArrayList<ShortTag> res = new ArrayList<ShortTag>(str.length() / 4);
        StringBuffer tag = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '<') {
                tag.setLength(0);
                tag.append(c);
                state = 2;
                continue;
            }
            if (c == '>') {
                tag.append(c);
                if (!PatternConsts.OMEGAT_TAG.matcher(tag).matches()) continue;
                res.add(new ShortTag(tag.toString(), 1 + i - tag.length()));
                tag.setLength(0);
                state = 1;
                continue;
            }
            if (state != 2) continue;
            tag.append(c);
        }
        return res;
    }

    public String translationToShortcut() {
        if (this.translation.length() == 0) {
            return this.sourceToShortcut();
        }
        return this.translation;
    }

    public String translationToTMX() {
        int i;
        if (this.translatedEntry == null) {
            return this.sourceToTMX();
        }
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < this.getFirstGood(); ++i) {
            buf.append(this.get(i).toTMX());
        }
        buf.append(this.translatedEntry.sourceToTMX());
        for (i = this.getLastGood() + 1; i < this.size(); ++i) {
            buf.append(this.get(i).toTMX());
        }
        return buf.toString();
    }

    public String translationToOriginal() {
        int i;
        if (this.translatedEntry == null) {
            return this.sourceToOriginal();
        }
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < this.getFirstGood(); ++i) {
            buf.append(this.get(i).toOriginal());
        }
        buf.append(this.translatedEntry.sourceToOriginal());
        for (i = this.getLastGood() + 1; i < this.size(); ++i) {
            buf.append(this.get(i).toOriginal());
        }
        return buf.toString();
    }

    public void add(Element elem) {
        this.elements.add(elem);
        this.tagsDetected = false;
    }

    public void remove(int index) {
        this.elements.remove(index);
        this.tagsDetected = false;
    }

    public Element get(int i) {
        return this.elements.get(i);
    }

    public int size() {
        return this.elements.size();
    }

    class ShortTag {
        String tag;
        int pos;

        ShortTag(String tag, int pos) {
            this.tag = tag;
            this.pos = pos;
        }
    }
}

