/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.xtagqxp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.xtagqxp.Xtag;
import org.omegat.util.OStrings;

public class XtagFilter
extends AbstractFilter {
    protected static final String EOL = "\r\n";
    private List<Xtag> listTags = new ArrayList<Xtag>();

    public String getFileFormatName() {
        return OStrings.getString("XTAGFILTER_FILTER_NAME");
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.tag", "UTF-16LE", "UTF-16LE"), new Instance("*.xtg", "UTF-16LE", "UTF-16LE")};
    }

    public boolean isSourceEncodingVariable() {
        return true;
    }

    public boolean isTargetEncodingVariable() {
        return true;
    }

    protected boolean requirePrevNextFields() {
        return true;
    }

    public void processFile(BufferedReader in, BufferedWriter out, FilterContext fc) throws IOException, TranslationException {
        in.mark(1);
        int ch = in.read();
        if (ch != 65279) {
            in.reset();
        } else {
            out.write(ch);
        }
        this.processXtagFile(in, out);
    }

    private void processXtagFile(BufferedReader inFile, Writer outFile) throws IOException, TranslationException {
        boolean STATE_WAIT_TEXT = true;
        int STATE_READ_TEXT = 2;
        int state = 1;
        String s = inFile.readLine();
        while (s != null) {
            if (s.startsWith("@$:")) {
                outFile.write("@$:");
                s = s.substring(3);
                state = 2;
            } else if (s.startsWith("#boxname")) {
                state = 1;
            }
            String tr = state == 2 ? this.privateProcessEntry(s) : s;
            outFile.write(tr);
            s = inFile.readLine();
            if (s == null) continue;
            outFile.write(EOL);
        }
    }

    private String findTag(StringBuffer tag) {
        for (Xtag oneTag : this.listTags) {
            if (!oneTag.toShortcut().equals(tag.toString())) continue;
            return oneTag.toOriginal();
        }
        String changedString = "";
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            changedString = changedString + this.convertSpecialCharacter(c);
        }
        return changedString;
    }

    private String convertSpecialCharacter(char c) {
        String changedString = "";
        changedString = c == '<' ? changedString + "<\\<>" : (c == '>' ? changedString + "<\\>>" : Character.toString(c));
        return changedString;
    }

    private String convertToTags(String s) {
        String changedString = "";
        boolean STATE_NORMAL = true;
        int STATE_COLLECT_TAG = 2;
        int state = 1;
        int num = 0;
        this.listTags.clear();
        StringBuffer tag = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<' && state != 2) {
                tag.setLength(0);
                state = 2;
                continue;
            }
            if (c == '>' && tag.lastIndexOf("\\") != tag.length() - 1) {
                Xtag oneTag = new Xtag(tag.toString(), ++num);
                changedString = changedString + oneTag.toShortcut();
                this.listTags.add(oneTag);
                tag.setLength(0);
                state = 1;
                continue;
            }
            if (state == 2) {
                tag.append(c);
                continue;
            }
            changedString = changedString + c;
        }
        return changedString;
    }

    private String convertToXtags(String s) {
        String changedString = "";
        boolean STATE_NORMAL = true;
        int STATE_COLLECT_TAG = 2;
        int state = 1;
        StringBuffer tag = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<' && state != 2) {
                tag.setLength(0);
                tag.append(c);
                state = 2;
                continue;
            }
            if (c == '>' && state == 2) {
                tag.append(c);
                changedString = changedString + this.findTag(tag);
                state = 1;
                tag.setLength(0);
                continue;
            }
            if (state == 2) {
                tag.append(c);
                continue;
            }
            changedString = changedString + this.convertSpecialCharacter(c);
        }
        changedString = changedString + this.findTag(tag);
        return changedString;
    }

    private String privateProcessEntry(String entry) {
        entry = this.convertToTags(entry);
        entry = this.processEntry(entry);
        entry = this.convertToXtags(entry);
        return entry;
    }
}

