/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.dokuwiki;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.OStrings;

public class DokuWikiFilter
extends AbstractFilter {
    private Pattern codeTag = Pattern.compile("\\<code|\\<file|\\<html|\\<php|\\/\\*");

    public String getFileFormatName() {
        return OStrings.getString("DWFILTER_FILTER_NAME");
    }

    public boolean isSourceEncodingVariable() {
        return false;
    }

    public boolean isTargetEncodingVariable() {
        return false;
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.txt", "UTF-8", "UTF-8")};
    }

    protected boolean requirePrevNextFields() {
        return true;
    }

    protected boolean isFileSupported(BufferedReader reader) {
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        try {
            String line;
            while ((line = lbpr.readLine()) != null) {
                String trimmed = line.trim();
                if (this.getHeadingLevel(trimmed) <= 0) continue;
                lbpr.close();
                return true;
            }
            lbpr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        String line;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        StringBuilder text = new StringBuilder();
        while ((line = lbpr.readLine()) != null) {
            String trimmed = line.trim();
            if (trimmed.length() == 0) {
                this.writeTranslate(outfile, text, lbpr);
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            int headingLevel = this.getHeadingLevel(trimmed);
            if (headingLevel > 0) {
                this.writeTranslate(outfile, text, lbpr);
                String header = trimmed.substring(headingLevel, trimmed.length() - headingLevel).trim();
                if (header.length() > 0) {
                    String trans = this.processEntry(header);
                    line = line.replace(header, trans);
                }
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            if (line.startsWith("  *") || line.startsWith("  -")) {
                this.writeTranslate(outfile, text, lbpr);
                outfile.write(line.substring(0, 3));
                outfile.write(32);
                this.writeTranslate(outfile, line.substring(3), lbpr);
                continue;
            }
            if (trimmed.startsWith("{{") && trimmed.endsWith("}}") || trimmed.startsWith("~~") && trimmed.endsWith("~~") && trimmed.length() > 5) {
                this.writeTranslate(outfile, text, lbpr);
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            if (line.startsWith("|") || line.startsWith("^")) {
                this.writeTranslate(outfile, text, lbpr);
                int start = 0;
                int braceCount = 0;
                block6: for (int i = 0; i < line.length(); ++i) {
                    char ch = line.charAt(i);
                    switch (ch) {
                        case '^': 
                        case '|': {
                            if (braceCount != 0) continue block6;
                            String value = line.substring(start, i);
                            if (start > 0) {
                                outfile.write(32);
                                this.writeTranslate(outfile, value, null);
                                outfile.write(32);
                            }
                            outfile.write(ch);
                            start = i + 1;
                            continue block6;
                        }
                        case '{': {
                            ++braceCount;
                            continue block6;
                        }
                        case '}': {
                            --braceCount;
                        }
                    }
                }
                outfile.write(lbpr.getLinebreak());
                continue;
            }
            trimmed = this.skipCode(outfile, text, lbpr, line);
            if (trimmed == null) {
                return;
            }
            text.append(' ');
            text.append(trimmed);
        }
        this.writeTranslate(outfile, text, lbpr);
    }

    private int getHeadingLevel(String line) {
        int length;
        int level = 0;
        for (length = line.length() - 1; level < length && line.charAt(level) == '=' && line.charAt(length) == '='; ++level, --length) {
        }
        if (level < length) {
            return level;
        }
        return 0;
    }

    private void writeTranslate(BufferedWriter outfile, StringBuilder text, LinebreakPreservingReader lbpr) throws IOException {
        if (text.length() > 0) {
            String value = text.toString();
            text.setLength(0);
            this.writeTranslate(outfile, value, lbpr);
        }
    }

    private void writeTranslate(BufferedWriter outfile, String value, LinebreakPreservingReader lbpr) throws IOException {
        if ((value = value.trim()).length() > 0) {
            String newValue;
            while (!(newValue = value.replace("  ", " ")).equals(value)) {
                value = newValue;
            }
            String trans = this.processEntry(value);
            outfile.write(trans);
            if (lbpr != null) {
                outfile.write(lbpr.getLinebreak());
            }
        }
    }

    private String skipCode(BufferedWriter outfile, StringBuilder text, LinebreakPreservingReader lbpr, String line) throws IOException {
        Matcher matcher;
        while ((matcher = this.codeTag.matcher(line)).find()) {
            int start = matcher.start();
            String tagName = line.substring(start + 1, matcher.end());
            boolean isAsterisk = tagName.equals("*");
            text.append(' ');
            text.append(line.substring(0, start));
            if (!isAsterisk) {
                this.writeTranslate(outfile, text, lbpr);
            }
            String endTagPattern = isAsterisk ? "\\*\\/" : "\\</" + tagName + "\\>";
            Pattern endTag = Pattern.compile(endTagPattern);
            line = line.substring(start);
            matcher = endTag.matcher(line);
            while (!matcher.find()) {
                outfile.write(line + lbpr.getLinebreak());
                line = lbpr.readLine();
                if (line == null) {
                    return null;
                }
                matcher = endTag.matcher(line);
            }
            int end = matcher.end();
            outfile.write(line.substring(0, end) + lbpr.getLinebreak());
            line = line.substring(end);
        }
        return line;
    }
}

