/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.bundles;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class ResourceBundleFilter
extends AbstractFilter {
    protected Map<String, String> align;

    public String getFileFormatName() {
        return OStrings.getString("RBFILTER_FILTER_NAME");
    }

    public boolean isSourceEncodingVariable() {
        return false;
    }

    public boolean isTargetEncodingVariable() {
        return false;
    }

    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.properties", null, null, "${nameOnly}_${targetLocale}.${extension}")};
    }

    public BufferedReader createReader(File infile, String encoding) throws UnsupportedEncodingException, IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-1"));
    }

    public BufferedWriter createWriter(File outfile, String encoding) throws UnsupportedEncodingException, IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "ISO-8859-1"));
    }

    protected String getNextLine(LinebreakPreservingReader reader) throws IOException {
        String ascii = reader.readLine();
        if (ascii == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < ascii.length(); ++i) {
            int ch = ascii.charAt(i);
            if (ch == 92 && i != ascii.length() - 1) {
                if ((ch = ascii.charAt(++i)) != 117) {
                    if (ch == 110) {
                        ch = 10;
                    } else if (ch == 114) {
                        ch = 13;
                    } else if (ch == 116) {
                        ch = 9;
                    } else {
                        result.append('\\');
                    }
                } else if (ascii.length() >= i + 1 + 4) {
                    ch = (char)Integer.parseInt(ascii.substring(i + 1, i + 1 + 4), 16);
                    i += 4;
                } else {
                    throw new IOException(OStrings.getString("RBFH_ERROR_ILLEGAL_U_SEQUENCE"));
                }
            }
            result.append((char)ch);
        }
        return result.toString();
    }

    private String toAscii(String text, boolean key) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\\') {
                result.append("\\\\");
                continue;
            }
            if (ch == '\n') {
                result.append("\\n");
                continue;
            }
            if (ch == '\r') {
                result.append("\\r");
                continue;
            }
            if (ch == '\t') {
                result.append("\\t");
                continue;
            }
            if (key && ch == ' ') {
                result.append("\\ ");
                continue;
            }
            if (key && ch == '=') {
                result.append("\\=");
                continue;
            }
            if (key && ch == ':') {
                result.append("\\:");
                continue;
            }
            if (ch >= ' ' && ch < '\u007f') {
                result.append(ch);
                continue;
            }
            String code = Integer.toString(ch, 16);
            while (code.length() < 4) {
                code = '0' + code;
            }
            result.append("\\u" + code);
        }
        return result.toString();
    }

    private String removeExtraSlashes(String string) {
        StringBuffer result = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int ch = string.charAt(i);
            if (ch == 92) {
                ch = i + 1 < string.length() ? (int)string.charAt(++i) : 32;
            }
            result.append((char)ch);
        }
        return result.toString();
    }

    private String leftTrim(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t'); ++i) {
        }
        s = s.replaceAll("\\\\ ", " ");
        return s.substring(i, s.length());
    }

    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        String str;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        boolean noi18n = false;
        while ((str = this.getNextLine(lbpr)) != null) {
            String trimmed = str.trim();
            if (trimmed.length() == 0) {
                outfile.write(this.toAscii(str, false) + lbpr.getLinebreak());
                continue;
            }
            char firstChar = trimmed.charAt(0);
            if (firstChar == '#' || firstChar == '!') {
                outfile.write(this.toAscii(str, false) + lbpr.getLinebreak());
                if (trimmed.indexOf("NOI18N") < 0) continue;
                noi18n = true;
                continue;
            }
            while (str.charAt(str.length() - 1) == '\\') {
                String next = this.getNextLine(lbpr);
                if (next == null) {
                    next = "";
                }
                str = str.substring(0, str.length() - 1) + this.leftTrim(next);
            }
            int equalsPos = this.searchEquals(str);
            String key = equalsPos >= 0 ? str.substring(0, equalsPos).trim() : str.trim();
            key = this.removeExtraSlashes(key);
            outfile.write(this.toAscii(key, true));
            if (equalsPos >= 0) {
                char ch;
                int equalsEnd;
                for (equalsEnd = equalsPos + 1; equalsEnd < str.length() && ((ch = str.charAt(equalsEnd)) == ' ' || ch == '\t'); ++equalsEnd) {
                }
                String equals = str.substring(equalsPos, equalsEnd);
                outfile.write(equals);
                String value = equalsEnd < str.length() ? this.removeExtraSlashes(str.substring(equalsEnd)) : "";
                if (noi18n) {
                    outfile.write(this.toAscii(value, false));
                    noi18n = false;
                } else {
                    value = value.replaceAll("\\n\\n", "\n \n");
                    String trans = this.process(key, value);
                    trans = trans.replaceAll("\\n\\s\\n", "\n\n");
                    if ((trans = this.toAscii(trans, false)).length() > 0 && trans.charAt(0) == ' ') {
                        trans = '\\' + trans;
                    }
                    outfile.write(trans);
                }
            }
            outfile.write(lbpr.getLinebreak());
        }
    }

    private int searchEquals(String str) {
        int prevChar = 97;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (prevChar != 92) {
                if (ch == '=' || ch == ':') {
                    return i;
                }
                if (ch == ' ' || ch == '\t') {
                    for (int j = i + 1; j < str.length(); ++j) {
                        char c2 = str.charAt(j);
                        if (c2 == ':' || c2 == '=') {
                            return j;
                        }
                        if (c2 == ' ' || c2 == '\t') continue;
                        return i;
                    }
                    return i;
                }
            }
            prevChar = ch;
        }
        return -1;
    }

    protected String process(String key, String value) {
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(key, value, null, false, null, null, this);
            return value;
        }
        if (this.entryTranslateCallback != null) {
            String trans = this.entryTranslateCallback.getTranslation(key, value, null);
            return trans != null ? trans : value;
        }
        if (this.entryAlignCallback != null) {
            this.align.put(key, value);
        }
        return value;
    }

    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    public String getInEncodingLastParsedFile() {
        return "ISO-8859-1";
    }
}

