/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.text.TextOptionsDialog;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFilter
extends AbstractFilter {
    public static final String SEGMENT_BREAKS = "BREAKS";
    public static final String SEGMENT_EMPTYLINES = "EMPTYLINES";
    public static final String SEGMENT_NEVER = "NEVER";
    public static final String OPTION_SEGMENT_ON = "segmentOn";

    @Override
    public String getFileFormatName() {
        return OStrings.getString("TEXTFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.txt"), new Instance("*.txt1", "ISO-8859-1", "ISO-8859-1"), new Instance("*.txt2", "ISO-8859-2", "ISO-8859-2"), new Instance("*.utf8", "UTF-8", "UTF-8")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    public void processFile(BufferedReader in, BufferedWriter out, FilterContext fc) throws IOException {
        String segmentOn;
        in.mark(1);
        int ch = in.read();
        if (ch != 65279) {
            in.reset();
        }
        if (SEGMENT_BREAKS.equals(segmentOn = (String)this.processOptions.get(OPTION_SEGMENT_ON))) {
            this.processSegLineBreaks(in, out);
        } else if (SEGMENT_NEVER.equals(segmentOn)) {
            this.processNonSeg(in, out);
        } else {
            this.processSegEmptyLines(in, out);
        }
    }

    private void processNonSeg(BufferedReader in, Writer out) throws IOException {
        int len;
        StringBuffer segment = new StringBuffer();
        char[] buf = new char[4096];
        while ((len = in.read(buf)) >= 0) {
            segment.append(buf, 0, len);
        }
        out.write(this.processEntry(segment.toString()));
    }

    private void processSegLineBreaks(BufferedReader in, Writer out) throws IOException {
        String s;
        LinebreakPreservingReader lpin = new LinebreakPreservingReader(in);
        String nontrans = "";
        while ((s = lpin.readLine()) != null) {
            if (s.trim().length() == 0) {
                nontrans = nontrans + s + lpin.getLinebreak();
                continue;
            }
            String srcText = s;
            out.write(nontrans);
            nontrans = "";
            String translation = this.processEntry(srcText);
            out.write(translation);
            nontrans = nontrans + lpin.getLinebreak();
        }
        lpin.close();
        if (nontrans.length() != 0) {
            out.write(nontrans);
        }
    }

    private void processSegEmptyLines(BufferedReader in, Writer out) throws IOException {
        String s;
        LinebreakPreservingReader lpin = new LinebreakPreservingReader(in);
        StringBuffer nontrans = new StringBuffer();
        StringBuffer trans = new StringBuffer();
        while ((s = lpin.readLine()) != null) {
            if (s.length() == 0) {
                out.write(nontrans.toString());
                nontrans.setLength(0);
                out.write(this.processEntry(trans.toString()));
                trans.setLength(0);
                nontrans.append(lpin.getLinebreak());
                continue;
            }
            if (s.trim().length() == 0 && trans.length() == 0) {
                nontrans.append(s);
                nontrans.append(lpin.getLinebreak());
                continue;
            }
            trans.append(s);
            trans.append(lpin.getLinebreak());
        }
        lpin.close();
        if (nontrans.length() >= 0) {
            out.write(nontrans.toString());
        }
        if (trans.length() >= 0) {
            out.write(this.processEntry(trans.toString()));
        }
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        try {
            TextOptionsDialog dialog = new TextOptionsDialog(parent, config);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions();
            }
            return null;
        }
        catch (Exception e) {
            Log.log("Text filter threw an exception:");
            Log.log(e);
            return null;
        }
    }

    @Override
    public boolean hasOptions() {
        return true;
    }
}

