/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.po;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private Map<String, String> options;
    private JCheckBox allowBlankCB;
    private JCheckBox skipHeaderCB;
    private JCheckBox autoFillInPluralStatementCB;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JButton okButton;
    private int returnStatus = 0;

    public PoOptionsDialog(Dialog parent, Map<String, String> options) {
        super(parent, true);
        this.options = new TreeMap<String, String>(options);
        this.initComponents();
        String allowBlank = options.get("disallowBlank");
        this.allowBlankCB.setSelected("true".equalsIgnoreCase(allowBlank));
        String skipHeader = options.get("skipHeader");
        this.skipHeaderCB.setSelected("true".equalsIgnoreCase(skipHeader));
        String autoFillInPluralStatement = options.get("autoFillInPluralStatement");
        this.autoFillInPluralStatementCB.setSelected("true".equalsIgnoreCase(autoFillInPluralStatement));
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PoOptionsDialog.this.doClose(0);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.allowBlankCB = new JCheckBox();
        this.skipHeaderCB = new JCheckBox();
        this.autoFillInPluralStatementCB = new JCheckBox();
        this.setTitle(OStrings.getString("POFILTER_OPTIONS_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PoOptionsDialog.this.closeDialog(evt);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PoOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PoOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.setLayout(new GridLayout(0, 1, 0, 3));
        Mnemonics.setLocalizedText(this.allowBlankCB, OStrings.getString("POFILTER_ALLOW_BLANK"));
        this.jPanel1.add(this.allowBlankCB);
        Mnemonics.setLocalizedText(this.skipHeaderCB, OStrings.getString("POFILTER_SKIP_HEADER"));
        this.jPanel1.add(this.skipHeaderCB);
        Mnemonics.setLocalizedText(this.autoFillInPluralStatementCB, OStrings.getString("POFILTER_AUTO_FILL_IN_PLURAL_STATEMENT"));
        this.jPanel1.add(this.autoFillInPluralStatementCB);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.options.put("disallowBlank", Boolean.toString(this.allowBlankCB.isSelected()));
        this.options.put("skipHeader", Boolean.toString(this.skipHeaderCB.isSelected()));
        this.options.put("autoFillInPluralStatement", Boolean.toString(this.autoFillInPluralStatementCB.isSelected()));
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

