/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.po;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.po.PoOptionsDialog;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoFilter
extends AbstractFilter {
    public static final String OPTION_ALLOW_BLANK = "disallowBlank";
    public static final String OPTION_SKIP_HEADER = "skipHeader";
    public static final String OPTION_AUTO_FILL_IN_PLURAL_STATEMENT = "autoFillInPluralStatement";
    private static final Map<String, PluralInfo> pluralInfos;
    public static boolean allowBlank;
    public static boolean skipHeader;
    public static boolean autoFillInPluralStatement;
    protected static Pattern COMMENT_FUZZY;
    protected static Pattern COMMENT_FUZZY_OTHER;
    protected static Pattern COMMENT_NOWRAP;
    protected static Pattern COMMENT_TRANSLATOR;
    protected static Pattern COMMENT_EXTRACTED;
    protected static Pattern COMMENT_REFERENCE;
    protected static Pattern MSG_ID;
    protected static Pattern MSG_STR;
    protected static Pattern MSG_CTX;
    protected static Pattern MSG_OTHER;
    private StringBuilder[] sources;
    private StringBuilder[] targets;
    private StringBuilder translatorComments;
    private StringBuilder extractedComments;
    private StringBuilder references;
    private int plurals = 2;
    private String path;
    private boolean nowrap;
    private boolean fuzzy;
    private BufferedWriter out;
    protected static final Pattern R1;
    protected static final Pattern R2;
    protected static final Pattern R3;
    protected static final Pattern R4;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("POFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.po"), new Instance("*.pot")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public String getFuzzyMark() {
        return "PO-fuzzy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        String disallowBlankStr = (String)this.processOptions.get(OPTION_ALLOW_BLANK);
        allowBlank = disallowBlankStr == null || disallowBlankStr.equalsIgnoreCase("true");
        String skipHeaderStr = (String)this.processOptions.get(OPTION_SKIP_HEADER);
        skipHeader = "true".equalsIgnoreCase(skipHeaderStr);
        String autoFillInPluralStatementStr = (String)this.processOptions.get(OPTION_AUTO_FILL_IN_PLURAL_STATEMENT);
        autoFillInPluralStatement = "true".equalsIgnoreCase(autoFillInPluralStatementStr);
        this.inEncodingLastParsedFile = fc.getInEncoding();
        BufferedReader reader = this.createReader(inFile, this.inEncodingLastParsedFile);
        try {
            BufferedWriter writer = outFile != null ? this.createWriter(outFile, fc.getOutEncoding()) : null;
            try {
                this.processFile(reader, writer, fc);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            reader.close();
        }
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        translatedFile.mark(1);
        int ch = translatedFile.read();
        if (ch != 65279) {
            translatedFile.reset();
        }
        this.out = null;
        this.processPoFile(translatedFile, fc);
    }

    @Override
    public void processFile(BufferedReader in, BufferedWriter out, FilterContext fc) throws IOException {
        in.mark(1);
        int ch = in.read();
        if (ch != 65279) {
            in.reset();
        }
        this.out = out;
        this.processPoFile(in, fc);
    }

    private void processPoFile(BufferedReader in, FilterContext fc) throws IOException {
        String s;
        this.fuzzy = false;
        this.nowrap = false;
        MODE currentMode = null;
        int currentPlural = 0;
        this.sources = new StringBuilder[2];
        this.sources[0] = new StringBuilder();
        this.sources[1] = new StringBuilder();
        this.targets = new StringBuilder[2];
        this.targets[0] = new StringBuilder();
        this.targets[1] = new StringBuilder();
        this.translatorComments = new StringBuilder();
        this.extractedComments = new StringBuilder();
        this.references = new StringBuilder();
        this.path = null;
        while ((s = in.readLine()) != null) {
            String text;
            if (COMMENT_FUZZY.matcher(s = s.trim()).matches()) {
                currentPlural = 0;
                this.fuzzy = true;
                this.flushTranslation(currentMode, fc);
                continue;
            }
            if (COMMENT_FUZZY_OTHER.matcher(s).matches()) {
                currentPlural = 0;
                this.fuzzy = true;
                this.flushTranslation(currentMode, fc);
                s = s.replaceAll("(.*), fuzzy(.*)", "$1$2");
            }
            if (COMMENT_NOWRAP.matcher(s).matches()) {
                currentPlural = 0;
                this.flushTranslation(currentMode, fc);
                this.nowrap = true;
                this.eol(s);
                continue;
            }
            Matcher m = MSG_ID.matcher(s);
            if (m.matches()) {
                currentPlural = 0;
                text = m.group(2);
                if (m.group(1) == null) {
                    if (this.sources[0].length() > 0) {
                        this.flushTranslation(currentMode, fc);
                    }
                    currentMode = MODE.MSGID;
                    this.sources[0].append(text);
                } else {
                    currentMode = MODE.MSGID_PLURAL;
                    this.sources[1].append(text);
                }
                this.eol(s);
                continue;
            }
            m = MSG_STR.matcher(s);
            if (m.matches()) {
                text = m.group(3);
                if (m.group(1) == null) {
                    currentMode = MODE.MSGSTR;
                    this.targets[0].append(text);
                    currentPlural = 0;
                    continue;
                }
                currentMode = MODE.MSGSTR_PLURAL;
                currentPlural = Integer.parseInt(m.group(2));
                if (currentPlural >= this.plurals) continue;
                this.targets[currentPlural].append(text);
                continue;
            }
            m = MSG_CTX.matcher(s);
            if (m.matches()) {
                currentMode = MODE.MSGCTX;
                currentPlural = 0;
                this.path = m.group(1);
                this.eol(s);
                continue;
            }
            m = COMMENT_REFERENCE.matcher(s);
            if (m.matches()) {
                currentPlural = 0;
                this.references.append(m.group(1));
                this.references.append("\n");
                this.eol(s);
                continue;
            }
            m = COMMENT_EXTRACTED.matcher(s);
            if (m.matches()) {
                currentPlural = 0;
                this.extractedComments.append(m.group(1));
                this.extractedComments.append("\n");
                this.eol(s);
                continue;
            }
            m = COMMENT_TRANSLATOR.matcher(s);
            if (m.matches()) {
                currentPlural = 0;
                this.translatorComments.append(m.group(1));
                this.translatorComments.append("\n");
                this.eol(s);
                continue;
            }
            m = MSG_OTHER.matcher(s);
            if (m.matches()) {
                text = m.group(1);
                if (currentMode == null) {
                    throw new IOException(OStrings.getString("POFILTER_INVALID_FORMAT"));
                }
                switch (currentMode) {
                    case MSGID: {
                        this.sources[0].append(text);
                        this.eol(s);
                        break;
                    }
                    case MSGID_PLURAL: {
                        this.sources[1].append(text);
                        this.eol(s);
                        break;
                    }
                    case MSGSTR: {
                        this.targets[0].append(text);
                        break;
                    }
                    case MSGSTR_PLURAL: {
                        this.targets[currentPlural].append(text);
                        break;
                    }
                    case MSGCTX: {
                        this.eol(s);
                    }
                }
                continue;
            }
            this.flushTranslation(currentMode, fc);
            this.eol(s);
        }
        this.flushTranslation(currentMode, fc);
    }

    protected void eol(String s) throws IOException {
        if (this.out != null) {
            this.out.write(s);
            this.out.write(10);
        }
    }

    protected void align(int pair) {
        String s;
        String id = null;
        String c = "";
        if (pair > 1) {
            s = this.unescape(this.sources[1].toString());
            id = "[" + pair + "]" + s;
            c = c + StaticUtils.format(OStrings.getString("POFILTER_PLURAL_FORM_COMMENT"), pair) + "\n";
        } else {
            s = this.unescape(this.sources[pair].toString());
        }
        String t = this.unescape(this.targets[pair].toString());
        if (this.translatorComments.length() > 0) {
            c = c + OStrings.getString("POFILTER_TRANSLATOR_COMMENTS") + "\n" + this.unescape(this.translatorComments.toString() + "\n");
        }
        if (this.extractedComments.length() > 0) {
            c = c + OStrings.getString("POFILTER_EXTRACTED_COMMENTS") + "\n" + this.unescape(this.extractedComments.toString() + "\n");
        }
        if (this.references.length() > 0) {
            c = c + OStrings.getString("POFILTER_REFERENCES") + "\n" + this.unescape(this.references.toString() + "\n");
        }
        if (c.length() == 0) {
            c = null;
        }
        this.align(s, t, c, id);
    }

    protected void align(String source, String translation, String comments, String id) {
        if (translation.length() == 0) {
            translation = null;
        }
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(id, source, translation, this.fuzzy, comments, this.path, this);
        } else if (this.entryAlignCallback != null) {
            this.entryAlignCallback.addTranslation(id, source, translation, this.fuzzy, null, this);
        }
    }

    protected void alignHeader(String header, FilterContext fc) {
        if (this.entryParseCallback != null && !skipHeader) {
            header = this.autoFillInPluralStatement(header, fc);
            this.entryParseCallback.addEntry(null, this.unescape(header), null, false, null, this.path, this);
        }
    }

    protected void flushTranslation(MODE currentMode, FilterContext fc) throws IOException {
        if (this.sources[0].length() == 0) {
            if (this.targets[0].length() == 0) {
                return;
            }
            StringBuilder targets0 = this.targets[0];
            String header = this.targets[0].toString();
            Pattern pluralPattern = Pattern.compile("Plural-Forms: *nplurals= *([0-9]+) *; *plural", 2);
            Matcher pluralMatcher = pluralPattern.matcher(header);
            if (pluralMatcher.find()) {
                String nrOfPluralsString = header.substring(pluralMatcher.start(1), pluralMatcher.end(1));
                this.plurals = Integer.parseInt(nrOfPluralsString);
            } else {
                Language targetLang = fc.getTargetLang();
                String lang = targetLang.getLanguageCode().toLowerCase();
                PluralInfo pluralInfo = pluralInfos.get(lang);
                if (pluralInfo != null) {
                    this.plurals = pluralInfo.plurals;
                }
            }
            this.targets = new StringBuilder[this.plurals];
            this.targets[0] = targets0;
            for (int i = 1; i < this.plurals; ++i) {
                this.targets[i] = new StringBuilder();
            }
            if (this.out != null) {
                this.out.write("msgstr " + this.getTranslation(this.targets[0], false, true, fc, 0) + "\n");
            } else {
                this.alignHeader(this.targets[0].toString(), fc);
            }
            this.fuzzy = false;
        } else {
            int i;
            if (this.sources[1].length() == 0) {
                if (this.out != null) {
                    this.out.write("msgstr " + this.getTranslation(this.sources[0], allowBlank, false, fc, 0) + "\n");
                } else {
                    this.align(0);
                }
            } else if (this.out != null) {
                this.out.write("msgstr[0] " + this.getTranslation(this.sources[0], allowBlank, false, fc, 0) + "\n");
                for (i = 1; i < this.plurals; ++i) {
                    this.out.write("msgstr[" + i + "] " + this.getTranslation(this.sources[1], allowBlank, false, fc, i) + "\n");
                }
            } else {
                this.align(0);
                for (i = 1; i < this.plurals; ++i) {
                    this.align(i);
                }
            }
            this.fuzzy = false;
        }
        this.sources[0].setLength(0);
        this.sources[1].setLength(0);
        for (int i = 0; i < this.plurals; ++i) {
            this.targets[i].setLength(0);
        }
        this.path = null;
        this.translatorComments.setLength(0);
        this.extractedComments.setLength(0);
        this.references.setLength(0);
    }

    private String getTranslation(StringBuilder en, boolean allowNull, boolean isHeader, FilterContext fc, int plural) {
        String entry = this.unescape(en.toString());
        String id = null;
        if (plural > 1) {
            id = "[" + plural + "]" + entry;
        }
        String translation = null;
        if (isHeader) {
            entry = this.autoFillInPluralStatement(entry, fc);
        }
        if ((translation = isHeader && skipHeader ? entry : this.entryTranslateCallback.getTranslation(id, entry, this.path)) == null && !allowNull) {
            translation = entry;
        }
        if (translation != null) {
            return "\"" + this.escape(translation) + "\"";
        }
        return "\"\"";
    }

    private String autoFillInPluralStatement(String header, FilterContext fc) {
        Language targetLang;
        String lang;
        PluralInfo pluralInfo;
        if (autoFillInPluralStatement && (pluralInfo = pluralInfos.get(lang = (targetLang = fc.getTargetLang()).getLanguageCode().toLowerCase())) != null) {
            return header.replaceAll("Plural-Forms: nplurals=INTEGER; plural=EXPRESSION;", "Plural-Forms: nplurals=" + pluralInfo.plurals + "; plural=" + pluralInfo.expression + ";");
        }
        return header;
    }

    private String unescape(String entry) {
        entry = R1.matcher(entry).replaceAll("$1\"");
        entry = R2.matcher(entry).replaceAll("$1\n");
        entry = R3.matcher(entry).replaceAll("$1\t");
        entry = R4.matcher(entry).replaceAll("\\\n");
        entry = entry.replace("\\\\", "\\");
        return entry;
    }

    private String escape(String translation) {
        translation = translation.replace("\\", "\\\\");
        translation = translation.replace("\"", "\\\"");
        if ((translation = translation.replace("\n", "\\n\"\n\"")).endsWith("\"\n\"")) {
            translation = translation.substring(0, translation.length() - 3);
        }
        if (this.nowrap && translation.contains("\n")) {
            translation = "\"\n\"" + translation;
        }
        translation = translation.replace("\t", "\\t");
        return translation;
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        try {
            PoOptionsDialog dialog = new PoOptionsDialog(parent, config);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions();
            }
            return null;
        }
        catch (Exception e) {
            Log.log(OStrings.getString("POFILTER_EXCEPTION"));
            Log.log(e);
            return null;
        }
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    static {
        HashMap<String, PluralInfo> info = new HashMap<String, PluralInfo>();
        info.put("ach", new PluralInfo(2, "(n > 1)"));
        info.put("af", new PluralInfo(2, "(n != 1)"));
        info.put("ak", new PluralInfo(2, "(n > 1)"));
        info.put("am", new PluralInfo(2, "(n > 1)"));
        info.put("an", new PluralInfo(2, "(n != 1)"));
        info.put("ar", new PluralInfo(6, " n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 ? 4 : 5"));
        info.put("arn", new PluralInfo(2, "(n > 1)"));
        info.put("ast", new PluralInfo(2, "(n != 1)"));
        info.put("ay", new PluralInfo(1, "0"));
        info.put("az", new PluralInfo(2, "(n != 1) "));
        info.put("be", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("bg", new PluralInfo(2, "(n != 1)"));
        info.put("bn", new PluralInfo(2, "(n != 1)"));
        info.put("bo", new PluralInfo(1, "0"));
        info.put("br", new PluralInfo(2, "(n > 1)"));
        info.put("brx", new PluralInfo(2, "(n != 1)"));
        info.put("bs", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2) "));
        info.put("ca", new PluralInfo(2, "(n != 1)"));
        info.put("cgg", new PluralInfo(1, "0"));
        info.put("cs", new PluralInfo(3, "(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2"));
        info.put("csb", new PluralInfo(3, "n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2"));
        info.put("cy", new PluralInfo(4, " (n==1) ? 0 : (n==2) ? 1 : (n != 8 && n != 11) ? 2 : 3"));
        info.put("da", new PluralInfo(2, "(n != 1)"));
        info.put("de", new PluralInfo(2, "(n != 1)"));
        info.put("doi", new PluralInfo(2, "(n != 1)"));
        info.put("dz", new PluralInfo(1, "0"));
        info.put("el", new PluralInfo(2, "(n != 1)"));
        info.put("en", new PluralInfo(2, "(n != 1)"));
        info.put("eo", new PluralInfo(2, "(n != 1)"));
        info.put("es", new PluralInfo(2, "(n != 1)"));
        info.put("et", new PluralInfo(2, "(n != 1)"));
        info.put("eu", new PluralInfo(2, "(n != 1)"));
        info.put("fa", new PluralInfo(1, "0"));
        info.put("ff", new PluralInfo(2, "(n != 1)"));
        info.put("fi", new PluralInfo(2, "(n != 1)"));
        info.put("fil", new PluralInfo(2, "n > 1"));
        info.put("fo", new PluralInfo(2, "(n != 1)"));
        info.put("fr", new PluralInfo(2, "(n > 1)"));
        info.put("fur", new PluralInfo(2, "(n != 1)"));
        info.put("fy", new PluralInfo(2, "(n != 1)"));
        info.put("ga", new PluralInfo(5, "n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4"));
        info.put("gd", new PluralInfo(4, "(n==1 || n==11) ? 0 : (n==2 || n==12) ? 1 : (n > 2 && n < 20) ? 2 : 3"));
        info.put("gl", new PluralInfo(2, "(n != 1)"));
        info.put("gu", new PluralInfo(2, "(n != 1)"));
        info.put("gun", new PluralInfo(2, "(n > 1)"));
        info.put("ha", new PluralInfo(2, "(n != 1)"));
        info.put("he", new PluralInfo(2, "(n != 1)"));
        info.put("hi", new PluralInfo(2, "(n != 1)"));
        info.put("hne", new PluralInfo(2, "(n != 1)"));
        info.put("hy", new PluralInfo(2, "(n != 1)"));
        info.put("hr", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("hu", new PluralInfo(2, "(n != 1)"));
        info.put("ia", new PluralInfo(2, "(n != 1)"));
        info.put("id", new PluralInfo(1, "0"));
        info.put("is", new PluralInfo(2, "(n%10!=1 || n%100==11)"));
        info.put("it", new PluralInfo(2, "(n != 1)"));
        info.put("ja", new PluralInfo(1, "0"));
        info.put("jbo", new PluralInfo(1, "0"));
        info.put("jv", new PluralInfo(2, "n!=0"));
        info.put("ka", new PluralInfo(1, "0"));
        info.put("kk", new PluralInfo(1, "0"));
        info.put("km", new PluralInfo(1, "0"));
        info.put("kn", new PluralInfo(2, "(n!=1)"));
        info.put("ko", new PluralInfo(1, "0"));
        info.put("ku", new PluralInfo(2, "(n!= 1)"));
        info.put("kw", new PluralInfo(4, " (n==1) ? 0 : (n==2) ? 1 : (n == 3) ? 2 : 3"));
        info.put("ky", new PluralInfo(1, "0"));
        info.put("lb", new PluralInfo(2, "(n != 1)"));
        info.put("ln", new PluralInfo(2, "n>1"));
        info.put("lo", new PluralInfo(1, "0"));
        info.put("lt", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && (n%100<10 or n%100>=20) ? 1 : 2)"));
        info.put("lv", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n != 0 ? 1 : 2)"));
        info.put("mai", new PluralInfo(2, "(n != 1)"));
        info.put("mfe", new PluralInfo(2, "(n > 1)"));
        info.put("mg", new PluralInfo(2, "(n > 1)"));
        info.put("mi", new PluralInfo(2, "(n > 1)"));
        info.put("mk", new PluralInfo(2, " n==1 || n%10==1 ? 0 : 1"));
        info.put("ml", new PluralInfo(2, "(n != 1)"));
        info.put("mn", new PluralInfo(2, "(n != 1)"));
        info.put("mni", new PluralInfo(2, "(n != 1)"));
        info.put("mnk", new PluralInfo(3, "(n==0 ? 0 : n==1 ? 1 : 2"));
        info.put("mr", new PluralInfo(2, "(n != 1)"));
        info.put("ms", new PluralInfo(1, "0"));
        info.put("mt", new PluralInfo(4, "(n==1 ? 0 : n==0 || ( n%100>1 && n%100<11) ? 1 : (n%100>10 && n%100<20 ) ? 2 : 3)"));
        info.put("my", new PluralInfo(1, "0"));
        info.put("nah", new PluralInfo(2, "(n != 1)"));
        info.put("nap", new PluralInfo(2, "(n != 1)"));
        info.put("nb", new PluralInfo(2, "(n != 1)"));
        info.put("ne", new PluralInfo(2, "(n != 1)"));
        info.put("nl", new PluralInfo(2, "(n != 1)"));
        info.put("se", new PluralInfo(2, "(n != 1)"));
        info.put("nn", new PluralInfo(2, "(n != 1)"));
        info.put("no", new PluralInfo(2, "(n != 1)"));
        info.put("nso", new PluralInfo(2, "(n != 1)"));
        info.put("oc", new PluralInfo(2, "(n > 1)"));
        info.put("or", new PluralInfo(2, "(n != 1)"));
        info.put("ps", new PluralInfo(2, "(n != 1)"));
        info.put("pa", new PluralInfo(2, "(n != 1)"));
        info.put("pap", new PluralInfo(2, "(n != 1)"));
        info.put("pl", new PluralInfo(3, "(n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("pms", new PluralInfo(2, "(n != 1)"));
        info.put("pt", new PluralInfo(2, "(n != 1)"));
        info.put("rm", new PluralInfo(2, "(n!=1)"));
        info.put("ro", new PluralInfo(3, "(n==1 ? 0 : (n==0 || (n%100 > 0 && n%100 < 20)) ? 1 : 2)"));
        info.put("ru", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("rw", new PluralInfo(2, "(n != 1)"));
        info.put("sah", new PluralInfo(1, "0"));
        info.put("sat", new PluralInfo(2, "(n != 1)"));
        info.put("sco", new PluralInfo(2, "(n != 1)"));
        info.put("sd", new PluralInfo(2, "(n != 1)"));
        info.put("si", new PluralInfo(2, "(n != 1)"));
        info.put("sk", new PluralInfo(3, "(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2"));
        info.put("sl", new PluralInfo(4, "(n%100==1 ? 1 : n%100==2 ? 2 : n%100==3 || n%100==4 ? 3 : 0)"));
        info.put("so", new PluralInfo(2, "n != 1"));
        info.put("son", new PluralInfo(2, "(n != 1)"));
        info.put("sq", new PluralInfo(2, "(n != 1)"));
        info.put("sr", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("su", new PluralInfo(1, "0"));
        info.put("sw", new PluralInfo(2, "(n != 1)"));
        info.put("sv", new PluralInfo(2, "(n != 1)"));
        info.put("ta", new PluralInfo(2, "(n != 1)"));
        info.put("te", new PluralInfo(2, "(n != 1)"));
        info.put("tg", new PluralInfo(2, "(n > 1)"));
        info.put("ti", new PluralInfo(2, "n > 1"));
        info.put("th", new PluralInfo(1, "0"));
        info.put("tk", new PluralInfo(2, "(n != 1)"));
        info.put("tr", new PluralInfo(2, "(n>1)"));
        info.put("tt", new PluralInfo(1, "0"));
        info.put("ug", new PluralInfo(1, "0"));
        info.put("uk", new PluralInfo(3, "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"));
        info.put("ur", new PluralInfo(2, "(n != 1)"));
        info.put("uz", new PluralInfo(2, "(n > 1)"));
        info.put("vi", new PluralInfo(1, "0"));
        info.put("wa", new PluralInfo(2, "(n > 1)"));
        info.put("wo", new PluralInfo(1, "0"));
        info.put("yo", new PluralInfo(2, "(n != 1)"));
        info.put("zh", new PluralInfo(1, "0 "));
        pluralInfos = Collections.unmodifiableMap(info);
        allowBlank = false;
        skipHeader = false;
        autoFillInPluralStatement = false;
        COMMENT_FUZZY = Pattern.compile("#, fuzzy");
        COMMENT_FUZZY_OTHER = Pattern.compile("#,.* fuzzy.*");
        COMMENT_NOWRAP = Pattern.compile("#,.* no-wrap.*");
        COMMENT_TRANSLATOR = Pattern.compile("# (.*)");
        COMMENT_EXTRACTED = Pattern.compile("#\\. (.*)");
        COMMENT_REFERENCE = Pattern.compile("#: (.*)");
        MSG_ID = Pattern.compile("msgid(_plural)?\\s+\"(.*)\"");
        MSG_STR = Pattern.compile("msgstr(\\[([0-9]+)\\])?\\s+\"(.*)\"");
        MSG_CTX = Pattern.compile("msgctxt\\s+\"(.*)\"");
        MSG_OTHER = Pattern.compile("\"(.*)\"");
        R1 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\\"");
        R2 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\n");
        R3 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\t");
        R4 = Pattern.compile("^\\\\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        MSGID,
        MSGSTR,
        MSGID_PLURAL,
        MSGSTR_PLURAL,
        MSGCTX;

    }

    private static class PluralInfo {
        public int plurals;
        public String expression;

        public PluralInfo(int nrOfPlurals, String pluralExpression) {
            this.plurals = nrOfPlurals;
            this.expression = pluralExpression;
        }
    }
}

