/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginUtils {
    protected static List<Class<?>> filterClasses = new ArrayList();
    protected static List<Class<?>> tokenizerClasses = new ArrayList();
    protected static List<Class<?>> markerClasses = new ArrayList();
    protected static List<Class<?>> machineTranslationClasses = new ArrayList();
    protected static List<Class<?>> glossaryClasses = new ArrayList();
    protected static List<Class<?>> basePluginClasses = new ArrayList();

    private PluginUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Map<String, String> params) {
        block17: {
            File pluginsDir = new File(StaticUtils.installDir(), "plugins");
            File homePluginsDir = new File(StaticUtils.getConfigDir(), "plugins");
            try {
                List<File> fs = FileUtil.findFiles(pluginsDir, new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                });
                List<File> fsHome = FileUtil.findFiles(homePluginsDir, new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".jar");
                    }
                });
                fs.addAll(fsHome);
                URL[] urls = new URL[fs.size()];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = fs.get(i).toURI().toURL();
                }
                boolean foundMain = false;
                URLClassLoader cls = new URLClassLoader(urls, PluginUtils.class.getClassLoader());
                Enumeration<URL> mlist = cls.getResources("META-INF/MANIFEST.MF");
                while (mlist.hasMoreElements()) {
                    Manifest m;
                    URL mu = mlist.nextElement();
                    InputStream in = mu.openStream();
                    try {
                        m = new Manifest(in);
                    }
                    finally {
                        in.close();
                    }
                    if ("org.omegat.Main".equals(m.getMainAttributes().getValue("Main-Class"))) {
                        foundMain = true;
                    }
                    PluginUtils.loadFromManifest(m, cls);
                }
                if (foundMain) break block17;
                String manifests = params.get("dev-manifests");
                if (manifests == null) {
                    manifests = "manifest-template.mf";
                }
                for (String mf : manifests.split(File.pathSeparator)) {
                    Manifest m;
                    FileInputStream in = new FileInputStream(mf);
                    try {
                        m = new Manifest(in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    PluginUtils.loadFromManifest(m, cls);
                }
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        for (Class<?> pl : basePluginClasses) {
            try {
                pl.newInstance();
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public static List<Class<?>> getFilterClasses() {
        return filterClasses;
    }

    public static List<Class<?>> getTokenizerClasses() {
        return tokenizerClasses;
    }

    public static List<Class<?>> getMarkerClasses() {
        return markerClasses;
    }

    public static List<Class<?>> getMachineTranslationClasses() {
        return machineTranslationClasses;
    }

    public static List<Class<?>> getGlossaryClasses() {
        return glossaryClasses;
    }

    protected static void loadFromManifest(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        if (m.getMainAttributes().getValue("OmegaT-Plugin") == null) {
            return;
        }
        Map<String, Attributes> entries = m.getEntries();
        block10: for (String key : entries.keySet()) {
            PLUGIN_TYPE pType;
            Attributes attrs = entries.get(key);
            String sType = attrs.getValue("OmegaT-Plugin");
            if ("true".equals(attrs.getValue("OmegaT-Tokenizer"))) {
                sType = "tokenizer";
            }
            if (sType == null) continue;
            try {
                pType = PLUGIN_TYPE.valueOf(sType.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                pType = PLUGIN_TYPE.UNKNOWN;
            }
            switch (pType) {
                case FILTER: {
                    filterClasses.add(classLoader.loadClass(key));
                    continue block10;
                }
                case TOKENIZER: {
                    tokenizerClasses.add(classLoader.loadClass(key));
                    continue block10;
                }
                case MARKER: {
                    markerClasses.add(classLoader.loadClass(key));
                    continue block10;
                }
                case MACHINETRANSLATOR: {
                    machineTranslationClasses.add(classLoader.loadClass(key));
                    continue block10;
                }
                case BASE: {
                    basePluginClasses.add(classLoader.loadClass(key));
                    continue block10;
                }
                case GLOSSARY: {
                    glossaryClasses.add(classLoader.loadClass(key));
                    continue block10;
                }
            }
            Log.logErrorRB("PLUGIN_UNKNOWN", key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PLUGIN_TYPE {
        FILTER,
        TOKENIZER,
        MARKER,
        MACHINETRANSLATOR,
        BASE,
        GLOSSARY,
        UNKNOWN;

    }
}

