/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltersTableModel
extends AbstractTableModel {
    private final List<Filter> filters;
    private final Map<String, String> filterNames = new TreeMap<String, String>();

    public FiltersTableModel(Filters config) {
        this.filters = new ArrayList<Filter>();
        for (Filter f : config.getFilters()) {
            IFilter fi = FilterMaster.getFilterInstance(f.getClassName());
            if (fi == null) continue;
            this.filters.add(f);
            this.filterNames.put(f.getClassName(), fi.getFileFormatName());
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return OStrings.getString("FILTERS_FILE_FORMAT");
            }
            case 1: {
                return OStrings.getString("FILTERS_ON");
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.filters.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Filter filter = this.filters.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.filterNames.get(filter.getClassName());
            }
            case 1: {
                return new Boolean(filter.isEnabled());
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Filter filter = this.filters.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                filter.setEnabled((Boolean)aValue);
                break;
            }
            default: {
                throw new IllegalArgumentException(OStrings.getString("FILTERS_ERROR_COLUMN_INDEX_NOT_1"));
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }
}

