/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import gen.core.filters.Files;
import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.ITranslateCallback;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.LFileCopy;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMaster {
    private static final String FILE_FILTERS = "filters.xml";
    private static final JAXBContext CONFIG_CTX;
    public static String INITIAL_VERSION;
    public static String OT160RC12a_VERSION;
    public static String OT160FINAL_VERSION;
    public static String OT161_VERSION;
    public static String OT170_VERSION;
    public static String CURRENT_VERSION;
    private final Filters config;
    private static List<Class<IFilter>> filtersClasses;
    private static List<String> supportedEncodings;

    public FilterMaster(Filters config) {
        this.config = config;
    }

    private static boolean addNewFiltersToConfig(Filters conf) {
        boolean result = false;
        for (Class<IFilter> fclass : filtersClasses) {
            boolean found = false;
            for (Filter fc : conf.getFilters()) {
                if (!fclass.getName().equals(fc.getClassName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            conf.getFilters().add(FilterMaster.getDefaultSettingsFromFilter(fclass.getName()));
            result = true;
        }
        return result;
    }

    public static IFilter getFilterInstance(String classname) {
        for (Class<IFilter> f : filtersClasses) {
            if (!f.getName().equals(classname)) continue;
            try {
                return f.newInstance();
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        return null;
    }

    public IFilter loadFile(String filename, FilterContext fc, IParseCallback parseCallback) throws IOException, TranslationException {
        IFilter filterObject = null;
        try {
            LookupInformation lookup = this.lookupFilter(filename, fc);
            if (lookup == null) {
                return null;
            }
            File inFile = new File(filename);
            fc.setInEncoding(lookup.outFilesInfo.getSourceEncoding());
            fc.setOutEncoding(lookup.outFilesInfo.getTargetEncoding());
            filterObject = lookup.filterObject;
            filterObject.parseFile(inFile, lookup.config, fc, parseCallback);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new IOException(filename + "\n" + ioe);
        }
        return filterObject;
    }

    public void translateFile(String sourcedir, String filename, String targetdir, FilterContext fc, ITranslateCallback translateCallback) throws IOException, TranslationException {
        LookupInformation lookup = this.lookupFilter(sourcedir + File.separator + filename, fc);
        if (lookup == null) {
            LFileCopy.copy(sourcedir + File.separator + filename, targetdir + File.separator + filename);
            return;
        }
        File inFile = new File(sourcedir + File.separator + filename);
        String name = inFile.getName();
        String path = filename.substring(0, filename.length() - name.length());
        File outFile = new File(targetdir + File.separator + path + File.separator + this.constructTargetFilename(lookup.outFilesInfo.getSourceFilenameMask(), name, lookup.outFilesInfo.getTargetFilenamePattern(), fc.getTargetLang(), lookup.outFilesInfo.getSourceEncoding(), lookup.outFilesInfo.getTargetEncoding(), lookup.filterObject.getFileFormatName()));
        fc.setInEncoding(lookup.outFilesInfo.getSourceEncoding());
        fc.setOutEncoding(lookup.outFilesInfo.getTargetEncoding());
        IFilter filterObject = lookup.filterObject;
        try {
            filterObject.translateFile(inFile, outFile, lookup.config, fc, translateCallback);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public void alignFile(String sourceDir, String fileName, String targetdir, FilterContext fc, IAlignCallback alignCallback) throws Exception {
        LookupInformation lookup = this.lookupFilter(sourceDir + File.separator + fileName, fc);
        if (lookup == null) {
            return;
        }
        File inFile = new File(sourceDir + File.separator + fileName);
        String name = inFile.getName();
        String path = fileName.substring(0, fileName.length() - name.length());
        File outFile = new File(targetdir + File.separator + path + File.separator + this.constructTargetFilename(lookup.outFilesInfo.getSourceFilenameMask(), name, lookup.outFilesInfo.getTargetFilenamePattern(), fc.getTargetLang(), lookup.outFilesInfo.getSourceEncoding(), lookup.outFilesInfo.getTargetEncoding(), lookup.filterObject.getFileFormatName()));
        if (!outFile.exists()) {
            return;
        }
        fc.setInEncoding(lookup.outFilesInfo.getSourceEncoding());
        fc.setOutEncoding(lookup.outFilesInfo.getTargetEncoding());
        IFilter filterObject = lookup.filterObject;
        try {
            filterObject.alignFile(inFile, outFile, lookup.config, fc, alignCallback);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    private LookupInformation lookupFilter(String filename, FilterContext fc) throws TranslationException, IOException {
        File inFile = new File(filename);
        String name = inFile.getName();
        String path = inFile.getParent();
        if (path == null) {
            path = "";
        }
        block0: for (Filter f : this.config.getFilters()) {
            if (!f.isEnabled()) continue;
            for (Files ff : f.getFiles()) {
                IFilter filterObject;
                if (!this.matchesMask(name, ff.getSourceFilenameMask()) || (filterObject = FilterMaster.getFilterInstance(f.getClassName())) == null) continue;
                fc.setInEncoding(ff.getSourceEncoding());
                fc.setOutEncoding(ff.getTargetEncoding());
                Map<String, String> config = FilterMaster.forFilter(f.getOption());
                if (!filterObject.isFileSupported(inFile, config, fc)) continue block0;
                return new LookupInformation(filterObject, ff, config);
            }
        }
        return null;
    }

    public static List<String> getSupportedEncodings() {
        if (supportedEncodings == null) {
            supportedEncodings = new ArrayList<String>();
            supportedEncodings.add(AbstractFilter.ENCODING_AUTO_HUMAN);
            supportedEncodings.addAll(Charset.availableCharsets().keySet());
        }
        return supportedEncodings;
    }

    public static Filters createDefaultFiltersConfig() {
        Filters c = new Filters();
        FilterMaster.addNewFiltersToConfig(c);
        return c;
    }

    public static Filters loadConfig(String configDir) {
        Filters result;
        File configFile = new File(configDir + FILE_FILTERS);
        if (!configFile.exists()) {
            return null;
        }
        try {
            Unmarshaller unm = CONFIG_CTX.createUnmarshaller();
            result = (Filters)unm.unmarshal(configFile);
        }
        catch (Exception e) {
            Log.logErrorRB("FILTERMASTER_ERROR_LOADING_FILTERS_CONFIG", new Object[0]);
            Log.log(e);
            result = new Filters();
        }
        if (FilterMaster.addNewFiltersToConfig(result)) {
            FilterMaster.saveConfig(result, configDir);
        }
        return result;
    }

    public static void saveConfig(Filters config, String configDir) {
        File configFile = new File(configDir + FILE_FILTERS);
        if (config == null) {
            configFile.delete();
            return;
        }
        try {
            Marshaller m = CONFIG_CTX.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)config, configFile);
        }
        catch (Exception e) {
            Log.logErrorRB("FILTERMASTER_ERROR_SAVING_FILTERS_CONFIG", new Object[0]);
            Log.log(e);
            JOptionPane.showMessageDialog(null, OStrings.getString("FILTERMASTER_ERROR_SAVING_FILTERS_CONFIG") + "\n" + e, OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private boolean matchesMask(String filename, String mask) {
        mask = mask.replaceAll("\\.", "\\\\.");
        mask = mask.replaceAll("\\*", ".*");
        mask = mask.replaceAll("\\?", ".");
        return filename.matches("(?iu)" + mask);
    }

    public static String now(String dateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(cal.getTime());
    }

    private String constructTargetFilename(String sourceMask, String filename, String pattern, Language targetLang, String sourceEncoding, String targetEncoding, String filterFormatName) {
        int lastStarPos = sourceMask.lastIndexOf(42);
        int dot = 0;
        if (lastStarPos >= 0) {
            int lastDotPos = sourceMask.indexOf(46, lastStarPos);
            int extlength = sourceMask.length() - lastDotPos;
            dot = filename.length() - extlength;
        } else {
            dot = filename.lastIndexOf(46);
        }
        String nameOnly = filename;
        String extension = "";
        if (dot >= 0) {
            nameOnly = filename.substring(0, dot);
            extension = filename.substring(dot + 1);
        }
        String res = pattern;
        res = res.replace("${filename}", filename);
        res = res.replace("${nameOnly}", nameOnly);
        res = res.replace("${extension}", extension);
        res = res.replace("${targetLocale}", targetLang.getLocaleCode());
        res = res.replace("${targetLanguage}", targetLang.getLanguage());
        res = res.replace("${targetLanguageCode}", targetLang.getLanguageCode());
        res = res.replace("${targetCountryCode}", targetLang.getCountryCode());
        res = res.replace("${targetCoutryCode}", targetLang.getCountryCode());
        res = res.replace("${targetLocaleLCID}", targetLang.getLocaleLCID());
        res = res.replace("${timestamp-a}", FilterMaster.now("a"));
        res = res.replace("${timestamp-d}", FilterMaster.now("d"));
        res = res.replace("${timestamp-dd}", FilterMaster.now("dd"));
        res = res.replace("${timestamp-h}", FilterMaster.now("h"));
        res = res.replace("${timestamp-hh}", FilterMaster.now("hh"));
        res = res.replace("${timestamp-m}", FilterMaster.now("m"));
        res = res.replace("${timestamp-mm}", FilterMaster.now("mm"));
        res = res.replace("${timestamp-s}", FilterMaster.now("s"));
        res = res.replace("${timestamp-ss}", FilterMaster.now("ss"));
        res = res.replace("${timestamp-yyyy}", FilterMaster.now("yyyy"));
        res = res.replace("${timestamp-D}", FilterMaster.now("D"));
        res = res.replace("${timestamp-EEE}", FilterMaster.now("EEE"));
        res = res.replace("${timestamp-EEEE}", FilterMaster.now("EEEE"));
        res = res.replace("${timestamp-H}", FilterMaster.now("H"));
        res = res.replace("${timestamp-HH}", FilterMaster.now("HH"));
        res = res.replace("${timestamp-M}", FilterMaster.now("M"));
        res = res.replace("${timestamp-MM}", FilterMaster.now("MM"));
        res = res.replace("${timestamp-MMM}", FilterMaster.now("MMM"));
        res = res.replace("${system-os-name}", System.getProperty("os.name"));
        res = res.replace("${system-os-version}", System.getProperty("os.arch"));
        res = res.replace("${system-os-arch}", System.getProperty("os.version"));
        res = res.replace("${system-user-name}", System.getProperty("user.name"));
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            hostName = "";
        }
        res = res.replace("${system-host-name}", hostName);
        String sourceEncodingText = "auto";
        if (sourceEncoding != null) {
            sourceEncodingText = sourceEncoding;
        }
        res = res.replace("${file-source-encoding}", sourceEncodingText);
        String targetEncodingText = "auto";
        if (targetEncoding != null) {
            targetEncodingText = targetEncoding;
        }
        res = res.replace("${file-target-encoding}", targetEncodingText);
        res = res.replace("${file-filter-name}", filterFormatName);
        String sourceMaskPattern = sourceMask.replaceAll("\\?", "(.)").replaceAll("\\*", "(.*?)");
        Matcher sourceMatcher = Pattern.compile(sourceMaskPattern).matcher(filename);
        if (sourceMatcher.find()) {
            for (int i = 1; i <= sourceMatcher.groupCount(); ++i) {
                res = res.replaceAll("\\$\\{" + i + "\\}", sourceMatcher.group(i));
            }
        }
        String[] splitName = filename.split("\\.");
        StringBuffer nameOnlyBuf = new StringBuffer(splitName[0]);
        StringBuffer extensionBuf = new StringBuffer(splitName[splitName.length - 1]);
        for (int i = 0; i < splitName.length; ++i) {
            res = res.replaceAll("\\$\\{nameOnly-" + i + "\\}", nameOnlyBuf.toString());
            res = res.replaceAll("\\$\\{extension-" + i + "\\}", extensionBuf.toString());
            if (i + 1 >= splitName.length) continue;
            nameOnlyBuf.append(".").append(splitName[i + 1]);
            extensionBuf.insert(0, splitName[splitName.length - i - 2] + '.');
        }
        return res;
    }

    public static Filters cloneConfig(Filters orig) {
        Filters c = new Filters();
        for (Filter f : orig.getFilters()) {
            c.getFilters().add(FilterMaster.cloneFilter(f));
        }
        return c;
    }

    public static Filter cloneFilter(Filter filter) {
        Filter f = new Filter();
        f.setClassName(filter.getClassName());
        f.setEnabled(filter.isEnabled());
        for (Files ff : filter.getFiles()) {
            f.getFiles().add(FilterMaster.cloneFiles(ff));
        }
        for (Filter.Option o : filter.getOption()) {
            Filter.Option fo = new Filter.Option();
            fo.setName(o.getName());
            fo.setValue(o.getValue());
            f.getOption().add(fo);
        }
        return f;
    }

    private static Files cloneFiles(Files files) {
        Files ff = new Files();
        ff.setSourceEncoding(files.getSourceEncoding());
        ff.setSourceFilenameMask(files.getSourceFilenameMask());
        ff.setTargetEncoding(files.getTargetEncoding());
        ff.setTargetFilenamePattern(files.getTargetFilenamePattern());
        return ff;
    }

    public static Filter getDefaultSettingsFromFilter(String filterClassname) {
        IFilter f = FilterMaster.getFilterInstance(filterClassname);
        Filter fc = new Filter();
        fc.setClassName(f.getClass().getName());
        fc.setEnabled(true);
        for (Instance ins : f.getDefaultInstances()) {
            Files ff = new Files();
            ff.setSourceEncoding(ins.getSourceEncoding());
            ff.setSourceFilenameMask(ins.getSourceFilenameMask());
            ff.setTargetEncoding(ins.getTargetEncoding());
            ff.setTargetFilenamePattern(ins.getTargetFilenamePattern());
            fc.getFiles().add(ff);
        }
        return fc;
    }

    public static Map<String, String> forFilter(List<Filter.Option> options) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Filter.Option opt : options) {
            result.put(opt.getName(), opt.getValue());
        }
        return result;
    }

    public static void setOptions(Filter f, Map<String, String> newOptions) {
        f.getOption().clear();
        for (Map.Entry<String, String> en : newOptions.entrySet()) {
            Filter.Option opt = new Filter.Option();
            opt.setName(en.getKey());
            opt.setValue(en.getValue());
            f.getOption().add(opt);
        }
    }

    static {
        INITIAL_VERSION = new String();
        OT160RC12a_VERSION = "1.6 RC12a";
        OT160FINAL_VERSION = "1.6.0";
        OT161_VERSION = "1.6.1";
        OT170_VERSION = "1.7.0";
        CURRENT_VERSION = "2.0";
        try {
            CONFIG_CTX = JAXBContext.newInstance((Class[])new Class[]{Filters.class});
            filtersClasses = new ArrayList<Class<IFilter>>();
            filtersClasses.addAll(PluginUtils.getFilterClasses());
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
        supportedEncodings = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LookupInformation {
        public final Files outFilesInfo;
        public final IFilter filterObject;
        public final Map<String, String> config;

        public LookupInformation(IFilter filterObject, Files outFilesInfo, Map<String, String> config) {
            this.filterObject = filterObject;
            this.outFilesInfo = outFilesInfo;
            this.config = config;
        }
    }
}

