/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.html2;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.regex.Matcher;
import org.omegat.filters2.html2.HTMLOptions;
import org.omegat.util.PatternConsts;

public class HTMLWriter
extends Writer {
    private StringWriter writer;
    private BufferedWriter realWriter;
    private String HTML_META;
    private String XML_HEADER;
    private String encoding;
    private HTMLOptions options;
    private final int minHeaderedBufferSize = 4096;
    private final int maxBufferSize = 65536;
    private boolean signalClosing = false;
    private boolean signalAlreadyFlushed = false;

    public HTMLWriter(String fileName, String encoding, HTMLOptions options) throws FileNotFoundException, UnsupportedEncodingException {
        this.encoding = encoding;
        this.options = options;
        this.writer = new StringWriter();
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter osw = encoding != null ? new OutputStreamWriter((OutputStream)fos, encoding) : new OutputStreamWriter(fos);
        this.realWriter = new BufferedWriter(osw);
    }

    public void close() throws IOException {
        this.signalClosing = true;
        this.flush();
        this.realWriter.close();
    }

    public void flush() throws IOException {
        StringBuffer buffer = this.writer.getBuffer();
        if (this.signalAlreadyFlushed || this.encoding == null) {
            this.realWriter.write(buffer.toString());
            buffer.setLength(0);
        } else if (this.signalClosing || buffer.length() >= 4096) {
            this.signalAlreadyFlushed = true;
            String contents = buffer.toString();
            if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.NEVER) {
                Matcher matcher_header = PatternConsts.XML_HEADER.matcher(contents);
                boolean xhtml = false;
                if (matcher_header.find()) {
                    this.XML_HEADER = "<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>";
                    contents = matcher_header.replaceFirst(this.XML_HEADER);
                    xhtml = true;
                }
                this.HTML_META = "<meta http-equiv=\"content-type\" content=\"text/html; charset=" + this.encoding + "\"";
                this.HTML_META = xhtml ? this.HTML_META + " />" : this.HTML_META + ">";
                Matcher matcher_enc = PatternConsts.HTML_ENCODING.matcher(contents);
                if (matcher_enc.find()) {
                    contents = matcher_enc.replaceFirst(this.HTML_META);
                } else if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.IFMETA) {
                    Matcher matcher_head = PatternConsts.HTML_HEAD.matcher(contents);
                    if (matcher_head.find()) {
                        contents = matcher_head.replaceFirst("<head>\n    " + this.HTML_META);
                    } else if (this.options.getRewriteEncoding() != HTMLOptions.REWRITE_MODE.IFHEADER) {
                        Matcher matcher_html = PatternConsts.HTML_HTML.matcher(contents);
                        contents = matcher_html.find() ? matcher_html.replaceFirst("<html>\n<head>\n    " + this.HTML_META + "\n</head>\n") : "<html>\n<head>\n    " + this.HTML_META + "\n</head>\n" + contents;
                    }
                }
            }
            this.realWriter.write(contents);
            buffer.setLength(0);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
        if (this.writer.getBuffer().length() >= 65536) {
            this.flush();
        }
    }
}

