/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2;

import java.awt.Dialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.ITranslateCallback;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilter
implements IFilter {
    public static String ENCODING_AUTO_HUMAN = OStrings.getString("ENCODING_AUTO");
    public static final String TFP_FILENAME = "${filename}";
    public static final String TFP_NAMEONLY = "${nameOnly}";
    public static final String TFP_EXTENSION = "${extension}";
    public static final String TFP_TARGET_LOCALE = "${targetLocale}";
    public static final String TFP_TARGET_LANGUAGE = "${targetLanguage}";
    public static final String TFP_TARGET_LANG_CODE = "${targetLanguageCode}";
    public static final String TFP_TARGET_COUNTRY_CODE = "${targetCountryCode}";
    public static final String TFP_TARGET_COUTRY_CODE = "${targetCoutryCode}";
    public static final String TFP_TIMESTAMP_LA = "${timestamp-a}";
    public static final String TFP_TIMESTAMP_LD = "${timestamp-d}";
    public static final String TFP_TIMESTAMP_LDD = "${timestamp-dd}";
    public static final String TFP_TIMESTAMP_LH = "${timestamp-h}";
    public static final String TFP_TIMESTAMP_LHH = "${timestamp-hh}";
    public static final String TFP_TIMESTAMP_LM = "${timestamp-m}";
    public static final String TFP_TIMESTAMP_LMM = "${timestamp-mm}";
    public static final String TFP_TIMESTAMP_LS = "${timestamp-s}";
    public static final String TFP_TIMESTAMP_LSS = "${timestamp-ss}";
    public static final String TFP_TIMESTAMP_LYYYY = "${timestamp-yyyy}";
    public static final String TFP_TIMESTAMP_UD = "${timestamp-D}";
    public static final String TFP_TIMESTAMP_UEEE = "${timestamp-EEE}";
    public static final String TFP_TIMESTAMP_UEEEE = "${timestamp-EEEE}";
    public static final String TFP_TIMESTAMP_UH = "${timestamp-H}";
    public static final String TFP_TIMESTAMP_UHH = "${timestamp-HH}";
    public static final String TFP_TIMESTAMP_UM = "${timestamp-M}";
    public static final String TFP_TIMESTAMP_UMM = "${timestamp-MM}";
    public static final String TFP_TIMESTAMP_UMMM = "${timestamp-MMM}";
    public static final String TFP_SYSTEM_OS_NAME = "${system-os-name}";
    public static final String TFP_SYSTEM_OS_VERSION = "${system-os-version}";
    public static final String TFP_SYSTEM_OS_ARCH = "${system-os-arch}";
    public static final String TFP_SYSTEM_USER_NAME = "${system-user-name}";
    public static final String TFP_SYSTEM_HOST_NAME = "${system-host-name}";
    public static final String TFP_FILE_SOURCE_ENCODING = "${file-source-encoding}";
    public static final String TFP_FILE_TARGET_ENCODING = "${file-target-encoding}";
    public static final String TFP_FILE_FILTER_NAME = "${file-filter-name}";
    public static final String TFP_TARGET_LOCALE_LCID = "${targetLocaleLCID}";
    protected String inEncodingLastParsedFile;
    public static final String[] TARGET_FILENAME_PATTERNS = new String[]{"${filename}", "${nameOnly}", "${extension}", "${targetLocale}", "${targetLocaleLCID}", "${targetLanguage}", "${targetLanguageCode}", "${targetCountryCode}", "${timestamp-a}", "${timestamp-d}", "${timestamp-dd}", "${timestamp-h}", "${timestamp-hh}", "${timestamp-m}", "${timestamp-mm}", "${timestamp-s}", "${timestamp-ss}", "${timestamp-yyyy}", "${timestamp-D}", "${timestamp-EEE}", "${timestamp-EEEE}", "${timestamp-H}", "${timestamp-HH}", "${timestamp-M}", "${timestamp-MM}", "${timestamp-MMM}", "${system-os-name}", "${system-os-version}", "${system-os-arch}", "${system-user-name}", "${system-host-name}", "${file-source-encoding}", "${file-target-encoding}", "${file-filter-name}"};
    protected IParseCallback entryParseCallback;
    protected ITranslateCallback entryTranslateCallback;
    protected IAlignCallback entryAlignCallback;
    protected Map<String, String> processOptions;
    public static String TARGET_DEFAULT = "${filename}";

    @Override
    public abstract String getFileFormatName();

    @Override
    public abstract Instance[] getDefaultInstances();

    @Override
    public abstract boolean isSourceEncodingVariable();

    @Override
    public abstract boolean isTargetEncodingVariable();

    protected boolean isFileSupported(BufferedReader reader) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext fc) {
        BufferedReader reader = null;
        try {
            reader = this.createReader(inFile, fc.getInEncoding());
            boolean bl = this.isFileSupported(reader);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String getFuzzyMark() {
        return "fuzzy";
    }

    @Override
    public String getHint() {
        return "";
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        return null;
    }

    protected BufferedReader createReader(File inFile, String inEncoding) throws UnsupportedEncodingException, IOException {
        InputStreamReader isr = inEncoding == null ? new InputStreamReader(new FileInputStream(inFile)) : new InputStreamReader((InputStream)new FileInputStream(inFile), inEncoding);
        return new BufferedReader(isr);
    }

    protected BufferedWriter createWriter(File outFile, String outEncoding) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter osw = outEncoding == null ? new OutputStreamWriter(new FileOutputStream(outFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), outEncoding);
        return new BufferedWriter(osw);
    }

    protected abstract void processFile(BufferedReader var1, BufferedWriter var2, FilterContext var3) throws IOException, TranslationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        this.inEncodingLastParsedFile = fc.getInEncoding();
        BufferedReader reader = this.createReader(inFile, this.inEncodingLastParsedFile);
        if (this.inEncodingLastParsedFile == null) {
            this.inEncodingLastParsedFile = Charset.defaultCharset().name();
        }
        try {
            BufferedWriter writer = outFile != null ? this.createWriter(outFile, fc.getOutEncoding()) : new NullBufferedWriter();
            try {
                this.processFile(reader, writer, fc);
            }
            finally {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void parseFile(File inFile, Map<String, String> config, FilterContext fc, IParseCallback callback) throws Exception {
        this.entryParseCallback = callback;
        this.entryTranslateCallback = null;
        this.entryAlignCallback = null;
        this.processOptions = config;
        try {
            this.processFile(inFile, null, fc);
            if (this.requirePrevNextFields()) {
                this.entryParseCallback.linkPrevNextSegments();
            }
        }
        finally {
            this.entryParseCallback = null;
            this.processOptions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void alignFile(File inFile, File outFile, Map<String, String> config, FilterContext fc, IAlignCallback callback) throws Exception {
        this.entryParseCallback = null;
        this.entryTranslateCallback = null;
        this.entryAlignCallback = callback;
        this.processOptions = config;
        BufferedReader readerIn = this.createReader(inFile, fc.getInEncoding());
        BufferedReader readerOut = this.createReader(outFile, fc.getOutEncoding());
        try {
            this.alignFile(readerIn, readerOut, fc);
        }
        finally {
            readerIn.close();
            readerOut.close();
        }
    }

    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
    }

    protected boolean requirePrevNextFields() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void translateFile(File inFile, File outFile, Map<String, String> config, FilterContext fc, ITranslateCallback callback) throws Exception {
        this.entryParseCallback = null;
        this.entryTranslateCallback = callback;
        this.entryAlignCallback = null;
        this.processOptions = config;
        try {
            this.entryTranslateCallback.setPass(1);
            this.processFile(inFile, outFile, fc);
            if (this.requirePrevNextFields()) {
                this.entryTranslateCallback.linkPrevNextSegments();
                this.entryTranslateCallback.setPass(2);
                this.processFile(inFile, outFile, fc);
            }
        }
        finally {
            this.entryTranslateCallback = null;
            this.processOptions = null;
        }
    }

    protected final String processEntry(String entry) {
        return this.processEntry(entry, null);
    }

    protected final String processEntry(String entry, String comment) {
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(null, entry, null, false, comment, null, this);
            return entry;
        }
        String translation = this.entryTranslateCallback.getTranslation(null, entry, null);
        return translation != null ? translation : entry;
    }

    public void setCallbacks(IParseCallback parseCallback, ITranslateCallback translateCallback) {
        this.entryParseCallback = parseCallback;
        this.entryTranslateCallback = translateCallback;
    }

    @Override
    public String getInEncodingLastParsedFile() {
        return this.inEncodingLastParsedFile;
    }
}

