/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.io.IOException;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.omegat.core.Core;
import org.omegat.core.search.SearchExpression;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.search.Searcher;
import org.omegat.filters2.TranslationException;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.Log;

public class SearchThread
extends Thread
implements Searcher.ISearchCheckStop {
    private boolean stopped;
    private SearchWindow m_window;
    private SearchExpression m_searchExpression;

    public SearchThread(SearchWindow window, String text, String rootDir, boolean recursive, boolean exact, boolean keyword, boolean regex, boolean caseSensitive, boolean tm, boolean allResults, boolean searchSource, boolean searchTarget, boolean searchNotes, boolean searchAuthor, String author, boolean searchDateAfter, long dateAfter, boolean searchDateBefore, long dateBefore, int numberOfResults) {
        this.m_window = window;
        this.m_searchExpression = new SearchExpression(text, rootDir, recursive, exact, keyword, regex, caseSensitive, tm, allResults, searchSource, searchTarget, searchNotes, searchAuthor, author, searchDateAfter, dateAfter, searchDateBefore, dateBefore, numberOfResults);
    }

    public void run() {
        try {
            try {
                List<SearchResultEntry> resultsList = new Searcher(Core.getProject(), this).getSearchResults(this.m_searchExpression);
                if (this.stopped) {
                    return;
                }
                this.m_window.displaySearchResult(resultsList);
            }
            catch (PatternSyntaxException e) {
                this.m_window.displayErrorRB(e, "ST_REGEXP_ERROR", new Object[0]);
            }
            catch (IOException e) {
                Log.logErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
                Core.getMainWindow().displayErrorRB(e, "ST_FILE_SEARCH_ERROR", new Object[0]);
            }
            catch (TranslationException te) {
                Log.logErrorRB(te, "ST_FILE_SEARCH_ERROR", new Object[0]);
                Core.getMainWindow().displayErrorRB(te, "ST_FILE_SEARCH_ERROR", new Object[0]);
            }
        }
        catch (RuntimeException re) {
            Log.logErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(re, "ST_FATAL_ERROR", new Object[0]);
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void fin() {
        this.stopped = true;
    }
}

