/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalcStandardStatistics
extends LongProcessThread {
    private static final String[] htHeaders = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters")};
    private static final String[] htRows = new String[]{OStrings.getString("CT_STATS_Total"), OStrings.getString("CT_STATS_Remaining"), OStrings.getString("CT_STATS_Unique"), OStrings.getString("CT_STATS_Unique_Remaining")};
    private static final boolean[] htAlign = new boolean[]{false, true, true, true, true};
    private static final String[] ftHeaders = new String[]{OStrings.getString("CT_STATS_FILE_Name"), OStrings.getString("CT_STATS_FILE_Total_Segments"), OStrings.getString("CT_STATS_FILE_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Total_Words"), OStrings.getString("CT_STATS_FILE_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Unique_Words"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Total_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Total_Characters"), OStrings.getString("CT_STATS_FILE_Remaining_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters")};
    private static final boolean[] ftAlign = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private StatisticsWindow callback;

    public CalcStandardStatistics(StatisticsWindow callback) {
        this.callback = callback;
    }

    @Override
    public void run() {
        IProject p = Core.getProject();
        String result = CalcStandardStatistics.buildProjectStats(p, null);
        this.callback.displayData(result, true);
        String internalDir = p.getProjectProperties().getProjectInternal();
        try {
            File oldstats = new File(internalDir + "word_counts");
            if (oldstats.exists()) {
                oldstats.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String fn = internalDir + "project_stats.txt";
        Statistics.writeStat(fn, result);
    }

    public static String buildProjectStats(IProject project, StatisticsInfo hotStat) {
        StatCount total = new StatCount();
        StatCount remaining = new StatCount();
        StatCount unique = new StatCount();
        StatCount remainingUnique = new StatCount();
        HashMap<String, Integer> uniqueSegment = new HashMap<String, Integer>();
        HashSet<String> translated = new HashSet<String>();
        for (SourceTextEntry ste : project.getAllEntries()) {
            TMXEntry tr;
            String src = ste.getSrcText();
            Integer count = (Integer)uniqueSegment.get(src);
            if (count == null) {
                uniqueSegment.put(src, 1);
            } else {
                uniqueSegment.put(src, count + 1);
            }
            if (!(tr = project.getTranslationInfo(ste)).isTranslated()) continue;
            translated.add(src);
        }
        for (String src : uniqueSegment.keySet()) {
            int words = Statistics.numberOfWords(src);
            String noTags = StaticUtils.stripTags(src);
            int charsNoSpaces = Statistics.numberOfCharactersWithoutSpaces(noTags);
            ++unique.segments;
            unique.words += words;
            unique.charsWithoutSpaces += charsNoSpaces;
            unique.charsWithSpaces += noTags.length();
            if (translated.contains(src)) continue;
            ++remainingUnique.segments;
            remainingUnique.words += words;
            remainingUnique.charsWithoutSpaces += charsNoSpaces;
            remainingUnique.charsWithSpaces += noTags.length();
        }
        ArrayList<FileData> counts = new ArrayList<FileData>();
        HashMap<String, Boolean> firstSeenUniqueSegment = new HashMap<String, Boolean>();
        for (IProject.FileInfo file : project.getProjectFiles()) {
            FileData numbers = new FileData();
            numbers.filename = file.filePath;
            counts.add(numbers);
            for (SourceTextEntry ste : file.entries) {
                String src = ste.getSrcText();
                int words = Statistics.numberOfWords(src);
                String noTags = StaticUtils.stripTags(src);
                int charsNoSpaces = Statistics.numberOfCharactersWithoutSpaces(noTags);
                int chars = noTags.length();
                ++total.segments;
                total.words += words;
                total.charsWithoutSpaces += charsNoSpaces;
                total.charsWithSpaces += chars;
                TMXEntry tr = project.getTranslationInfo(ste);
                if (!tr.isTranslated()) {
                    ++remaining.segments;
                    remaining.words += words;
                    remaining.charsWithoutSpaces += charsNoSpaces;
                    remaining.charsWithSpaces += chars;
                }
                ++numbers.total.segments;
                numbers.total.words += words;
                numbers.total.charsWithoutSpaces += charsNoSpaces;
                numbers.total.charsWithSpaces += chars;
                Integer uniqueCount = (Integer)uniqueSegment.get(src);
                Boolean firstSeen = (Boolean)firstSeenUniqueSegment.get(src);
                if (firstSeen == null) {
                    firstSeenUniqueSegment.put(src, false);
                    ++numbers.unique.segments;
                    numbers.unique.words += words;
                    numbers.unique.charsWithoutSpaces += charsNoSpaces;
                    numbers.unique.charsWithSpaces += chars;
                    if (!tr.isTranslated()) {
                        ++numbers.remainingUnique.segments;
                        numbers.remainingUnique.words += words;
                        numbers.remainingUnique.charsWithoutSpaces += charsNoSpaces;
                        numbers.remainingUnique.charsWithSpaces += chars;
                    }
                }
                if (tr.isTranslated()) continue;
                ++numbers.remaining.segments;
                numbers.remaining.words += words;
                numbers.remaining.charsWithoutSpaces += charsNoSpaces;
                numbers.remaining.charsWithSpaces += chars;
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(OStrings.getString("CT_STATS_Project_Statistics") + "\n\n");
        String[][] headerTable = CalcStandardStatistics.calcHeaderTable(new StatCount[]{total, remaining, unique, remainingUnique});
        result.append(TextUtil.showTextTable(htHeaders, headerTable, htAlign));
        result.append("\n\n");
        result.append(OStrings.getString("CT_STATS_FILE_Statistics") + "\n\n");
        String[][] filesTable = CalcStandardStatistics.calcFilesTable(project.getProjectProperties(), counts);
        result.append(TextUtil.showTextTable(ftHeaders, filesTable, ftAlign));
        if (hotStat != null) {
            hotStat.numberOfSegmentsTotal = total.segments;
            hotStat.numberofTranslatedSegments = translated.size();
            hotStat.numberOfUniqueSegments = unique.segments;
        }
        return result.toString();
    }

    protected static String[][] calcHeaderTable(StatCount[] result) {
        String[][] table = new String[result.length][5];
        for (int i = 0; i < result.length; ++i) {
            table[i][0] = htRows[i];
            table[i][1] = Integer.toString(result[i].segments);
            table[i][2] = Integer.toString(result[i].words);
            table[i][3] = Integer.toString(result[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(result[i].charsWithSpaces);
        }
        return table;
    }

    protected static String[][] calcFilesTable(ProjectProperties m_config, List<FileData> counts) {
        String[][] table = new String[counts.size()][17];
        int r = 0;
        for (FileData numbers : counts) {
            table[r][0] = StaticUtils.makeFilenameRelative(numbers.filename, m_config.getSourceRoot());
            table[r][1] = Integer.toString(numbers.total.segments);
            table[r][2] = Integer.toString(numbers.remaining.segments);
            table[r][3] = Integer.toString(numbers.unique.segments);
            table[r][4] = Integer.toString(numbers.remainingUnique.segments);
            table[r][5] = Integer.toString(numbers.total.words);
            table[r][6] = Integer.toString(numbers.remaining.words);
            table[r][7] = Integer.toString(numbers.unique.words);
            table[r][8] = Integer.toString(numbers.remainingUnique.words);
            table[r][9] = Integer.toString(numbers.total.charsWithoutSpaces);
            table[r][10] = Integer.toString(numbers.remaining.charsWithoutSpaces);
            table[r][11] = Integer.toString(numbers.unique.charsWithoutSpaces);
            table[r][12] = Integer.toString(numbers.remainingUnique.charsWithoutSpaces);
            table[r][13] = Integer.toString(numbers.total.charsWithSpaces);
            table[r][14] = Integer.toString(numbers.remaining.charsWithSpaces);
            table[r][15] = Integer.toString(numbers.unique.charsWithSpaces);
            table[r][16] = Integer.toString(numbers.remainingUnique.charsWithSpaces);
            ++r;
        }
        return table;
    }

    public static class FileData {
        public String filename;
        public StatCount total = new StatCount();
        public StatCount unique = new StatCount();
        public StatCount remaining = new StatCount();
        public StatCount remainingUnique = new StatCount();
    }
}

