/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.Token;
import org.omegat.util.gui.TextUtil;

public class CalcMatchStatistics
extends LongProcessThread {
    private String[] header = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters")};
    private String[] rows = new String[]{OStrings.getString("CT_STATSMATCH_RowRepetitions"), OStrings.getString("CT_STATSMATCH_RowExactMatch"), OStrings.getString("CT_STATSMATCH_RowMatch95"), OStrings.getString("CT_STATSMATCH_RowMatch85"), OStrings.getString("CT_STATSMATCH_RowMatch75"), OStrings.getString("CT_STATSMATCH_RowMatch50"), OStrings.getString("CT_STATSMATCH_RowNoMatch")};
    private boolean[] align = new boolean[]{false, true, true, true, true};
    private StatisticsWindow callback;
    private Map<String, Token[]> tokensCache = new HashMap<String, Token[]>();
    private Set<String> alreadyProcessed = new HashSet<String>();

    public CalcMatchStatistics(StatisticsWindow callback) {
        this.callback = callback;
    }

    public void run() {
        StatCount[] result = new StatCount[7];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new StatCount();
        }
        LevenshteinDistance distanceCalculator = new LevenshteinDistance();
        List<SourceTextEntry> allEntries = Core.getProject().getAllEntries();
        Map<String, Token[]> externalCache = Statistics.buildExternalSourceTexts(this.tokensCache);
        ArrayList<String> untranslatedEntries = new ArrayList<String>(allEntries.size() / 2);
        int percent = 0;
        int treated = 0;
        for (int i = 0; i < allEntries.size(); ++i) {
            SourceTextEntry ste = allEntries.get(i);
            boolean isFirst = this.alreadyProcessed.add(ste.getSrcText());
            if (Core.getProject().getTranslationInfo(ste).isTranslated()) {
                ++result[1].segments;
                result[1].words += Statistics.numberOfWords(ste.getSrcText());
                String charWithoutTags = StaticUtils.stripTags(ste.getSrcText());
                result[1].charsWithoutSpaces += Statistics.numberOfCharactersWithoutSpaces(charWithoutTags);
                result[1].charsWithSpaces += charWithoutTags.length();
                ++treated;
            } else if (!isFirst) {
                ++result[0].segments;
                result[0].words += Statistics.numberOfWords(ste.getSrcText());
                String charWithoutTags = StaticUtils.stripTags(ste.getSrcText());
                result[0].charsWithoutSpaces += Statistics.numberOfCharactersWithoutSpaces(charWithoutTags);
                result[0].charsWithSpaces += charWithoutTags.length();
                ++treated;
            } else {
                untranslatedEntries.add(ste.getSrcText());
            }
            if (this.isStopped) {
                return;
            }
            int newPercent = treated * 100 / allEntries.size();
            if (percent == newPercent) continue;
            this.callback.showProgress(newPercent);
            percent = newPercent;
        }
        String[][] table = this.calcTable(result, 2);
        String outText = TextUtil.showTextTable(this.header, table, this.align);
        this.callback.displayData(outText, false);
        for (int i = 0; i < untranslatedEntries.size(); ++i) {
            String source = (String)untranslatedEntries.get(i);
            Token[] strTokensStem = Statistics.tokenizeExactlyWithCache(this.tokensCache, source);
            int maxSimilarity = 0;
            for (Token[] candTokens : externalCache.values()) {
                int newSimilarity = FuzzyMatcher.calcSimilarity(distanceCalculator, strTokensStem, candTokens);
                if (newSimilarity <= maxSimilarity) continue;
                maxSimilarity = newSimilarity;
                if (newSimilarity < 95) continue;
                break;
            }
            int row = this.getRowByPercent(maxSimilarity);
            ++result[row].segments;
            result[row].words += Statistics.numberOfWords(source);
            String charWithoutTags = StaticUtils.stripTags(source);
            result[row].charsWithoutSpaces += Statistics.numberOfCharactersWithoutSpaces(charWithoutTags);
            result[row].charsWithSpaces += charWithoutTags.length();
            ++treated;
            if (this.isStopped) {
                return;
            }
            int newPercent = treated * 100 / allEntries.size();
            if (percent == newPercent) continue;
            this.callback.showProgress(newPercent);
            percent = newPercent;
        }
        table = this.calcTable(result, result.length);
        outText = TextUtil.showTextTable(this.header, table, this.align);
        this.callback.displayData(outText, true);
        String fn = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats_match.txt";
        Statistics.writeStat(fn, outText);
    }

    public int getRowByPercent(int percent) {
        if (percent == 102) {
            return 0;
        }
        if (percent == 101) {
            return 1;
        }
        if (percent >= 95) {
            return 2;
        }
        if (percent >= 85) {
            return 3;
        }
        if (percent >= 75) {
            return 4;
        }
        if (percent >= 50) {
            return 5;
        }
        return 6;
    }

    public String[][] calcTable(StatCount[] result, int rowsCount) {
        String[][] table = new String[rowsCount][5];
        for (int i = 0; i < rowsCount; ++i) {
            table[i][0] = this.rows[i];
            table[i][1] = Integer.toString(result[i].segments);
            table[i][2] = Integer.toString(result[i].words);
            table[i][3] = Integer.toString(result[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(result[i].charsWithSpaces);
        }
        return table;
    }
}

