/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.util.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellCheckerMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter PAINTER = new UnderlineFactory.WaveUnderline(Color.RED);

    @Override
    public Highlighter.HighlightPainter getPainter() {
        return PAINTER;
    }

    @Override
    public List<Mark> getMarksForEntry(String sourceText, String translationText, boolean isActive) throws Exception {
        if (translationText == null) {
            return null;
        }
        if (!Core.getEditor().getSettings().isAutoSpellChecking()) {
            return null;
        }
        ArrayList<Mark> result = new ArrayList<Mark>();
        for (Token tok : Core.getProject().getTargetTokenizer().tokenizeWordsForSpelling(translationText)) {
            int st = tok.getOffset();
            int en = tok.getOffset() + tok.getLength();
            String word = translationText.substring(st, en);
            if (Core.getSpellChecker().isCorrect(word)) continue;
            result.add(new Mark(Mark.ENTRY_PART.TRANSLATION, st, en));
        }
        return result;
    }
}

