/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.omegat.core.spellchecker.DictionaryFileNameFilter;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryManager {
    private File dir;

    public DictionaryManager(String dirName) {
        this.dir = new File(dirName);
    }

    public String getDirectory() {
        return this.dir.getAbsolutePath();
    }

    private String getFileNameOnly(String filename) {
        int position = filename.indexOf(".");
        if (position != -1) {
            return filename.substring(0, position);
        }
        return null;
    }

    public List<String> getDictionaryNameList(List<String> aList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String dic : aList) {
            String[] parts = dic.split("_");
            Locale locale = parts.length == 1 ? new Locale(parts[0]) : new Locale(parts[0], parts[1]);
            result.add(dic + " - " + locale.getDisplayName());
        }
        return result;
    }

    public List<String> getLocalDictionaryNameList() {
        return this.getDictionaryNameList(this.getLocalDictionaryCodeList());
    }

    public List<String> getLocalDictionaryCodeList() {
        ArrayList<String> result = new ArrayList<String>();
        String[] affixFiles = this.dir.list(new DictionaryFileNameFilter(".aff"));
        String[] dictionaryFiles = this.dir.list(new DictionaryFileNameFilter(".dic"));
        if (affixFiles != null && dictionaryFiles != null) {
            for (int i = 0; i < affixFiles.length; ++i) {
                boolean match = false;
                String affixName = this.getFileNameOnly(affixFiles[i]);
                if (affixName == null || affixName.equals("")) continue;
                for (int j = 0; j < dictionaryFiles.length; ++j) {
                    String dicName = this.getFileNameOnly(dictionaryFiles[j]);
                    if (dicName == null || dicName.equals("") || !affixName.equals(dicName)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                result.add(affixName);
            }
        }
        return result;
    }

    public boolean uninstallDictionary(String lang) {
        if (lang == null || lang.equals("")) {
            return false;
        }
        String base = this.getDirectory() + File.separator + lang;
        File affFile = new File(base + ".aff");
        if (!affFile.delete()) {
            return false;
        }
        File dicFile = new File(base + ".dic");
        return dicFile.delete();
    }

    public List<String> getInstallableDictionaryNameList() throws IOException {
        return this.getDictionaryNameList(this.getInstallableDictionaryCodeList());
    }

    public List<String> getInstallableDictionaryCodeList() throws IOException {
        List<String> localDicList = this.getLocalDictionaryCodeList();
        List<String> remoteDicList = this.getRemoteDictionaryCodeList();
        ArrayList<String> result = new ArrayList<String>();
        for (String dicCode : remoteDicList) {
            if (localDicList.contains(dicCode)) continue;
            result.add(dicCode);
        }
        return result;
    }

    private List<String> getRemoteDictionaryCodeList() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String htmlfile = StaticUtils.downloadFileToString(Preferences.getPreference("dictionary_url"));
        Matcher matcher = PatternConsts.DICTIONARY_ZIP.matcher(htmlfile);
        while (matcher.find()) {
            String match = matcher.group();
            int dotPosition = match.indexOf(".");
            result.add(match.substring(1, dotPosition));
        }
        return result;
    }

    public void installRemoteDictionary(String langCode) throws MalformedURLException, IOException {
        String from = Preferences.getPreference("dictionary_url") + "/" + langCode + ".zip";
        File tempFile = File.createTempFile(langCode, ".zip");
        String to = tempFile.getAbsolutePath();
        StaticUtils.downloadFileToDisk(from, to);
        int pos = langCode.indexOf("_1-3-2", 0);
        if (pos != -1) {
            langCode = langCode.substring(0, pos);
        }
        ArrayList<String> filenames = new ArrayList<String>();
        filenames.add(langCode + ".aff");
        filenames.add(langCode + ".dic");
        this.dir.mkdirs();
        StaticUtils.extractFileFromJar(to, filenames, this.dir.getAbsolutePath());
    }
}

