/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation.datamodels;

import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.table.AbstractTableModel;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingRulesModel
extends AbstractTableModel {
    private SRX srx;
    private static String[] COLUMN_NAMES = new String[]{OStrings.getString("CORE_SRX_TABLE_HEADER_Language_Name"), OStrings.getString("CORE_SRX_TABLE_HEADER_Language_Pattern")};
    protected List<ExceptionListener> listeners = new ArrayList<ExceptionListener>();

    public MappingRulesModel(SRX srx) {
        this.srx = srx;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MapRule maprule = this.srx.getMappingRules().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return maprule.getLanguage();
            }
            case 1: {
                return maprule.getPattern();
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.srx.getMappingRules().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        MapRule maprule = this.srx.getMappingRules().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                maprule.setLanguage((String)aValue);
                break;
            }
            case 1: {
                try {
                    maprule.setPattern((String)aValue);
                    break;
                }
                catch (PatternSyntaxException pse) {
                    this.fireException(pse);
                }
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    public int addRow() {
        int rows = this.srx.getMappingRules().size();
        this.srx.getMappingRules().add(new MapRule(OStrings.getString("SEG_NEW_LN_CO"), "LN-CO", new ArrayList<Rule>()));
        this.fireTableRowsInserted(rows, rows);
        return rows;
    }

    public void removeRow(int row) {
        this.srx.getMappingRules().remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void moveRowUp(int row) {
        MapRule maprulePrev = this.srx.getMappingRules().get(row - 1);
        MapRule maprule = this.srx.getMappingRules().get(row);
        this.srx.getMappingRules().remove(row - 1);
        this.srx.getMappingRules().add(row, maprulePrev);
        this.fireTableRowsUpdated(row - 1, row);
    }

    public void moveRowDown(int row) {
        MapRule mapruleNext = this.srx.getMappingRules().get(row + 1);
        MapRule maprule = this.srx.getMappingRules().get(row);
        this.srx.getMappingRules().remove(row + 1);
        this.srx.getMappingRules().add(row, mapruleNext);
        this.fireTableRowsUpdated(row, row + 1);
    }

    public void addExceptionListener(ExceptionListener l) {
        this.listeners.add(l);
    }

    public void removeTableModelListener(ExceptionListener l) {
        this.listeners.remove(l);
    }

    public void fireException(Exception e) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ExceptionListener l = this.listeners.get(i);
            l.exceptionThrown(e);
        }
    }
}

