/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.SearchExpression;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Searcher {
    private List<SearchResultEntry> m_searchResults;
    private IProject m_project;
    private String m_searchDir;
    private boolean m_searchRecursive;
    private boolean m_tmSearch;
    private boolean m_allResults;
    private boolean m_searchSource;
    private boolean m_searchTarget;
    private boolean m_searchNotes;
    private boolean m_searchAuthor;
    private boolean m_searchDateAfter;
    private boolean m_searchDateBefore;
    private Set<String> m_entrySet;
    private List<Matcher> m_matchers;
    private Matcher m_author;
    private long m_dateBefore;
    private long m_dateAfter;
    private int m_numFinds;
    private int m_maxResults;
    private final ISearchCheckStop stopCallback;
    private final List<SearchMatch> foundMatches = new ArrayList<SearchMatch>();

    public Searcher(IProject project, ISearchCheckStop stopCallback) {
        this.m_project = project;
        this.stopCallback = stopCallback;
    }

    public List<SearchResultEntry> getSearchResults(SearchExpression expression) throws TranslationException, PatternSyntaxException, IOException {
        int flags;
        String text = expression.text;
        String author = expression.author;
        this.m_searchResults = new ArrayList<SearchResultEntry>();
        this.m_numFinds = 0;
        this.m_entrySet = null;
        this.m_maxResults = expression.numberOfResults;
        this.m_searchDir = expression.rootDir;
        this.m_searchRecursive = expression.recursive;
        this.m_tmSearch = expression.tm;
        this.m_allResults = expression.allResults;
        this.m_searchSource = expression.searchSource;
        this.m_searchTarget = expression.searchTarget;
        this.m_searchNotes = expression.searchNotes;
        this.m_searchAuthor = expression.searchAuthor;
        this.m_searchDateAfter = expression.searchDateAfter;
        this.m_searchDateBefore = expression.searchDateBefore;
        this.m_entrySet = new HashSet<String>();
        this.m_matchers = new ArrayList<Matcher>();
        int n = flags = expression.caseSensitive ? 0 : 66;
        if (expression.exact) {
            text = StaticUtils.escapeNonRegex(text, false);
            this.m_matchers.add(Pattern.compile(text, flags).matcher(""));
        } else if (expression.regex) {
            this.m_matchers.add(Pattern.compile(text, flags).matcher(""));
        } else if ((text = text.trim()).length() > 0) {
            int wordStart = 0;
            while (wordStart < text.length()) {
                String word;
                int spacePos = text.indexOf(32, wordStart);
                String string = word = spacePos == -1 ? text.substring(wordStart, text.length()).trim() : text.substring(wordStart, spacePos).trim();
                if (word.length() > 0) {
                    if (!expression.regex) {
                        word = StaticUtils.escapeNonRegex(word, false);
                    }
                    this.m_matchers.add(Pattern.compile(word, flags).matcher(""));
                }
                wordStart = spacePos == -1 ? text.length() : spacePos + 1;
            }
        }
        if (!expression.regex) {
            author = StaticUtils.escapeNonRegex(author, false);
        }
        this.m_author = Pattern.compile(author, flags).matcher("");
        this.m_dateBefore = expression.dateBefore;
        this.m_dateAfter = expression.dateAfter;
        if (this.m_searchDir == null) {
            this.searchProject();
        } else {
            this.searchFiles();
        }
        return this.m_searchResults;
    }

    private void addEntry(int num, String preamble, String srcPrefix, String src, String target, SearchMatch[] srcMatch, SearchMatch[] targetMatch) {
        SearchResultEntry entry = new SearchResultEntry(num, preamble, srcPrefix, src, target, srcMatch, targetMatch);
        this.m_searchResults.add(entry);
        ++this.m_numFinds;
    }

    private void foundString(int entryNum, String intro, String src, String target, SearchMatch[] srcMatches, SearchMatch[] targetMatches) {
        if (this.m_numFinds >= this.m_maxResults) {
            return;
        }
        if (entryNum >= 0) {
            if (!this.m_entrySet.contains(src + target) || this.m_allResults) {
                this.addEntry(entryNum + 1, null, entryNum + 1 + "> ", src, target, srcMatches, targetMatches);
                if (!this.m_allResults) {
                    this.m_entrySet.add(src + target);
                }
            }
        } else {
            this.addEntry(entryNum, intro, null, src, target, srcMatches, targetMatches);
        }
    }

    private void searchProject() {
        this.m_numFinds = 0;
        IProject dataEngine = this.m_project;
        for (int i = 0; i < this.m_project.getAllEntries().size() && this.m_numFinds < this.m_maxResults; ++i) {
            SourceTextEntry sourceTextEntry = dataEngine.getAllEntries().get(i);
            String srcText = sourceTextEntry.getSrcText();
            TMXEntry te = this.m_project.getTranslationInfo(sourceTextEntry);
            String locText = te.isTranslated() ? te.translation : "";
            this.checkEntry(srcText, locText, te, i, null);
            if (!this.stopCallback.isStopped()) continue;
            return;
        }
        if (this.m_tmSearch) {
            this.m_project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){
                final String file = OStrings.getString("CT_ORPHAN_STRINGS");

                public void iterate(String source, TMXEntry en) {
                    if (Searcher.this.m_numFinds >= Searcher.this.m_maxResults) {
                        return;
                    }
                    if (Searcher.this.stopCallback.isStopped()) {
                        return;
                    }
                    if (Searcher.this.m_project.isOrphaned(source)) {
                        Searcher.this.checkEntry(en.source, en.translation, en, -1, this.file);
                    }
                }
            });
            this.m_project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){
                final String file = OStrings.getString("CT_ORPHAN_STRINGS");

                public void iterate(EntryKey source, TMXEntry en) {
                    if (Searcher.this.m_numFinds >= Searcher.this.m_maxResults) {
                        return;
                    }
                    if (Searcher.this.stopCallback.isStopped()) {
                        return;
                    }
                    if (Searcher.this.m_project.isOrphaned(source)) {
                        Searcher.this.checkEntry(en.source, en.translation, en, -1, this.file);
                    }
                }
            });
            if (!(this.m_searchAuthor || this.m_searchDateAfter || this.m_searchDateBefore)) {
                for (Map.Entry<String, ExternalTMX> entry : this.m_project.getTransMemories().entrySet()) {
                    String fileTM = entry.getKey();
                    if (this.searchEntries(entry.getValue().getEntries(), fileTM, false)) continue;
                    return;
                }
                for (Map.Entry<Object, Object> entry : this.m_project.getOtherTargetLanguageTMs().entrySet()) {
                    Language langTM = (Language)entry.getKey();
                    if (!this.searchEntries(((ProjectTMX)entry.getValue()).getDefaults(), langTM.getLanguage(), true)) {
                        return;
                    }
                    if (this.searchEntries(((ProjectTMX)entry.getValue()).getAlternatives(), langTM.getLanguage(), true)) continue;
                    return;
                }
            }
        }
    }

    private boolean searchEntries(Collection<TMXEntry> tmEn, String tmxID, boolean isAlternativeSource) {
        for (TMXEntry tm : tmEn) {
            if (this.m_numFinds >= this.m_maxResults) {
                return false;
            }
            this.checkEntry(tm.source, tm.translation, null, -1, tmxID);
            if (!this.stopCallback.isStopped()) continue;
            return false;
        }
        return true;
    }

    protected void checkEntry(String srcText, String locText, TMXEntry entry, int entryNum, String intro) {
        SearchMatch[] srcMatches = null;
        if (this.m_searchSource && this.searchString(srcText)) {
            srcMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
        }
        SearchMatch[] targetMatches = null;
        if (this.m_searchTarget && this.searchString(locText)) {
            targetMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
        }
        SearchMatch[] noteMatches = null;
        if (this.m_searchNotes && entry != null && this.searchString(entry.note)) {
            noteMatches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
        }
        if (!(srcMatches == null && targetMatches == null && noteMatches == null || this.m_searchAuthor && (entry == null || !this.searchAuthor(entry)) || this.m_searchDateBefore && (entry == null || entry.changeDate == 0L || entry.changeDate >= this.m_dateBefore) || this.m_searchDateAfter && (entry == null || entry.changeDate == 0L || entry.changeDate <= this.m_dateAfter))) {
            this.foundString(entryNum, intro, srcText, locText, srcMatches, targetMatches);
        }
    }

    private void searchFiles() throws IOException, TranslationException {
        ArrayList<String> fileList = new ArrayList<String>(256);
        if (!this.m_searchDir.endsWith(File.separator)) {
            this.m_searchDir = this.m_searchDir + File.separator;
        }
        StaticUtils.buildFileList(fileList, new File(this.m_searchDir), this.m_searchRecursive);
        FilterMaster fm = Core.getFilterMaster();
        SearchCallback searchCallback = new SearchCallback(this.m_project.getProjectProperties());
        for (String filename : fileList) {
            IProject.FileInfo fi = new IProject.FileInfo();
            fi.filePath = filename.substring(this.m_searchDir.length());
            searchCallback.setCurrentFile(fi);
            fm.loadFile(filename, new FilterContext(this.m_project.getProjectProperties()), searchCallback);
            searchCallback.fileFinished();
            if (!this.stopCallback.isStopped()) continue;
            return;
        }
    }

    private boolean searchString(String text) {
        if (text == null || this.m_matchers == null || this.m_matchers.isEmpty()) {
            return false;
        }
        this.foundMatches.clear();
        for (Matcher matcher : this.m_matchers) {
            int pos;
            matcher.reset(text);
            if (!matcher.find()) {
                return false;
            }
            do {
                this.foundMatches.add(new SearchMatch(matcher.start(), matcher.end() - matcher.start()));
            } while ((pos = matcher.start()) < text.length() && matcher.find(pos + 1));
        }
        Collections.sort(this.foundMatches);
        int i = 1;
        while (i < this.foundMatches.size()) {
            SearchMatch pr = this.foundMatches.get(i - 1);
            SearchMatch cu = this.foundMatches.get(i);
            if (pr.start <= cu.start && pr.start + pr.length >= cu.start) {
                int end = Math.max(cu.start + cu.length, pr.start + pr.length);
                pr.length = end - pr.start;
                this.foundMatches.remove(i);
                continue;
            }
            ++i;
        }
        return true;
    }

    private boolean searchAuthor(TMXEntry te) {
        if (te == null || this.m_author == null) {
            return false;
        }
        String author = te.changer;
        if (author == null) {
            return te.translation != null && this.m_author.pattern().pattern().equals("");
        }
        if (this.m_author.pattern().pattern().equals("")) {
            return false;
        }
        this.m_author.reset(author);
        return this.m_author.find();
    }

    public void searchText(String seg, String filename) {
        if (this.m_numFinds >= this.m_maxResults) {
            return;
        }
        if (this.stopCallback.isStopped()) {
            return;
        }
        if (this.searchString(seg)) {
            SearchMatch[] matches = this.foundMatches.toArray(new SearchMatch[this.foundMatches.size()]);
            this.foundString(-1, filename, seg, null, matches, null);
        }
    }

    public static interface ISearchCheckStop {
        public boolean isStopped();
    }

    protected class SearchCallback
    extends ParseEntry
    implements IParseCallback {
        private String filename;

        public SearchCallback(ProjectProperties config) {
            super(config);
        }

        public void setCurrentFile(IProject.FileInfo fi) {
            super.setCurrentFile(fi);
            this.filename = fi.filePath;
        }

        protected void fileFinished() {
            super.fileFinished();
        }

        protected void addSegment(String id, short segmentIndex, String segmentSource, String segmentTranslation, boolean segmentTranslationFuzzy, String comment, String prevSegment, String nextSegment, String path) {
            Searcher.this.searchText(segmentSource, this.filename);
        }
    }
}

