/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.util.OStrings;
import org.omegat.util.Token;

public class LevenshteinDistance
implements ISimilarityCalculator {
    private static final int MAX_N = 1000;
    private short[] d = new short[1001];
    private short[] p = new short[1001];

    private static short minimum(int a, int b, int c) {
        return (short)Math.min(a, Math.min(b, c));
    }

    public int compute(Token[] s, Token[] t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException(OStrings.getString("LD_NULL_ARRAYS_ERROR"));
        }
        int n = s.length;
        int m = t.length;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > 1000) {
            n = 1000;
        }
        if (m > 1000) {
            m = 1000;
        }
        Token t_j = null;
        for (i = 0; i <= n; i = (int)((short)(i + 1))) {
            this.p[i] = i;
        }
        for (int j = 1; j <= m; j = (int)((short)(j + 1))) {
            t_j = t[j - 1];
            this.d[0] = j;
            Token s_i = null;
            for (i = 1; i <= n; i = (int)((short)(i + 1))) {
                s_i = s[i - 1];
                short cost = s_i.equals(t_j) ? (short)0 : 1;
                this.d[i] = LevenshteinDistance.minimum(this.d[i - 1] + 1, this.p[i] + 1, this.p[i - 1] + cost);
            }
            short[] swap = this.p;
            this.p = this.d;
            this.d = swap;
        }
        return this.p[n];
    }
}

