/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import bmsi.util.Diff;
import java.util.LinkedList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.matching.ITokenizer;
import org.omegat.util.Token;

public class DiffDriver {
    public static Render render(String original, String revised) {
        Object[] originalStrings = DiffDriver.tokenize(original);
        Object[] revisedStrings = DiffDriver.tokenize(revised);
        Diff diff = new Diff(originalStrings, revisedStrings);
        Diff.change script = diff.diff_2(false);
        assert (DiffDriver.validate(script, (String[])originalStrings, (String[])revisedStrings));
        Render result = new Render();
        StringBuffer rawText = new StringBuffer();
        for (int n = 0; n <= originalStrings.length; ++n) {
            int m;
            int start;
            Diff.change c = DiffDriver.search(n, script);
            if (c == null) {
                if (n >= originalStrings.length) continue;
                rawText.append((String)originalStrings[n]);
                continue;
            }
            script = c.link;
            if (c.deleted > 0) {
                start = rawText.length();
                for (m = 0; m < c.deleted; ++m) {
                    rawText.append((String)originalStrings[n + m]);
                }
                n += c.deleted - 1;
                result.addRun(start, rawText.length() - start, Type.DELETE);
            }
            if (c.inserted <= 0) continue;
            start = rawText.length();
            for (m = 0; m < c.inserted; ++m) {
                rawText.append((String)revisedStrings[c.line1 + m]);
            }
            result.addRun(start, rawText.length() - start, Type.INSERT);
            if (c.deleted != 0 || n >= originalStrings.length) continue;
            rawText.append((String)originalStrings[n]);
        }
        result.text = rawText.toString();
        return result;
    }

    private static Diff.change search(int i, Diff.change script) {
        if (script == null || script.line0 > i) {
            return null;
        }
        if (script.line0 == i) {
            return script;
        }
        return DiffDriver.search(i, script.link);
    }

    private static boolean validate(Diff.change script, String[] original, String[] revised) {
        Diff.change prev = null;
        Diff.change c = script;
        while (c != null) {
            if (prev != null && (c.line0 <= prev.line0 || c.line1 <= prev.line1)) {
                return false;
            }
            if (c.line0 < 0 || c.line0 > original.length) {
                return false;
            }
            prev = c;
            c = c.link;
        }
        return true;
    }

    private static String[] tokenize(String input) {
        ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
        Token[] tokens = tokenizer.tokenizeAllExactly(input);
        String[] strings = new String[tokens.length];
        for (int n = 0; n < tokens.length; ++n) {
            strings[n] = tokens[n].getTextFromString(input);
        }
        return strings;
    }

    public static class TextRun {
        public int start;
        public int length;
        public Type type;

        public TextRun(int start, int length, Type type) {
            assert (start >= 0);
            assert (length >= 1);
            assert (type != null);
            this.start = start;
            this.length = length;
            this.type = type;
        }

        public String toString() {
            return String.format("%s: %d +%d", new Object[]{this.type, this.start, this.length});
        }
    }

    public static class Render {
        public List<TextRun> formatting = new LinkedList<TextRun>();
        public String text;

        public void addRun(int start, int length, Type type) {
            this.formatting.add(new TextRun(start, length, type));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INSERT,
        DELETE;

    }
}

